/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.internal.content;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.annotation.content.TextExtractor;
import org.xwiki.annotation.internal.content.HTMLTextExtractor;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Singleton
public class DefaultTextExtractor
implements TextExtractor {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Logger logger;

    @Override
    public String extractText(String content, Syntax syntax) {
        try {
            HTMLTextExtractor syntaxSpecificTextExtractor = (HTMLTextExtractor)((ComponentManager)this.componentManagerProvider.get()).getInstance(TextExtractor.class, syntax.getType().getId());
            return syntaxSpecificTextExtractor.extractText(content, syntax);
        }
        catch (ComponentLookupException e) {
            this.logger.warn("Could not find an implementation for TextExtractor named [{}]. Root cause: [{}]", (Object)syntax.getType().getId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return content;
        }
    }
}

