/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.annotation.AnnotationConfiguration;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;

@Component
@Singleton
public class DefaultAnnotationConfiguration
implements AnnotationConfiguration {
    @Inject
    @Named(value="annotation")
    protected Provider<ConfigurationSource> configuration;
    @Inject
    @Named(value="currentmixed")
    protected DocumentReferenceResolver<String> resolver;
    @Inject
    protected ModelContext modelContext;
    @Inject
    @Named(value="current")
    protected EntityReferenceProvider entityReferenceProvider;
    @Inject
    protected DocumentAccessBridge dab;
    @Inject
    private Logger logger;

    @Override
    public boolean isInstalled() {
        try {
            return this.dab.exists(new DocumentReference(this.getCurrentWikiReference().getName(), "AnnotationCode", "AnnotationConfig"));
        }
        catch (Exception e) {
            this.logger.error("Failed to test if the annotation configuration page exists", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isActivated() {
        return (Integer)((ConfigurationSource)this.configuration.get()).getProperty("activated", (Object)0) == 1;
    }

    @Override
    public List<SpaceReference> getExceptionSpaces() {
        List exceptionSpaces = (List)((ConfigurationSource)this.configuration.get()).getProperty("exceptionSpaces", List.class);
        ArrayList<SpaceReference> result = new ArrayList<SpaceReference>();
        for (String exceptionSpace : exceptionSpaces) {
            result.add(new SpaceReference(exceptionSpace, this.getCurrentWikiReference()));
        }
        return result;
    }

    @Override
    public boolean isDisplayedByDefault() {
        return (Integer)((ConfigurationSource)this.configuration.get()).getProperty("displayed", (Object)0) == 1;
    }

    @Override
    public boolean isDisplayedHighlightedByDefault() {
        return (Integer)((ConfigurationSource)this.configuration.get()).getProperty("displayHighlight", (Object)0) == 1;
    }

    @Override
    public DocumentReference getAnnotationClassReference() {
        String annotationClassName = (String)((ConfigurationSource)this.configuration.get()).getProperty("annotationClass", (Object)"XWiki.XWikiComments");
        return this.resolver.resolve((Object)annotationClassName, new Object[0]);
    }

    protected WikiReference getCurrentWikiReference() {
        WikiReference wikiReference;
        EntityReference wikiEntityReference = this.entityReferenceProvider.getDefaultReference(EntityType.WIKI);
        return wikiEntityReference instanceof WikiReference ? (wikiReference = (WikiReference)wikiEntityReference) : new WikiReference(wikiEntityReference);
    }
}

