/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal.data;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.activeinstalls2.internal.data.AbstractPingDataProvider;
import org.xwiki.activeinstalls2.internal.data.MemoryPing;
import org.xwiki.activeinstalls2.internal.data.Ping;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="memory")
@Singleton
public class MemoryPingDataProvider
extends AbstractPingDataProvider {
    private static final String PROPERTY_MAX_MEMORY = "max";
    private static final String PROPERTY_TOTAL_MEMORY = "total";
    private static final String PROPERTY_FREE_MEMORY = "free";
    private static final String PROPERTY_USED_MEMORY = "used";
    private static final String PROPERTY_MEMORY = "memory";

    @Override
    public Map<String, Property> provideMapping() {
        HashMap<String, Property> propertiesMap = new HashMap<String, Property>();
        propertiesMap.put(PROPERTY_MAX_MEMORY, Property.of(b1 -> b1.long_(b2 -> b2)));
        propertiesMap.put(PROPERTY_TOTAL_MEMORY, Property.of(b1 -> b1.long_(b2 -> b2)));
        propertiesMap.put(PROPERTY_FREE_MEMORY, Property.of(b1 -> b1.long_(b2 -> b2)));
        propertiesMap.put(PROPERTY_USED_MEMORY, Property.of(b1 -> b1.long_(b2 -> b2)));
        return Collections.singletonMap(PROPERTY_MEMORY, Property.of(b0 -> b0.object(b1 -> (ObjectBuilder)b1.properties(propertiesMap))));
    }

    @Override
    public void provideData(Ping ping) {
        MemoryPing memoryPing = new MemoryPing();
        memoryPing.setMax(Runtime.getRuntime().maxMemory());
        memoryPing.setTotal(Runtime.getRuntime().totalMemory());
        memoryPing.setFree(Runtime.getRuntime().freeMemory());
        memoryPing.setUsed(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        ping.setMemory(memoryPing);
    }
}

