/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal.data;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.activeinstalls2.internal.data.AbstractPingDataProvider;
import org.xwiki.activeinstalls2.internal.data.JavaPing;
import org.xwiki.activeinstalls2.internal.data.Ping;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="java")
@Singleton
public class JavaPingDataProvider
extends AbstractPingDataProvider {
    private static final String PROPERTY_JAVA_VENDOR = "vendor";
    private static final String PROPERTY_JAVA_VERSION = "version";
    private static final String PROPERTY_JAVA_SPECIFICATION_VERSION = "specificationVersion";
    private static final String PROPERTY_JAVA = "java";

    @Override
    public Map<String, Property> provideMapping() {
        HashMap<String, Property> propertiesMap = new HashMap<String, Property>();
        propertiesMap.put(PROPERTY_JAVA_VENDOR, Property.of(b1 -> b1.keyword(b2 -> b2)));
        propertiesMap.put(PROPERTY_JAVA_VERSION, Property.of(b1 -> b1.keyword(b2 -> b2)));
        propertiesMap.put(PROPERTY_JAVA_SPECIFICATION_VERSION, Property.of(b1 -> b1.keyword(b2 -> b2)));
        return Collections.singletonMap(PROPERTY_JAVA, Property.of(b0 -> b0.object(b1 -> (ObjectBuilder)b1.properties(propertiesMap))));
    }

    @Override
    public void provideData(Ping ping) {
        JavaPing javaPing = new JavaPing();
        javaPing.setVendor(System.getProperty("java.vendor"));
        javaPing.setVersion(System.getProperty("java.version"));
        javaPing.setSpecificationVersion(System.getProperty("java.specification.version"));
        ping.setJava(javaPing);
    }
}

