/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal.data;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.activeinstalls2.internal.data.AbstractPingDataProvider;
import org.xwiki.activeinstalls2.internal.data.ExtensionPing;
import org.xwiki.activeinstalls2.internal.data.Ping;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.repository.InstalledExtensionRepository;

@Component
@Named(value="extensions")
@Singleton
public class ExtensionPingDataProvider
extends AbstractPingDataProvider {
    private static final String PROPERTY_ID = "id";
    private static final String PROPERTY_VERSION = "version";
    private static final String PROPERTY_FEATURES = "features";
    private static final String PROPERTY_EXTENSIONS = "extensions";
    @Inject
    private InstalledExtensionRepository extensionRepository;

    @Override
    public Map<String, Property> provideMapping() {
        HashMap<String, Property> propertiesMap = new HashMap<String, Property>();
        propertiesMap.put(PROPERTY_ID, Property.of(b1 -> b1.keyword(b2 -> b2)));
        propertiesMap.put(PROPERTY_VERSION, Property.of(b1 -> b1.keyword(b2 -> b2)));
        propertiesMap.put(PROPERTY_FEATURES, Property.of(b1 -> b1.keyword(b2 -> b2)));
        return Collections.singletonMap(PROPERTY_EXTENSIONS, Property.of(b0 -> b0.nested(b1 -> (ObjectBuilder)b1.properties(propertiesMap))));
    }

    @Override
    public void provideData(Ping ping) {
        ArrayList<ExtensionPing> pingExtensions = new ArrayList<ExtensionPing>();
        Collection installedExtensions = this.extensionRepository.getInstalledExtensions();
        for (InstalledExtension extension : installedExtensions) {
            ExtensionPing extensionPing = new ExtensionPing();
            extensionPing.setId(extension.getId().getId());
            extensionPing.setVersion(extension.getId().getVersion().toString());
            extensionPing.setFeatures(extension.getExtensionFeatures().stream().map(ExtensionId::toString).toList());
            pingExtensions.add(extensionPing);
        }
        ping.setExtensions(pingExtensions);
    }
}

