/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal.data;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.activeinstalls2.internal.ElasticsearchClientManager;
import org.xwiki.activeinstalls2.internal.data.AbstractPingDataProvider;
import org.xwiki.activeinstalls2.internal.data.DatePing;
import org.xwiki.activeinstalls2.internal.data.Ping;
import org.xwiki.component.annotation.Component;
import org.xwiki.instance.InstanceIdManager;

@Component
@Named(value="date")
@Singleton
public class DatePingDataProvider
extends AbstractPingDataProvider {
    private static final String PIPELINE_NAME = "set-timestamp";
    private static final String PROPERTY_PING_DATE = "current";
    private static final String PROPERTY_FIRST_PING_DATE = "first";
    private static final String PROPERTY_SINCE_DAYS = "since";
    private static final String PROPERTY_SERVER_TIME = "serverTime";
    private static final String PROPERTY_DATE = "date";
    @Inject
    private ElasticsearchClientManager clientManager;
    @Inject
    private InstanceIdManager instanceIdManager;

    @Override
    public void setup(ElasticsearchClient client) throws Exception {
        Processor processor1 = Processor.of(b0 -> b0.set(b1 -> b1.field(this.getDateKey(PROPERTY_PING_DATE)).value(JsonData.of((Object)"{{{_ingest.timestamp}}}"))));
        Processor processor2 = Processor.of(b0 -> b0.set(b3 -> b3.override(Boolean.valueOf(false)).field(this.getDateKey(PROPERTY_FIRST_PING_DATE)).value(JsonData.of((Object)String.format("{{{%s}}}", this.getDateKey(PROPERTY_PING_DATE))))));
        client.ingest().putPipeline(b0 -> b0.id(PIPELINE_NAME).description("Set current date to be the server date/time and fill first ping date if empty").processors(processor1, new Processor[]{processor2}));
    }

    @Override
    public Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> provideIndexSettings() {
        return b0 -> b0.index(b1 -> b1.defaultPipeline(PIPELINE_NAME));
    }

    @Override
    public Map<String, Property> provideMapping() {
        HashMap<String, Property> propertiesMap = new HashMap<String, Property>();
        propertiesMap.put(PROPERTY_PING_DATE, Property.of(b1 -> b1.date(b2 -> b2)));
        propertiesMap.put(PROPERTY_FIRST_PING_DATE, Property.of(b1 -> b1.date(b2 -> b2)));
        propertiesMap.put(PROPERTY_SINCE_DAYS, Property.of(b1 -> b1.long_(b2 -> b2)));
        return Collections.singletonMap(PROPERTY_DATE, Property.of(b0 -> b0.object(b1 -> (ObjectBuilder)b1.properties(propertiesMap))));
    }

    @Override
    public void provideData(Ping ping) {
        try {
            SearchResponse search = this.clientManager.getClient().search(s -> s.index("installs3", new String[0]).query(q -> q.term(t -> t.field(this.getDistributionKey("instanceId")).value(v -> v.stringValue(this.instanceIdManager.getInstanceId().toString())))).aggregations(this.getDateKey(PROPERTY_SERVER_TIME), a1 -> a1.min(m -> (ObjectBuilder)m.script(s2 -> s2.inline(i -> i.source("new Date().getTime()"))))).aggregations(this.getDateKey(PROPERTY_FIRST_PING_DATE), a2 -> a2.min(m2 -> (ObjectBuilder)m2.field(this.getDateKey(PROPERTY_FIRST_PING_DATE)))), Ping.class);
            DatePing datePing = new DatePing();
            if (!search.hits().hits().isEmpty()) {
                Aggregate serverTimeAggregate = (Aggregate)search.aggregations().get(this.getDateKey(PROPERTY_SERVER_TIME));
                Aggregate firstPingDateAggregate = (Aggregate)search.aggregations().get(this.getDateKey(PROPERTY_FIRST_PING_DATE));
                if (firstPingDateAggregate != null && serverTimeAggregate != null) {
                    double serverTime = serverTimeAggregate.min().value();
                    double firstPingDate = firstPingDateAggregate.min().value();
                    long sinceDays = Math.round((serverTime - firstPingDate) / 8.64E7);
                    datePing.setSince(sinceDays);
                    datePing.setFirst(new Date(Math.round(firstPingDate)));
                } else {
                    datePing.setSince(0L);
                }
            } else {
                datePing.setSince(0L);
            }
            ping.setDate(datePing);
        }
        catch (Exception e) {
            this.logWarning("Failed to compute the first ping date and the number of elapsed days since the first ping", e);
        }
    }

    private String getDateKey(String suffix) {
        return this.getKey(PROPERTY_DATE, suffix);
    }

    private String getDistributionKey(String suffix) {
        return this.getKey("distribution", suffix);
    }

    private String getKey(String prefix, String suffix) {
        return String.format("%s.%s", prefix, suffix);
    }
}

