/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.activeinstalls2.internal.ElasticsearchClientManager;
import org.xwiki.activeinstalls2.internal.PingDataProvider;
import org.xwiki.activeinstalls2.internal.PingSetup;
import org.xwiki.component.annotation.Component;

@Component
@Singleton
public class DefaultPingSetup
implements PingSetup {
    @Inject
    private ElasticsearchClientManager clientManager;
    @Inject
    private Provider<List<PingDataProvider>> pingDataProviderProvider;

    @Override
    public void setup() throws Exception {
        ElasticsearchClient client = this.clientManager.getClient();
        if (client != null) {
            this.setup(client);
            this.createIndex(client);
            client.indices().putMapping(builder -> builder.index("installs3", new String[0]).properties(this.provideMapping()));
        }
    }

    private void setup(ElasticsearchClient client) throws Exception {
        for (PingDataProvider pingDataProvider : (List)this.pingDataProviderProvider.get()) {
            pingDataProvider.setup(client);
        }
    }

    private void createIndex(ElasticsearchClient client) throws Exception {
        block2: {
            try {
                client.indices().create(builder -> builder.index("installs3").settings(this.provideIndexSettings()));
            }
            catch (ElasticsearchException e) {
                if (e.response().error().type().equals("resource_already_exists_exception")) break block2;
                throw e;
            }
        }
    }

    private IndexSettings provideIndexSettings() {
        IndexSettings.Builder builder = new IndexSettings.Builder();
        for (PingDataProvider pingDataProvider : (List)this.pingDataProviderProvider.get()) {
            pingDataProvider.provideIndexSettings().apply(builder);
        }
        return builder.build();
    }

    private Map<String, Property> provideMapping() {
        HashMap<String, Property> propertiesMap = new HashMap<String, Property>();
        for (PingDataProvider pingDataProvider : (List)this.pingDataProviderProvider.get()) {
            propertiesMap.putAll(pingDataProvider.provideMapping());
        }
        return propertiesMap;
    }
}

