/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal;

import co.elastic.clients.elasticsearch.core.CountRequest;
import co.elastic.clients.elasticsearch.core.CountResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.activeinstalls2.DataManager;
import org.xwiki.activeinstalls2.internal.ElasticsearchClientManager;
import org.xwiki.activeinstalls2.internal.data.Ping;
import org.xwiki.component.annotation.Component;

@Component
@Singleton
public class DefaultDataManager
implements DataManager {
    @Inject
    private ElasticsearchClientManager clientManager;

    @Override
    public long countInstalls(String jsonQuery) throws Exception {
        CountRequest request = StringUtils.isEmpty((CharSequence)jsonQuery) ? CountRequest.of(s -> s.index("installs3", new String[0])) : CountRequest.of(s -> s.index("installs3", new String[0]).query(b0 -> b0.wrapper(b1 -> b1.query(this.encodeJSON(jsonQuery)))));
        CountResponse count = this.clientManager.getClient().count(request);
        return count.count();
    }

    @Override
    public List<Ping> searchInstalls(String jsonQuery) throws Exception {
        SearchRequest request = StringUtils.isEmpty((CharSequence)jsonQuery) ? SearchRequest.of(s -> s.index("installs3", new String[0])) : SearchRequest.of(s -> s.index("installs3", new String[0]).query(b0 -> b0.wrapper(b1 -> b1.query(this.encodeJSON(jsonQuery)))));
        SearchResponse search = this.clientManager.getClient().search(request, Ping.class);
        ArrayList<Ping> results = new ArrayList<Ping>();
        if (!search.hits().hits().isEmpty()) {
            for (Hit hit : search.hits().hits()) {
                results.add((Ping)hit.source());
            }
        }
        return results;
    }

    private String encodeJSON(String json) {
        return Base64.getEncoder().encodeToString(json.getBytes());
    }
}

