/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.job.AbstractJobStatus;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.job.JobManagerConfiguration;
import org.xwiki.job.JobStatusStore;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.internal.JobStatusFolderResolver;
import org.xwiki.job.internal.JobStatusSerializer;
import org.xwiki.job.internal.JobUtils;
import org.xwiki.logging.LogQueue;
import org.xwiki.logging.LoggerManager;
import org.xwiki.logging.tail.LoggerTail;

@Component
@Singleton
public class DefaultJobStatusStore
implements JobStatusStore,
Initializable {
    private static final int VERSION = 1;
    private static final String FILENAME_STATUS_XML = "status.xml";
    private static final String FILENAME_STATUS_ZIP = "status.xml.zip";
    private static final String INDEX_FILE = "store.properties";
    private static final String INDEX_FILE_VERSION = "version";
    private static final String STATUS_LOG_PREFIX = "log";
    private static final JobStatus NOSTATUS = new DefaultJobStatus(null, null, null, null, null);
    @Inject
    private JobManagerConfiguration configuration;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private LoggerManager loggerManager;
    @Inject
    private JobStatusSerializer serializer;
    @Inject
    private List<JobStatusFolderResolver> folderResolvers;
    @Inject
    private Logger logger;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private ExecutorService executorService;
    private Cache<JobStatus> cache;

    public void initialize() throws InitializationException {
        try {
            File folder = this.configuration.getStorage();
            File file = new File(folder, INDEX_FILE);
            FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class, null, true).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().properties().setFile(file)});
            PropertiesConfiguration properties = (PropertiesConfiguration)builder.getConfiguration();
            int version = properties.getInt(INDEX_FILE_VERSION, 0);
            if (1 > version) {
                this.repair();
                properties.setProperty(INDEX_FILE_VERSION, (Object)1);
                builder.save();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to load jobs", (Throwable)e);
        }
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("Job status serializer").daemon(true).priority(1).build();
        this.executorService = new ThreadPoolExecutor(0, 10, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)threadFactory);
        LRUCacheConfiguration cacheConfiguration = new LRUCacheConfiguration("job.status", this.configuration.getJobStatusCacheSize());
        try {
            this.cache = this.cacheManager.createNewCache((CacheConfiguration)cacheConfiguration);
        }
        catch (CacheException e) {
            throw new InitializationException("Failed to initialize job status cache", (Throwable)e);
        }
    }

    private String toUniqueString(List<String> id) {
        return StringUtils.join(id, (char)'/');
    }

    private void repair() throws IOException {
        File folder = this.configuration.getStorage();
        if (folder.exists()) {
            if (!folder.isDirectory()) {
                throw new IOException("Not a directory: " + String.valueOf(folder));
            }
            this.repairFolder(folder);
        }
    }

    private void repairFolder(File folder) {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                this.repairFolder(file);
                continue;
            }
            if (!file.getName().equals(FILENAME_STATUS_ZIP) && !file.getName().equals(FILENAME_STATUS_XML)) continue;
            try {
                File properFolder;
                JobStatus status = this.loadStatus(folder);
                if (status == null || folder.equals(properFolder = this.getAndMoveJobFolder(status.getRequest().getId(), false))) continue;
                this.moveJobStatus(folder, file, properFolder);
            }
            catch (Exception e) {
                this.logger.warn("Failed to load job status in folder [{}]", (Object)folder, (Object)e);
            }
        }
    }

    private void moveJobStatus(File sourceDirectory, File statusFile, File targetDirectory) {
        try {
            File targetStatusZip = new File(targetDirectory, FILENAME_STATUS_ZIP);
            File targetStatus = new File(targetDirectory, FILENAME_STATUS_XML);
            long sourceLastModified = statusFile.lastModified();
            long targetLastModified = Math.max(targetStatusZip.lastModified(), targetStatus.lastModified());
            if (sourceLastModified > targetLastModified) {
                if (targetDirectory.isDirectory()) {
                    DefaultJobStatusStore.deleteJobStatusFiles(targetDirectory);
                }
                FileUtils.moveFileToDirectory((File)statusFile, (File)targetDirectory, (boolean)true);
                for (File file : sourceDirectory.listFiles()) {
                    if (file.isDirectory() || !file.getName().startsWith(STATUS_LOG_PREFIX)) continue;
                    FileUtils.moveFileToDirectory((File)file, (File)targetDirectory, (boolean)true);
                }
            } else {
                DefaultJobStatusStore.deleteJobStatusFiles(sourceDirectory);
            }
            this.cleanEmptyDirectories(sourceDirectory);
        }
        catch (IOException e) {
            this.logger.error("Failed to move job status and log files, and cleaning up", (Throwable)e);
        }
    }

    private void cleanEmptyDirectories(File sourceDirectory) throws IOException {
        Path storagePath = this.configuration.getStorage().toPath();
        for (Path sourcePath = sourceDirectory.toPath(); !Objects.equals(storagePath, sourcePath) && sourcePath != null && DefaultJobStatusStore.isDirEmpty(sourcePath); sourcePath = sourcePath.getParent()) {
            Files.delete(sourcePath);
        }
    }

    private static boolean isDirEmpty(Path directory) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobStatus loadStatus(File folder) throws IOException {
        this.readLock.lock();
        try {
            File statusFile = DefaultJobStatusStore.getStatusFile(folder);
            if (statusFile.exists()) {
                JobStatus status = this.loadJobStatus(statusFile);
                for (JobStatus child : folder.listFiles()) {
                    if (child.isDirectory() || !child.getName().startsWith(STATUS_LOG_PREFIX)) continue;
                    try {
                        LoggerTail loggerTail = this.createLoggerTail(new File(folder, STATUS_LOG_PREFIX), true);
                        if (!(status instanceof AbstractJobStatus)) break;
                        ((AbstractJobStatus)status).setLoggerTail(loggerTail);
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to load the job status log in [{}]", (Object)folder, (Object)e);
                    }
                    break;
                }
                JobStatus jobStatus = status;
                return jobStatus;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    private static File getStatusFile(File folder) {
        File statusFile = new File(folder, FILENAME_STATUS_ZIP);
        if (!statusFile.exists()) {
            statusFile = new File(folder, FILENAME_STATUS_XML);
        }
        return statusFile;
    }

    private JobStatus loadJobStatus(File statusFile) throws IOException {
        return this.serializer.read(statusFile);
    }

    private File getAndMoveJobFolder(List<String> id, boolean moveToCurrent) {
        JobStatusFolderResolver currentResolver = this.folderResolvers.get(0);
        File folder = currentResolver.getFolder(id);
        if (moveToCurrent && !DefaultJobStatusStore.getStatusFile(folder).exists()) {
            File previousFolder = null;
            File previousStatusFile = null;
            for (JobStatusFolderResolver folderResolver : this.folderResolvers.subList(1, this.folderResolvers.size())) {
                File f = folderResolver.getFolder(id);
                File s = DefaultJobStatusStore.getStatusFile(f);
                if (!s.exists()) continue;
                previousFolder = f;
                previousStatusFile = s;
                break;
            }
            if (previousFolder != null) {
                this.moveJobStatus(previousFolder, previousStatusFile, folder);
            }
        }
        return folder;
    }

    private File getJobLogBaseFile(List<String> id) {
        return new File(this.getAndMoveJobFolder(id, true), STATUS_LOG_PREFIX);
    }

    private void saveJobStatus(JobStatus status) {
        try {
            this.writeLock.lock();
            try {
                File statusFile = this.getAndMoveJobFolder(status.getRequest().getId(), true);
                statusFile = new File(statusFile, FILENAME_STATUS_ZIP);
                this.logger.debug("Serializing status [{}] in [{}]", (Object)status.getRequest().getId(), (Object)statusFile);
                this.serializer.write(status, statusFile);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to save job status [{}]", (Object)status, (Object)e);
        }
    }

    public JobStatus getJobStatus(List<String> id) {
        String idString = this.toUniqueString(id);
        JobStatus status = (JobStatus)this.cache.get(idString);
        if (status == null) {
            status = this.maybeLoadStatus(id, idString);
        }
        return status == NOSTATUS ? null : status;
    }

    private synchronized JobStatus maybeLoadStatus(List<String> id, String idString) {
        JobStatus status = (JobStatus)this.cache.get(idString);
        if (status == null) {
            try {
                status = this.loadStatus(this.getAndMoveJobFolder(id, true));
                this.cache.set(idString, (Object)status);
            }
            catch (Exception e) {
                this.logger.warn("Failed to load job status for id {}", id, (Object)e);
                this.cache.remove(idString);
            }
        }
        return status;
    }

    public void store(JobStatus status) {
        this.store(status, false);
    }

    public void storeAsync(JobStatus status) {
        this.store(status, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(JobStatus status, boolean async) {
        if (status != null && status.getRequest() != null && status.getRequest().getId() != null) {
            Cache<JobStatus> cache = this.cache;
            synchronized (cache) {
                String id = this.toUniqueString(status.getRequest().getId());
                this.logger.debug("Store status [{}] in cache", (Object)id);
                this.cache.set(id, (Object)status);
            }
            if (JobUtils.isSerializable((JobStatus)status)) {
                if (async) {
                    this.executorService.execute(new JobStatusSerializerRunnable(status));
                } else {
                    this.saveJobStatus(status);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(List<String> id) {
        this.writeLock.lock();
        try {
            for (JobStatusFolderResolver folderResolver : this.folderResolvers) {
                File jobFolder = folderResolver.getFolder(id);
                if (!jobFolder.isDirectory()) continue;
                try {
                    DefaultJobStatusStore.deleteJobStatusFiles(jobFolder);
                    this.cleanEmptyDirectories(jobFolder);
                }
                catch (IOException e) {
                    this.logger.warn("Failed to delete job folder [{}]", (Object)jobFolder, (Object)e);
                }
            }
            this.cache.remove(this.toUniqueString(id));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static void deleteJobStatusFiles(File jobFolder) throws IOException {
        for (File file : jobFolder.listFiles()) {
            if (file.isDirectory() || !file.getName().startsWith(STATUS_LOG_PREFIX) && !file.getName().startsWith(FILENAME_STATUS_XML)) continue;
            Files.delete(file.toPath());
        }
    }

    public LoggerTail createLoggerTail(List<String> jobId, boolean readonly) {
        if (jobId != null) {
            try {
                return this.createLoggerTail(this.getJobLogBaseFile(jobId), readonly);
            }
            catch (Exception e) {
                this.logger.error("Failed to create a logger tail for job [{}]", jobId, (Object)e);
            }
        }
        return new LogQueue();
    }

    private LoggerTail createLoggerTail(File logBaseFile, boolean readonly) throws IOException {
        return this.loggerManager.createLoggerTail(logBaseFile.toPath(), readonly);
    }

    public void flushCache() {
        this.cache.removeAll();
    }

    class JobStatusSerializerRunnable
    implements Runnable {
        private final JobStatus status;

        JobStatusSerializerRunnable(JobStatus status) {
            this.status = status;
        }

        @Override
        public void run() {
            DefaultJobStatusStore.this.saveJobStatus(this.status);
        }
    }
}

