/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xml.internal.output;

import java.io.IOException;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.output.OutputStreamOutputTarget;
import org.xwiki.filter.output.OutputTarget;
import org.xwiki.filter.output.WriterOutputTarget;
import org.xwiki.filter.xml.output.ResultOutputTarget;
import org.xwiki.filter.xml.output.XMLOutputProperties;
import org.xwiki.xml.stax.StAXUtils;

public final class XMLOutputFilterStreamUtils {
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();

    public static XMLStreamWriter createXMLStreamWriter(XMLOutputProperties properties) throws XMLStreamException, IOException, FilterException {
        return XMLOutputFilterStreamUtils.createXMLStreamWriter(XML_OUTPUT_FACTORY, properties);
    }

    public static XMLStreamWriter createXMLStreamWriter(XMLOutputFactory factory, XMLOutputProperties properties) throws XMLStreamException, IOException, FilterException {
        XMLStreamWriter xmlStreamWriter;
        OutputTarget target = properties.getTarget();
        if (target instanceof WriterOutputTarget) {
            xmlStreamWriter = XMLOutputFilterStreamUtils.getXMLOutputFactory(factory).createXMLStreamWriter(((WriterOutputTarget)target).getWriter());
        } else if (target instanceof OutputStreamOutputTarget) {
            xmlStreamWriter = XMLOutputFilterStreamUtils.getXMLOutputFactory(factory).createXMLStreamWriter(((OutputStreamOutputTarget)target).getOutputStream(), properties.getEncoding());
        } else if (target instanceof ResultOutputTarget) {
            xmlStreamWriter = StAXUtils.getXMLStreamWriter((Result)((ResultOutputTarget)target).getResult());
        } else {
            throw new FilterException("Unknown target type [" + String.valueOf(target.getClass()) + "]");
        }
        if (properties.isFormat()) {
            xmlStreamWriter = new IndentingXMLStreamWriter(xmlStreamWriter);
        }
        return xmlStreamWriter;
    }

    private static XMLOutputFactory getXMLOutputFactory(XMLOutputFactory factory) {
        return factory != null ? factory : XML_OUTPUT_FACTORY;
    }
}

