/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xml.internal.output;

import java.io.OutputStream;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.xml.internal.output.XMLOutputFilterStreamUtils;
import org.xwiki.filter.xml.output.XMLOutputProperties;

public class FilterStreamXMLStreamWriter {
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private final XMLStreamWriter writer;
    private final boolean printNullValue;

    public FilterStreamXMLStreamWriter(XMLStreamWriter writer, boolean printNullValue) {
        this.writer = writer;
        this.printNullValue = printNullValue;
    }

    public FilterStreamXMLStreamWriter(OutputStream outputStream, String encoding, boolean format, boolean printNullValue) throws FilterException {
        try {
            XMLStreamWriter streamWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(outputStream, encoding);
            this.writer = format ? new IndentingXMLStreamWriter(streamWriter) : streamWriter;
        }
        catch (Exception e) {
            throw new FilterException("Failed to create XML writer", (Throwable)e);
        }
        this.printNullValue = printNullValue;
    }

    public FilterStreamXMLStreamWriter(XMLOutputProperties properties, boolean printNullValue) throws FilterException {
        try {
            this.writer = XMLOutputFilterStreamUtils.createXMLStreamWriter(properties);
        }
        catch (Exception e) {
            throw new FilterException("Failed to create XML writer", (Throwable)e);
        }
        this.printNullValue = printNullValue;
    }

    public XMLStreamWriter getWriter() {
        return this.writer;
    }

    public void writeStartDocument() throws FilterException {
        try {
            this.writer.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw new FilterException("Failed to write start document", (Throwable)e);
        }
    }

    public void writeStartDocument(String encoding, String version) throws FilterException {
        try {
            this.writer.writeStartDocument(encoding, version);
        }
        catch (XMLStreamException e) {
            throw new FilterException("Failed to write start document", (Throwable)e);
        }
    }

    public void writeEndDocument() throws FilterException {
        try {
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new FilterException("Failed to write end document", (Throwable)e);
        }
    }

    public void writeEmptyElement(String localName) throws FilterException {
        try {
            this.writer.writeEmptyElement(localName);
        }
        catch (XMLStreamException e) {
            throw new FilterException(String.format("Failed to write empty element [%s]", localName), (Throwable)e);
        }
    }

    public void writeElement(String localName, String value) throws FilterException {
        if (value != null) {
            if (value.isEmpty()) {
                this.writeEmptyElement(localName);
            } else {
                this.writeStartElement(localName);
                this.writeCharacters(value);
                this.writeEndElement();
            }
        } else if (this.printNullValue) {
            this.writeEmptyElement(localName);
        }
    }

    public void writeCharacters(String text) throws FilterException {
        try {
            this.writer.writeCharacters(text);
        }
        catch (XMLStreamException e) {
            throw new FilterException(String.format("Failed to write characters [%s]", text), (Throwable)e);
        }
    }

    public void writeStartElement(String localName) throws FilterException {
        try {
            this.writer.writeStartElement(localName);
        }
        catch (XMLStreamException e) {
            throw new FilterException(String.format("Failed to write start element [%s]", localName), (Throwable)e);
        }
    }

    public void writeEndElement() throws FilterException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new FilterException("Failed to write end element", (Throwable)e);
        }
    }

    public void writeAttribute(String localName, String value) throws FilterException {
        if (value != null) {
            try {
                this.writer.writeAttribute(localName, value);
            }
            catch (XMLStreamException e) {
                throw new FilterException(String.format("Failed to write attribute [%s] with value [%s]", localName, value), (Throwable)e);
            }
        }
    }

    public void writeCharacters(char[] text, int start, int len) throws FilterException {
        try {
            this.writer.writeCharacters(text, start, len);
        }
        catch (XMLStreamException e) {
            throw new FilterException("Failed to write characters", (Throwable)e);
        }
    }

    public void close() throws FilterException {
        try {
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new FilterException("Failed to close writer", (Throwable)e);
        }
    }

    public void flush() throws FilterException {
        try {
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            throw new FilterException("Failed to flush writer", (Throwable)e);
        }
    }
}

