/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xml.internal.output;

import java.io.Closeable;
import java.io.IOException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.stax.StAXResult;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.output.OutputFilterStream;
import org.xwiki.filter.output.OutputTarget;
import org.xwiki.filter.xml.internal.output.XMLOutputFilterStreamUtils;
import org.xwiki.filter.xml.output.ResultOutputTarget;
import org.xwiki.filter.xml.output.XMLOutputProperties;

public abstract class AbstractXMLOutputFilterStream<P extends XMLOutputProperties>
implements OutputFilterStream {
    protected final P properties;
    protected final Result result;
    protected Object filter;

    public AbstractXMLOutputFilterStream(P properties, XMLOutputFactory xmlFactory) throws FilterException, XMLStreamException, IOException {
        this.properties = properties;
        this.result = this.createResult(this.properties, xmlFactory);
    }

    protected Result createResult(P properties, XMLOutputFactory xmlfactory) throws FilterException, XMLStreamException, IOException {
        Result result;
        OutputTarget target = ((XMLOutputProperties)((Object)properties)).getTarget();
        if (target instanceof ResultOutputTarget) {
            result = ((ResultOutputTarget)target).getResult();
        } else {
            XMLStreamWriter xmlStreamWriter = XMLOutputFilterStreamUtils.createXMLStreamWriter(xmlfactory, properties);
            result = new StAXResult(xmlStreamWriter);
        }
        return result;
    }

    public Object getFilter() throws FilterException {
        if (this.filter == null) {
            try {
                this.filter = this.createFilter(this.properties);
            }
            catch (Exception e) {
                throw new FilterException("Failed to create filter", (Throwable)e);
            }
        }
        return this.filter;
    }

    protected abstract Object createFilter(P var1) throws XMLStreamException, FactoryConfigurationError, FilterException;

    public void close() throws IOException {
        if (this.filter instanceof Closeable) {
            ((Closeable)this.filter).close();
        }
        ((XMLOutputProperties)((Object)this.properties)).getTarget().close();
    }
}

