/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xml.internal.input;

import java.io.IOException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.input.InputStreamInputSource;
import org.xwiki.filter.input.ReaderInputSource;
import org.xwiki.filter.xml.input.SourceInputSource;
import org.xwiki.filter.xml.input.XMLInputProperties;
import org.xwiki.xml.stax.StAXUtils;

public final class XMLInputFilterStreamUtils {
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();

    public static XMLEventReader createXMLEventReader(XMLInputProperties properties) throws XMLStreamException, IOException, FilterException {
        return XMLInputFilterStreamUtils.createXMLEventReader(XML_INPUT_FACTORY, properties);
    }

    public static XMLEventReader createXMLEventReader(XMLInputFactory factory, XMLInputProperties properties) throws XMLStreamException, IOException, FilterException {
        XMLEventReader xmlEventReader;
        InputSource source = properties.getSource();
        if (source instanceof ReaderInputSource) {
            xmlEventReader = XMLInputFilterStreamUtils.getXMLInputFactory(factory).createXMLEventReader(((ReaderInputSource)source).getReader());
        } else if (source instanceof InputStreamInputSource) {
            xmlEventReader = XMLInputFilterStreamUtils.getXMLInputFactory(factory).createXMLEventReader(((InputStreamInputSource)source).getInputStream());
        } else if (source instanceof SourceInputSource) {
            xmlEventReader = StAXUtils.getXMLEventReader((Source)((SourceInputSource)source).getSource());
        } else {
            throw new FilterException("Unknown source type [" + String.valueOf(source.getClass()) + "]");
        }
        return xmlEventReader;
    }

    public static XMLStreamReader createXMLStreamReader(XMLInputProperties properties) throws XMLStreamException, IOException, FilterException {
        XMLStreamReader xmlStreamReader;
        InputSource source = properties.getSource();
        if (source instanceof ReaderInputSource) {
            xmlStreamReader = XML_INPUT_FACTORY.createXMLStreamReader(((ReaderInputSource)source).getReader());
        } else if (source instanceof InputStreamInputSource) {
            xmlStreamReader = XML_INPUT_FACTORY.createXMLStreamReader(((InputStreamInputSource)source).getInputStream());
        } else if (source instanceof SourceInputSource) {
            xmlStreamReader = StAXUtils.getXMLStreamReader((Source)((SourceInputSource)source).getSource());
        } else {
            throw new FilterException("Unknown source type [" + String.valueOf(source.getClass()) + "]");
        }
        return xmlStreamReader;
    }

    private static XMLInputFactory getXMLInputFactory(XMLInputFactory factory) {
        return factory != null ? factory : XML_INPUT_FACTORY;
    }
}

