/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.filterxml.internal.output;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Result;
import org.apache.commons.lang3.ArrayUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.UnknownFilter;
import org.xwiki.filter.filterxml.internal.input.XMLInputFilterFactory;
import org.xwiki.filter.filterxml.output.FilterXMLOutputProperties;
import org.xwiki.filter.input.InputFilterStreamFactory;
import org.xwiki.filter.type.FilterStreamType;
import org.xwiki.filter.xml.internal.output.AbstractXMLBeanOutputFilterStreamFactory;
import org.xwiki.filter.xml.serializer.XMLSerializerFactory;

@Component
@Named(value="filter+xml")
@Singleton
public class XMLOutputFilterFactory
extends AbstractXMLBeanOutputFilterStreamFactory<FilterXMLOutputProperties, Object> {
    @Inject
    private XMLSerializerFactory serializerFactory;
    @Inject
    private Provider<ComponentManager> contextComponentManager;

    public XMLOutputFilterFactory() {
        super(FilterStreamType.FILTER_XML);
        this.setName("Generic XML output stream");
        this.setDescription("Write generic XML from wiki events.");
        this.xmlFactory = XMLOutputFactory.newInstance();
        this.xmlFactory.setProperty("com.ctc.wstx.outputValidateStructure", false);
    }

    public Collection<Class<?>> getFilterInterfaces() throws FilterException {
        List factories;
        try {
            factories = ((ComponentManager)this.contextComponentManager.get()).getInstanceList(InputFilterStreamFactory.class);
        }
        catch (ComponentLookupException e) {
            throw new FilterException("Failed to lookup InputFilterFactory components instances", (Throwable)e);
        }
        HashSet filters = new HashSet();
        filters.add(UnknownFilter.class);
        for (InputFilterStreamFactory factory : factories) {
            if (factory.getClass() == XMLInputFilterFactory.class) continue;
            filters.addAll(factory.getFilterInterfaces());
        }
        return filters;
    }

    protected Object createListener(Result result, FilterXMLOutputProperties properties) throws XMLStreamException, FactoryConfigurationError, FilterException {
        return this.serializerFactory.createSerializer(this.getFilterInterfaces().toArray(ArrayUtils.EMPTY_CLASS_ARRAY), result, null);
    }
}

