/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.output;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.filter.AbstractBeanFilterStreamFactory;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.output.BeanOutputFilterStream;
import org.xwiki.filter.output.BeanOutputFilterStreamFactory;
import org.xwiki.filter.output.OutputFilterStream;
import org.xwiki.filter.type.FilterStreamType;

public abstract class AbstractBeanOutputFilterStreamFactory<P, F>
extends AbstractBeanFilterStreamFactory<P>
implements BeanOutputFilterStreamFactory<P> {
    @Inject
    private ComponentManager componentManager;
    private List<Class<?>> filerInterfaces;

    public AbstractBeanOutputFilterStreamFactory(FilterStreamType type) {
        super(type);
    }

    @Override
    public void initialize() throws InitializationException {
        super.initialize();
        ParameterizedType genericType = (ParameterizedType)ReflectionUtils.resolveType(AbstractBeanOutputFilterStreamFactory.class, this.getClass());
        this.filerInterfaces = Arrays.asList(ReflectionUtils.getTypeClass((Type)genericType.getActualTypeArguments()[1]));
    }

    @Override
    public Collection<Class<?>> getFilterInterfaces() throws FilterException {
        return this.filerInterfaces;
    }

    @Override
    public OutputFilterStream createOutputFilterStream(Map<String, Object> properties) throws FilterException {
        return this.createOutputFilterStream(this.createPropertiesBean(properties));
    }

    @Override
    public BeanOutputFilterStream<P> createOutputFilterStream(P properties) throws FilterException {
        BeanOutputFilterStream outputFilter;
        try {
            outputFilter = (BeanOutputFilterStream)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, BeanOutputFilterStream.class, new Type[]{this.getPropertiesBeanClass()}), this.getType().serialize());
        }
        catch (ComponentLookupException e) {
            throw new FilterException(String.format("Failed to get instance of [%s] for type [%s]", BeanOutputFilterStream.class, this.getType()), e);
        }
        outputFilter.setProperties(properties);
        return outputFilter;
    }
}

