/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.internal.output;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.output.DefaultFileOutputTarget;
import org.xwiki.filter.output.DefaultOutputStreamOutputTarget;
import org.xwiki.filter.output.DefaultWriterOutputTarget;
import org.xwiki.filter.output.OutputTarget;
import org.xwiki.filter.output.OutputTargetReferenceParser;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

@Component
@Singleton
public class OutputTargetConverter
extends AbstractConverter<OutputTarget> {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;
    @Inject
    private OutputTargetReferenceParser parser;

    protected <G extends OutputTarget> G convertToType(Type targetType, Object value) {
        OutputTarget outputTarget;
        if (value == null) {
            return null;
        }
        if (value instanceof OutputTarget) {
            return (G)((OutputTarget)value);
        }
        if (value instanceof String) {
            outputTarget = this.fromString(value.toString());
        } else if (value instanceof OutputStream) {
            outputTarget = new DefaultOutputStreamOutputTarget((OutputStream)value);
        } else if (value instanceof File) {
            outputTarget = new DefaultFileOutputTarget((File)value);
        } else if (value instanceof Writer) {
            outputTarget = new DefaultWriterOutputTarget((Writer)value);
        } else {
            ParameterizedType componentRole = TypeUtils.parameterize(org.xwiki.filter.output.OutputTargetConverter.class, (Type[])new Type[]{value.getClass()});
            ComponentManager componentManager = (ComponentManager)this.contextComponentManagerProvider.get();
            if (componentManager.hasComponent((Type)componentRole)) {
                try {
                    org.xwiki.filter.output.OutputTargetConverter converter = (org.xwiki.filter.output.OutputTargetConverter)componentManager.getInstance((Type)componentRole);
                    outputTarget = converter.convert(value);
                }
                catch (ComponentLookupException e) {
                    throw new ConversionException("Failed to get the output target converter component for type [" + String.valueOf(value.getClass()) + "]", (Throwable)e);
                }
            } else {
                outputTarget = this.fromString(value.toString());
            }
        }
        return (G)outputTarget;
    }

    private OutputTarget fromString(String target) {
        try {
            return this.parser.parse(target);
        }
        catch (FilterException e) {
            throw new ConversionException("Failed to parse the output target reference [" + target + "]", (Throwable)e);
        }
    }
}

