/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.internal.input;

import java.io.File;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.DefaultFileInputSource;
import org.xwiki.filter.input.DefaultURLInputSource;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.input.InputSourceReferenceParser;
import org.xwiki.filter.input.StringInputSource;
import org.xwiki.properties.converter.ConversionException;

@Component
@Singleton
public class DefaultInputSourceReferenceParser
implements InputSourceReferenceParser {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;

    @Override
    public InputSource parse(String reference) throws FilterException {
        InputSource inputSource;
        if (reference == null) {
            return null;
        }
        int index = reference.indexOf(58);
        if (index > 0) {
            String prefix = reference.substring(0, index);
            String value = reference.substring(index + 1);
            if (prefix.equals("url")) {
                try {
                    inputSource = new DefaultURLInputSource(new URL(value));
                }
                catch (Exception e) {
                    throw new ConversionException("Failed to create input source for URL [" + reference + "]", (Throwable)e);
                }
            }
            if (prefix.equals("file")) {
                inputSource = new DefaultFileInputSource(new File(value));
            } else if (prefix.equals("string")) {
                inputSource = new StringInputSource(value);
            } else if (prefix.equals("resource")) {
                ClassLoader classloader = Thread.currentThread().getContextClassLoader();
                URL resource = classloader.getResource(value);
                inputSource = new DefaultURLInputSource(resource);
            } else {
                ComponentManager componentManager = (ComponentManager)this.contextComponentManagerProvider.get();
                if (componentManager.hasComponent(InputSourceReferenceParser.class, prefix)) {
                    InputSourceReferenceParser parser;
                    try {
                        parser = (InputSourceReferenceParser)componentManager.getInstance(InputSourceReferenceParser.class, prefix);
                    }
                    catch (ComponentLookupException e) {
                        throw new FilterException("Failed to get the input source reference parser component for prefix [" + prefix + "]", e);
                    }
                    inputSource = parser.parse(value);
                } else {
                    inputSource = new StringInputSource(reference);
                }
            }
        } else {
            inputSource = new StringInputSource(reference);
        }
        return inputSource;
    }
}

