/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.xwiki.filter.input.InputStreamInputSource;

public class DefaultInputStreamInputSource
implements InputStreamInputSource {
    private final InputStream inputStream;
    private final boolean close;

    public DefaultInputStreamInputSource(InputStream inputStream) {
        this(inputStream, false);
    }

    public DefaultInputStreamInputSource(InputStream inputStream, boolean close) {
        this.inputStream = inputStream;
        this.close = close;
    }

    @Override
    public boolean restartSupported() {
        return false;
    }

    @Override
    public InputStream getInputStream() {
        return this.close ? this.inputStream : CloseShieldInputStream.wrap((InputStream)this.inputStream);
    }

    @Override
    public void close() throws IOException {
        if (this.close) {
            this.inputStream.close();
        }
    }

    public String toString() {
        return this.getInputStream().toString();
    }
}

