/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Inject;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.filter.AbstractFilterStreamFactory;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.FilterStreamFactory;
import org.xwiki.filter.descriptor.DefaultFilterStreamBeanDescriptor;
import org.xwiki.filter.type.FilterStreamType;
import org.xwiki.properties.BeanManager;

public abstract class AbstractBeanFilterStreamFactory<P>
extends AbstractFilterStreamFactory
implements FilterStreamFactory,
Initializable {
    @Inject
    protected BeanManager beanManager;
    private String name;
    private String description;
    private Class<P> propertiesBeanClass;

    public AbstractBeanFilterStreamFactory(FilterStreamType type) {
        super(type);
    }

    public void initialize() throws InitializationException {
        ParameterizedType genericType = (ParameterizedType)ReflectionUtils.resolveType(AbstractBeanFilterStreamFactory.class, this.getClass());
        this.propertiesBeanClass = ReflectionUtils.getTypeClass((Type)genericType.getActualTypeArguments()[0]);
        DefaultFilterStreamBeanDescriptor descriptor = new DefaultFilterStreamBeanDescriptor(this.getName(), this.getDescription(), this.beanManager.getBeanDescriptor(this.propertiesBeanClass));
        this.setDescriptor(descriptor);
    }

    protected P createPropertiesBean(Map<String, Object> properties) throws FilterException {
        P parametersBean;
        Class<P> beanClass = this.getPropertiesBeanClass();
        if (beanClass.isInstance(properties)) {
            return (P)properties;
        }
        try {
            parametersBean = beanClass.newInstance();
            this.beanManager.populate(parametersBean, properties);
        }
        catch (Exception e) {
            throw new FilterException(String.format("Failed to read parameters [%s]", properties), e);
        }
        return parametersBean;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setPropertiesBeanClass(Class<P> propertiesBeanClass) {
        this.propertiesBeanClass = propertiesBeanClass;
    }

    public Class<P> getPropertiesBeanClass() {
        return this.propertiesBeanClass;
    }
}

