/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.aether.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.AbstractForwardingRepositorySystemSession;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.util.artifact.DefaultArtifactTypeRegistry;
import org.eclipse.aether.util.repository.JreProxySelector;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.environment.Environment;
import org.xwiki.extension.repository.maven.internal.handler.MavenArtifactHandler;
import org.xwiki.extension.repository.maven.internal.handler.MavenArtifactHandlerManager;
import org.xwiki.extension.repository.maven.internal.handler.MavenArtifactHandlers;

@Component(roles={XWikiRepositorySystemSession.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class XWikiRepositorySystemSession
extends AbstractForwardingRepositorySystemSession
implements Closeable {
    static final JreProxySelector JREPROXYSELECTOR = new JreProxySelector();
    private static final Set<String> SYSTEM_PROPERTIES = Set.of("java.version", "os.name", "os.arch", "os.version");
    @Inject
    private MavenArtifactHandlerManager standardHandlers;
    private MavenArtifactHandlers sessionHandlers;
    private RepositorySystemSession session;
    private boolean closeable;

    public static MavenArtifactHandlers getArtifactHandlers(RepositorySystemSession session) {
        if (session instanceof XWikiRepositorySystemSession) {
            XWikiRepositorySystemSession xwikiSession = (XWikiRepositorySystemSession)session;
            return xwikiSession.sessionHandlers;
        }
        return null;
    }

    static Path getDownloadDirectory(Environment enviroment) {
        return enviroment.getTemporaryDirectory().toPath().resolve("extension/download");
    }

    static Path createTemporaryDownloadDirectory(Environment enviroment) throws IOException {
        Path downloadDirectory = XWikiRepositorySystemSession.getDownloadDirectory(enviroment);
        Files.createDirectories(downloadDirectory, new FileAttribute[0]);
        return Files.createTempDirectory(downloadDirectory, "repository", new FileAttribute[0]);
    }

    public void initialize(RepositorySystemSession session) {
        this.session = session;
        this.closeable = false;
        this.addTypes(session);
    }

    public void initialize(RepositorySystem repositorySystem, Environment enviroment) throws IOException {
        this.initialize(repositorySystem, XWikiRepositorySystemSession.createTemporaryDownloadDirectory(enviroment), true);
    }

    public void initialize(RepositorySystem repositorySystem, Path path, boolean closeable) throws IOException {
        DefaultRepositorySystemSession wsession = MavenRepositorySystemUtils.newSession();
        this.session = wsession;
        this.closeable = closeable;
        Files.createDirectories(path, new FileAttribute[0]);
        LocalRepository localRepository = new LocalRepository(path.toFile());
        wsession.setLocalRepositoryManager(repositorySystem.newLocalRepositoryManager((RepositorySystemSession)wsession, localRepository));
        wsession.setProxySelector((ProxySelector)JREPROXYSELECTOR);
        SYSTEM_PROPERTIES.forEach(k -> wsession.setSystemProperty(k, System.getProperty(k)));
        wsession.setSystemProperty("version", null);
        wsession.setSystemProperty("groupId", null);
        this.addTypes((RepositorySystemSession)wsession);
        wsession.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(false, false));
        wsession.setChecksumPolicy("warn");
        this.setUserAgent("XWikiExtensionManager");
    }

    private void addTypes(RepositorySystemSession session) {
        ArtifactTypeRegistry artifactTypeRegistry = session.getArtifactTypeRegistry();
        if (artifactTypeRegistry instanceof DefaultArtifactTypeRegistry) {
            DefaultArtifactTypeRegistry defaultArtifactTypeRegistry = (DefaultArtifactTypeRegistry)artifactTypeRegistry;
            for (MavenArtifactHandler handler : this.standardHandlers.getHandlers()) {
                if (defaultArtifactTypeRegistry.get(handler.getType()) != null) continue;
                defaultArtifactTypeRegistry.add(handler.getArtifactType());
            }
        }
        this.sessionHandlers = new MavenArtifactHandlers(this.standardHandlers);
    }

    protected RepositorySystemSession getSession() {
        return this.session;
    }

    @Override
    public void close() {
        LocalRepository repository;
        if (this.closeable && (repository = this.session.getLocalRepository()).getBasedir().exists()) {
            try {
                FileUtils.deleteDirectory((File)repository.getBasedir());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setUserAgent(String userAgent) {
        if (this.session instanceof DefaultRepositorySystemSession) {
            ((DefaultRepositorySystemSession)this.session).setConfigProperty("aether.connector.userAgent", (Object)userAgent);
        }
    }

    public void addConfigurationProperties(Map<String, ?> properties) {
        if (this.session instanceof DefaultRepositorySystemSession) {
            for (Map.Entry<String, ?> entry : properties.entrySet()) {
                ((DefaultRepositorySystemSession)this.session).setConfigProperty(entry.getKey(), entry.getValue());
            }
        }
    }
}

