/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.signer.internal.cms;

import java.security.GeneralSecurityException;
import java.util.Collection;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.xwiki.crypto.DigestFactory;
import org.xwiki.crypto.pkix.CertificateFactory;
import org.xwiki.crypto.pkix.params.CertifiedPublicKey;
import org.xwiki.crypto.signer.internal.BcContentVerifierProviderBuilder;
import org.xwiki.crypto.signer.internal.cms.BcCMSSignedDataVerified;
import org.xwiki.crypto.signer.internal.cms.BcStoreUtils;

public final class BcCMSUtils {
    private BcCMSUtils() {
    }

    public static boolean verify(SignerInformation signer, CertifiedPublicKey certKey, BcContentVerifierProviderBuilder contentVerifierProviderBuilder, DigestFactory digestProvider) throws CMSException {
        if (certKey == null) {
            throw new CMSException("No certified key for proceeding to signature validation.");
        }
        return signer.verify(new SignerInformationVerifier((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), contentVerifierProviderBuilder.build(certKey), (DigestCalculatorProvider)digestProvider));
    }

    public static CMSSignedData getSignedData(byte[] signature, byte[] data) throws GeneralSecurityException {
        CMSSignedData signedData;
        try {
            signedData = data != null ? new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(data), signature) : new CMSSignedData(signature);
        }
        catch (CMSException e) {
            throw new GeneralSecurityException("Unable to decode signature", e);
        }
        return signedData;
    }

    public static BcCMSSignedDataVerified getCMSSignedDataVerified(CMSSignedData signedData, CertificateFactory factory) {
        BcCMSSignedDataVerified verifiedData = new BcCMSSignedDataVerified(signedData.getSignedContentTypeOID(), signedData.getSignedContent() != null ? (byte[])signedData.getSignedContent().getContent() : null);
        BcStoreUtils.addCertificatesToVerifiedData(signedData.getCertificates(), verifiedData, factory);
        return verifiedData;
    }

    static Collection<SignerInformation> getSigners(CMSSignedData signedData) {
        return signedData.getSignerInfos().getSigners();
    }
}

