/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.pbe.factory;

import java.math.BigInteger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RC2CBCParameter;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.cipher.CipherFactory;
import org.xwiki.crypto.params.cipher.CipherParameters;
import org.xwiki.crypto.params.cipher.symmetric.KeyParameter;
import org.xwiki.crypto.params.cipher.symmetric.KeyWithIVParameters;
import org.xwiki.crypto.params.cipher.symmetric.RC2KeyParameters;
import org.xwiki.crypto.params.cipher.symmetric.SymmetricCipherParameters;
import org.xwiki.crypto.password.KeyDerivationFunction;
import org.xwiki.crypto.password.PasswordBasedCipher;
import org.xwiki.crypto.password.internal.pbe.AbstractBcPBES2Cipher;
import org.xwiki.crypto.password.internal.pbe.factory.AbstractBcPBES2CipherFactory;
import org.xwiki.crypto.password.params.KeyDerivationFunctionParameters;

@Component(hints={"PBES2-RC2-CBC-Pad", "1.2.840.113549.3.2"})
@Singleton
public class BcPBES2Rc2CipherFactory
extends AbstractBcPBES2CipherFactory {
    @Inject
    @Named(value="RC2/CBC/PKCS5Padding")
    private CipherFactory cipherFactory;

    @Override
    protected CipherFactory getCipherFactory() {
        return this.cipherFactory;
    }

    @Override
    public PasswordBasedCipher getInstance(boolean forEncryption, SymmetricCipherParameters password, KeyDerivationFunctionParameters parameters) {
        KeyDerivationFunction kdf = this.getKDFFactory().getInstance(parameters);
        if (kdf.getKeySize() < 0 || !this.isSupportedKeySize(kdf.getKeySize())) {
            KeyParameter keyPass = password instanceof KeyWithIVParameters ? ((KeyWithIVParameters)password).getKeyParameter() : (KeyParameter)password;
            if (keyPass instanceof RC2KeyParameters) {
                kdf.overrideKeySize((((RC2KeyParameters)keyPass).getEffectiveBits() + 7) / 8);
            } else {
                kdf.overrideKeySize(this.getKeySize());
            }
        }
        return this.getInstance(forEncryption, password, kdf);
    }

    @Override
    public PasswordBasedCipher getInstance(boolean forEncryption, SymmetricCipherParameters password, KeyDerivationFunction kdf) {
        KeyWithIVParameters params;
        if (password instanceof KeyWithIVParameters) {
            KeyParameter passkey = ((KeyWithIVParameters)password).getKeyParameter();
            params = passkey instanceof RC2KeyParameters ? new KeyWithIVParameters((KeyParameter)new RC2KeyParameters(kdf.derive(passkey.getKey()).getKey(), ((RC2KeyParameters)passkey).getEffectiveBits()), ((KeyWithIVParameters)password).getIV()) : new KeyWithIVParameters(kdf.derive(((KeyWithIVParameters)password).getKey()), ((KeyWithIVParameters)password).getIV());
        } else if (password instanceof RC2KeyParameters) {
            params = kdf.derive(((KeyParameter)password).getKey(), this.getIVSize());
            params = new KeyWithIVParameters((KeyParameter)new RC2KeyParameters(params.getKey(), ((RC2KeyParameters)password).getEffectiveBits()), params.getIV());
        } else if (password instanceof KeyParameter) {
            params = kdf.derive(((KeyParameter)password).getKey(), this.getIVSize());
        } else {
            throw new IllegalArgumentException("Invalid cipher parameters for RC2 password based cipher: " + password.getClass().getName());
        }
        this.getRC2Version(params);
        return this.getPasswordBasedCipher(forEncryption, kdf, (SymmetricCipherParameters)params);
    }

    @Override
    protected PasswordBasedCipher getPasswordBasedCipher(boolean forEncryption, KeyDerivationFunction kdf, SymmetricCipherParameters params) {
        return new AbstractBcPBES2Cipher(this.getCipherFactory().getInstance(forEncryption, (CipherParameters)params), kdf, params){

            @Override
            protected EncryptionScheme getScheme(SymmetricCipherParameters parameters) {
                return new EncryptionScheme(PKCSObjectIdentifiers.RC2_CBC, (ASN1Encodable)new RC2CBCParameter(BcPBES2Rc2CipherFactory.this.getRC2Version((KeyWithIVParameters)parameters), ((KeyWithIVParameters)parameters).getIV()));
            }
        };
    }

    @Override
    protected PasswordBasedCipher getInstance(boolean forEncryption, byte[] password, KeyDerivationFunc kdfParams, EncryptionScheme scheme) {
        KeyDerivationFunction kdf = this.getKeyDerivationFunction(kdfParams);
        RC2CBCParameter rc2Params = RC2CBCParameter.getInstance((Object)scheme.getParameters());
        return this.getPasswordBasedCipher(forEncryption, kdf, this.getRC2CipherParameters(password, rc2Params, kdf));
    }

    private int getRC2Version(KeyWithIVParameters parameters) {
        KeyParameter keyParams = parameters.getKeyParameter();
        int keySize = keyParams instanceof RC2KeyParameters ? ((RC2KeyParameters)keyParams).getEffectiveBits() : keyParams.getKey().length * 8;
        switch (keySize) {
            case 40: {
                return 160;
            }
            case 64: {
                return 120;
            }
            case 128: {
                return 58;
            }
        }
        if (keySize < 256) {
            throw new IllegalArgumentException("Invalid cipher key size for PBES2 RC2 password based cipher: " + keySize + " bits. Valid key size are 40, 64, 128 and 256 and more.");
        }
        return keySize;
    }

    private SymmetricCipherParameters getRC2CipherParameters(byte[] password, RC2CBCParameter rc2Params, KeyDerivationFunction df) {
        KeyParameter keyParam;
        BigInteger version = rc2Params.getRC2ParameterVersion();
        if (version != null) {
            int bits = this.getRC2EffectiveBits(version.intValue());
            df.overrideKeySize((bits + 7) / 8);
            keyParam = new RC2KeyParameters(df.derive(password).getKey(), bits);
        } else {
            df.overrideKeySize(4);
            keyParam = new KeyParameter(df.derive(password).getKey());
        }
        return new KeyWithIVParameters(keyParam, rc2Params.getIV());
    }

    private int getRC2EffectiveBits(int version) {
        switch (version) {
            case 160: {
                return 40;
            }
            case 120: {
                return 64;
            }
            case 58: {
                return 128;
            }
        }
        return version;
    }
}

