/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.password.internal.pbe.factory;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.crypto.cipher.CipherFactory;
import org.xwiki.crypto.password.PasswordBasedCipher;
import org.xwiki.crypto.password.PasswordBasedCipherFactory;
import org.xwiki.crypto.password.internal.kdf.PBES2Parameters;
import org.xwiki.crypto.password.internal.pbe.RC5CBCParameter;
import org.xwiki.crypto.password.internal.pbe.factory.AbstractBcPBES2CipherFactory;

@Component(hints={"PBES2", "1.2.840.113549.1.5.13"})
@Singleton
public class BcPBES2CipherFactory
extends AbstractBcPBES2CipherFactory {
    private static final RuntimeException UNSUPPORTED = new UnsupportedOperationException("Unexpected internal function call.");
    @Inject
    private ComponentManager manager;

    @Override
    protected CipherFactory getCipherFactory() {
        throw UNSUPPORTED;
    }

    @Override
    public PasswordBasedCipher getInstance(boolean forEncryption, byte[] password, byte[] encoded) {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)encoded);
        AlgorithmIdentifier alg = this.getPBES2AlgorithmIdentifier((ASN1Encodable)seq);
        PBES2Parameters params = PBES2Parameters.getInstance(alg.getParameters());
        PasswordBasedCipherFactory pbecf = this.getPBES2CipherFactory(params.getEncryptionScheme());
        PasswordBasedCipher cipher = this.getBcPBES2PasswordBasedCipher(pbecf, forEncryption, password, (ASN1Encodable)seq);
        if (cipher != null) {
            return cipher;
        }
        return pbecf.getInstance(forEncryption, password, encoded);
    }

    @Override
    public PasswordBasedCipher getInstance(boolean forEncryption, byte[] password, ASN1Encodable parameters) {
        return this.getBcPBES2PasswordBasedCipher(this.getPBES2CipherFactory(PBES2Parameters.getInstance(this.getPBES2AlgorithmIdentifier(parameters).getParameters()).getEncryptionScheme()), forEncryption, password, parameters);
    }

    private AlgorithmIdentifier getPBES2AlgorithmIdentifier(ASN1Encodable parameters) {
        AlgorithmIdentifier alg = AlgorithmIdentifier.getInstance((Object)parameters);
        if (!alg.getAlgorithm().equals((ASN1Primitive)PKCSObjectIdentifiers.id_PBES2)) {
            throw new IllegalArgumentException("Illegal algorithm identifier for PBES2: " + alg.getAlgorithm().getId());
        }
        return alg;
    }

    private PasswordBasedCipher getBcPBES2PasswordBasedCipher(PasswordBasedCipherFactory pbecf, boolean forEncryption, byte[] password, ASN1Encodable parameters) {
        if (pbecf instanceof AbstractBcPBES2CipherFactory) {
            return ((AbstractBcPBES2CipherFactory)pbecf).getInstance(forEncryption, password, parameters);
        }
        return null;
    }

    @Override
    protected PasswordBasedCipher getInstance(boolean forEncryption, byte[] password, KeyDerivationFunc kdfParams, EncryptionScheme scheme) {
        throw UNSUPPORTED;
    }

    private PasswordBasedCipherFactory getPBES2CipherFactory(EncryptionScheme scheme) {
        try {
            RC5CBCParameter rc5Param;
            if (scheme.getAlgorithm().equals((ASN1Primitive)PKCSObjectIdentifiers.encryptionAlgorithm.branch("9")) && (rc5Param = RC5CBCParameter.getInstance(scheme.getParameters())).getBlockSizeInBits().intValue() > 64) {
                return (PasswordBasedCipherFactory)this.manager.getInstance(PasswordBasedCipherFactory.class, "PBES2-RC5-64-CBC-Pad");
            }
            return (PasswordBasedCipherFactory)this.manager.getInstance(PasswordBasedCipherFactory.class, scheme.getAlgorithm().getId());
        }
        catch (ComponentLookupException e) {
            throw new UnsupportedOperationException("Password based cipher factory not found.", e);
        }
    }
}

