/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.collection.internal;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class PriorityEntries<E extends Comparable<E>> {
    protected final Map<String, E> map;
    protected AtomicReference<List<E>> sorted = new AtomicReference();
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public PriorityEntries() {
        this.map = new LinkedHashMap<String, E>();
    }

    public PriorityEntries(int initialCapacity) {
        this.map = new LinkedHashMap<String, E>(initialCapacity);
    }

    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    public E get(String key) {
        this.lock.readLock().lock();
        try {
            Comparable comparable = (Comparable)this.map.get(key);
            return (E)comparable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.map.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.map.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<E> getSorted() {
        List<Object> result = this.sorted.get();
        if (result == null) {
            this.lock.readLock().lock();
            try {
                result = this.map.values().stream().sorted().collect(Collectors.toList());
                this.sorted.compareAndSet(null, result);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return result;
    }

    public void forEachEntry(Consumer<E> action) {
        this.lock.readLock().lock();
        try {
            this.map.values().forEach(action);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void put(String key, E value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.lock.writeLock().lock();
        try {
            this.map.put(key, value);
            this.sorted.set(null);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E remove(String key) {
        this.lock.writeLock().lock();
        try {
            Comparable value = (Comparable)this.map.remove(key);
            if (value != null) {
                this.sorted.set(null);
            }
            Comparable comparable = value;
            return (E)comparable;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

