/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.uparser;

import io.sf.carte.uparser.ContentHandler;
import io.sf.carte.uparser.ControlHandler;
import io.sf.carte.uparser.LocatorAccess;
import io.sf.carte.uparser.SmallWhitelistCharacterCheck;
import io.sf.carte.uparser.TokenControl;
import io.sf.carte.uparser.TokenErrorHandler;
import io.sf.carte.uparser.TokenHandler3;
import io.sf.carte.uparser.TokenProducer3;
import io.sf.carte.uparser.WhitelistCharacterCheck;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public class TokenProducer3<E extends Exception> {
    public static final byte ERR_UNEXPECTED_END_QUOTED = 1;
    public static final byte ERR_LASTCHAR_BACKSLASH = 2;
    public static final byte ERR_UNEXPECTED_END_COMMENTED = 3;
    public static final byte ERR_UNEXPECTED_CONTROL = 4;
    public static final int CHAR_EXCLAMATION = 33;
    public static final int CHAR_NUMBER_SIGN = 35;
    public static final int CHAR_DOLLAR = 36;
    public static final int CHAR_PERCENT_SIGN = 37;
    public static final int CHAR_AMPERSAND = 38;
    public static final int CHAR_LEFT_PAREN = 40;
    public static final int CHAR_RIGHT_PAREN = 41;
    public static final int CHAR_ASTERISK = 42;
    public static final int CHAR_PLUS = 43;
    public static final int CHAR_COMMA = 44;
    public static final int CHAR_HYPHEN_MINUS = 45;
    public static final int CHAR_FULL_STOP = 46;
    public static final int CHAR_SLASH = 47;
    public static final int CHAR_COLON = 58;
    public static final int CHAR_SEMICOLON = 59;
    public static final int CHAR_LESS_THAN = 60;
    public static final int CHAR_EQUALS = 61;
    public static final int CHAR_GREATER_THAN = 62;
    public static final int CHAR_QUESTION_MARK = 63;
    public static final int CHAR_COMMERCIAL_AT = 64;
    public static final int CHAR_LEFT_SQ_BRACKET = 91;
    public static final int CHAR_RIGHT_SQ_BRACKET = 93;
    public static final int CHAR_CIRCUMFLEX_ACCENT = 94;
    public static final int CHAR_LOW_LINE = 95;
    public static final int CHAR_LEFT_CURLY_BRACKET = 123;
    public static final int CHAR_VERTICAL_LINE = 124;
    public static final int CHAR_RIGHT_CURLY_BRACKET = 125;
    public static final int CHAR_TILDE = 126;
    private static final int CHARACTER_PROCESSING_LIMIT_DEFAULT = 0x40000000;
    private ContentHandler<E> handler;
    private ControlHandler<E> controlHandler;
    private TokenErrorHandler<E> errorHandler;
    private final CharacterCheck charCheck;
    private boolean handleAllSeparators = true;
    private boolean acceptNewlineEndingQuote = false;
    private boolean acceptEofEndingQuoted = false;
    private final int characterIndexLimit;

    public TokenProducer3(TokenHandler3<E> handler) {
        this(handler, 0x40000000);
    }

    public TokenProducer3(TokenHandler3<E> handler, int characterCountLimit) {
        this.characterIndexLimit = characterCountLimit;
        this.handler = handler;
        this.controlHandler = handler;
        this.errorHandler = handler;
        this.charCheck = new DisallowCharacterCheck();
    }

    public TokenProducer3(TokenHandler3<E> handler, CharacterCheck charCheck) {
        this(handler, charCheck, 0x40000000);
    }

    public TokenProducer3(TokenHandler3<E> handler, CharacterCheck charCheck, int characterCountLimit) {
        this.handler = handler;
        this.controlHandler = handler;
        this.errorHandler = handler;
        this.charCheck = charCheck;
        this.characterIndexLimit = characterCountLimit;
    }

    public TokenProducer3(TokenHandler3<E> handler, int[] allowInWords) {
        this(handler, allowInWords, 0x40000000);
    }

    public TokenProducer3(TokenHandler3<E> handler, int[] allowInWords, int characterCountLimit) {
        this.handler = handler;
        this.controlHandler = handler;
        this.errorHandler = handler;
        this.charCheck = allowInWords.length < 4 ? new SmallWhitelistCharacterCheck(allowInWords) : new WhitelistCharacterCheck(allowInWords);
        this.characterIndexLimit = characterCountLimit;
    }

    public TokenProducer3(CharacterCheck charCheck, int characterCountLimit) {
        this.charCheck = charCheck;
        this.characterIndexLimit = characterCountLimit;
    }

    public void setContentHandler(ContentHandler<E> handler) {
        this.handler = handler;
    }

    public void setControlHandler(ControlHandler<E> controlHandler) {
        this.controlHandler = controlHandler;
    }

    public void setErrorHandler(TokenErrorHandler<E> errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setHandleAllSeparators(boolean handleAllSeparators) {
        this.handleAllSeparators = handleAllSeparators;
    }

    public void setAcceptNewlineEndingQuote(boolean accept) {
        this.acceptNewlineEndingQuote = accept;
    }

    public void setAcceptEofEndingQuoted(boolean accept) {
        this.acceptEofEndingQuoted = accept;
    }

    public void parse(String string) throws E {
        if (string == null) {
            throw new NullPointerException("Null argument");
        }
        StringParser sp = new StringParser(string);
        try {
            sp.parse();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void parse(String string, String commentOpen, String commentClose) throws E {
        if (string == null) {
            throw new NullPointerException("Null argument");
        }
        StringParser sp = new StringParser(string, commentOpen, commentClose);
        try {
            sp.parse();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void parse(Reader reader) throws E, IOException {
        if (reader == null) {
            throw new NullPointerException("Null character stream");
        }
        ReaderParser sp = new ReaderParser(reader);
        sp.parse();
    }

    public void parse(Reader reader, int bufferCapacity) throws E, IOException {
        if (reader == null) {
            throw new NullPointerException("Null character stream");
        }
        ReaderParser sp = new ReaderParser(reader, bufferCapacity);
        sp.parse();
    }

    public void parse(Reader reader, String commentOpen, String commentClose) throws E, IOException {
        if (reader == null) {
            throw new NullPointerException("Null character stream");
        }
        ReaderParser sp = new ReaderParser(reader, commentOpen, commentClose);
        sp.parse();
    }

    public void parseMultiComment(Reader reader, String[] opening, String[] closing) throws E, IOException {
        if (reader == null) {
            throw new NullPointerException("Null character stream");
        }
        ReaderMultiCommentParser sp = new ReaderMultiCommentParser(reader, opening, closing);
        sp.parse();
    }

    public static interface CharacterCheck {
        public boolean isAllowedCharacter(int var1, SequenceParser<? extends Exception> var2);
    }

    static class DisallowCharacterCheck
    implements CharacterCheck {
        DisallowCharacterCheck() {
        }

        @Override
        public boolean isAllowedCharacter(int codePoint, SequenceParser<? extends Exception> parser) {
            return false;
        }
    }

    private class StringParser
    extends AbstractSequenceParser {
        private final String string;
        private final int len;

        StringParser(String string) {
            this.commentManager = new StringNoCommentManager();
            this.string = string;
            this.len = string.length();
        }

        StringParser(String string, String start, String end) {
            this.commentManager = new StringSingleCommentManager(start, end);
            this.string = string;
            this.len = string.length();
        }

        @Override
        public CharSequence currentSequence() {
            return this.string.subSequence(this.previdx, this.rootIndex);
        }

        @Override
        public void resetCurrentSequence() {
            this.previdx = this.rootIndex;
        }

        @Override
        protected int nextCodepoint() throws IOException {
            if (this.rootIndex < this.len - 1) {
                this.rootIndex = this.string.offsetByCodePoints(this.rootIndex, 1);
                return this.string.codePointAt(this.rootIndex);
            }
            return -1;
        }

        @Override
        protected CharSequence quotedSequence(int qcp) throws Exception {
            boolean containsControls = false;
            boolean lastCpEscaped13 = false;
            int initial = this.rootIndex + 1;
            int prevcp = -1;
            StringBuilder buffer = new StringBuilder(this.len - initial);
            for (int idx = initial; idx < this.len; ++idx) {
                int cp = this.string.codePointAt(idx);
                if (cp == qcp) {
                    if (prevcp != 92) {
                        if (containsControls) {
                            TokenProducer3.this.handler.quotedWithControl(this.rootIndex, buffer, qcp);
                            buffer = null;
                        }
                        this.rootIndex = idx;
                        return buffer;
                    }
                    buffer.appendCodePoint(qcp);
                } else if (Character.isISOControl(cp)) {
                    if (cp == 10 || cp == 12 || cp == 13) {
                        if (prevcp != 92) {
                            if (cp != 10 || !lastCpEscaped13) {
                                TokenProducer3.this.errorHandler.error(idx, (byte)1, buffer);
                                this.rootIndex = idx;
                                this.handleControl(cp);
                                if (!TokenProducer3.this.acceptNewlineEndingQuote) {
                                    return null;
                                }
                                return buffer;
                            }
                        } else {
                            buffer.setLength(buffer.length() - 1);
                            TokenProducer3.this.controlHandler.quotedNewlineChar(idx, cp);
                        }
                        if (!lastCpEscaped13) {
                            buffer.append('\n');
                        }
                        lastCpEscaped13 = cp == 13;
                        prevcp = cp;
                        continue;
                    }
                    buffer.appendCodePoint(cp);
                    containsControls = true;
                } else {
                    buffer.appendCodePoint(cp);
                    if (cp == 92 && prevcp == 92) {
                        cp = 65;
                    }
                }
                prevcp = cp;
                lastCpEscaped13 = false;
            }
            this.rootIndex = this.len;
            if (TokenProducer3.this.acceptEofEndingQuoted) {
                if (!containsControls) {
                    return buffer;
                }
                TokenProducer3.this.handler.quotedWithControl(this.rootIndex, buffer, qcp);
            } else {
                this.error(initial, (byte)1);
            }
            return null;
        }

        @Override
        protected void error(int index, byte errCode) throws Exception {
            int endIndex;
            int beginIndex = index - 16;
            if (beginIndex < 0) {
                beginIndex = 0;
            }
            if ((endIndex = index + 16) > this.string.length()) {
                endIndex = this.string.length();
            }
            TokenProducer3.this.errorHandler.error(index, errCode, this.string.substring(beginIndex, endIndex));
        }

        /*
         * Signature claims super is io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.NoCommentManager, not io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser$NoCommentManager - discarding signature.
         */
        class StringNoCommentManager
        extends AbstractSequenceParser.NoCommentManager {
            StringNoCommentManager() {
            }

            @Override
            void parse() throws IOException, Exception {
                super.parse();
                StringParser.this.rootIndex = 0;
                while (StringParser.this.rootIndex < StringParser.this.len) {
                    int cp = StringParser.this.string.codePointAt(StringParser.this.rootIndex);
                    StringParser.this.processCodePoint(cp, true);
                    StringParser.this.rootIndex += Character.charCount(cp);
                }
                int remlen = StringParser.this.len - StringParser.this.previdx;
                if (remlen > 0) {
                    if (remlen != 1 || !StringParser.this.isPreviousCpWCharacter()) {
                        TokenProducer3.this.handler.word(StringParser.this.previdx, StringParser.this.currentSequence());
                    } else {
                        TokenProducer3.this.handler.character(StringParser.this.previdx, StringParser.this.string.charAt(StringParser.this.previdx));
                    }
                }
                TokenProducer3.this.handler.endOfStream(StringParser.this.len);
            }
        }

        /*
         * Signature claims super is io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.SingleCommentManager, not io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser$SingleCommentManager - discarding signature.
         */
        class StringSingleCommentManager
        extends AbstractSequenceParser.SingleCommentManager {
            StringSingleCommentManager(String start, String end) {
                super(start, end);
            }

            @Override
            void parse() throws Exception, IOException {
                super.parse();
                int unprocessedIdx = -1;
                int[] unprocessed = new int[this.commentStart.length];
                StringParser.this.rootIndex = 0;
                while (StringParser.this.rootIndex < StringParser.this.len) {
                    int cp;
                    block21: {
                        int j;
                        int ret;
                        block20: {
                            cp = StringParser.this.string.codePointAt(StringParser.this.rootIndex);
                            if (unprocessedIdx != -2) break block20;
                            unprocessedIdx = -1;
                            if (cp == 10) break block21;
                        }
                        if ((ret = StringParser.this.processCodePoint(cp, false)) == 0) {
                            unprocessed[++unprocessedIdx] = cp;
                        } else if (ret == 2) {
                            unprocessedIdx = this.commentEnd[this.commentEnd.length - 1] == 13 ? -2 : -1;
                        } else if (ret == -1) {
                            StringParser.this.rootIndex = StringParser.this.rootIndex - unprocessedIdx - 1;
                            for (j = 0; j <= unprocessedIdx; ++j) {
                                StringParser.this.processCodePoint(unprocessed[j], true);
                                ++StringParser.this.rootIndex;
                            }
                            StringParser.this.processCodePoint(cp, true);
                            unprocessedIdx = -1;
                        } else if (ret == -2) {
                            StringParser.this.rootIndex = StringParser.this.rootIndex - unprocessedIdx - 1;
                            for (j = 0; j <= unprocessedIdx; ++j) {
                                StringParser.this.processCodePoint(unprocessed[j], true);
                                ++StringParser.this.rootIndex;
                            }
                            unprocessedIdx = -1;
                            if (StringParser.this.processCodePoint(cp, false) != -2) {
                                unprocessedIdx = 0;
                                unprocessed[0] = cp;
                            }
                        }
                    }
                    StringParser.this.rootIndex += Character.charCount(cp);
                }
                int remlen = StringParser.this.len - StringParser.this.previdx;
                if (unprocessedIdx != -1) {
                    StringParser.this.rootIndex -= unprocessedIdx + 1;
                    remlen -= unprocessedIdx + 1;
                }
                if (remlen > 0) {
                    if (remlen != 1 || !StringParser.this.isPreviousCpWCharacter()) {
                        TokenProducer3.this.handler.word(StringParser.this.previdx, StringParser.this.currentSequence());
                        StringParser.this.previdx = StringParser.this.rootIndex;
                    } else {
                        TokenProducer3.this.handler.character(StringParser.this.previdx, StringParser.this.string.charAt(StringParser.this.previdx));
                        ++StringParser.this.previdx;
                    }
                }
                if (unprocessedIdx != -1) {
                    for (int i = 0; i <= unprocessedIdx; ++i) {
                        TokenProducer3.this.handler.character(StringParser.this.previdx + i, unprocessed[i]);
                    }
                }
                TokenProducer3.this.handler.endOfStream(StringParser.this.len);
            }

            @Override
            protected String commentedSequence() throws Exception, IOException {
                boolean lastCp13 = false;
                int endIndex = 0;
                StringBuilder buffer = new StringBuilder(StringParser.this.len - StringParser.this.rootIndex);
                for (int idx = StringParser.this.rootIndex; idx < StringParser.this.len; ++idx) {
                    int cp = StringParser.this.string.codePointAt(idx);
                    if (cp == 10 || cp == 12 || cp == 13) {
                        if (StringParser.this.externalControlHandling && (cp != 10 || !lastCp13)) {
                            TokenProducer3.this.controlHandler.control(idx, cp);
                        }
                        lastCp13 = cp == 13;
                    } else {
                        lastCp13 = false;
                    }
                    if (this.commentEnd[endIndex] == cp) {
                        if (++endIndex != this.commentEnd.length) continue;
                        StringParser.this.rootIndex = idx + 1;
                        return buffer.toString();
                    }
                    if (endIndex != 0) {
                        for (int j = 0; j <= endIndex; ++j) {
                            buffer.append(this.commentEnd[j]);
                        }
                        endIndex = 0;
                    }
                    buffer.appendCodePoint(cp);
                }
                StringParser.this.rootIndex = StringParser.this.len;
                if (!this.closingEndsWith(10)) {
                    StringParser.this.error(StringParser.this.rootIndex, (byte)3);
                }
                return buffer.toString();
            }

            @Override
            void wordPrecedingComment() throws Exception {
                int endIndex = StringParser.this.rootIndex - this.commentIndex + 1;
                if (endIndex - StringParser.this.previdx != 1 || !StringParser.this.isPreviousCpWCharacter()) {
                    TokenProducer3.this.handler.word(StringParser.this.previdx, StringParser.this.string.subSequence(StringParser.this.previdx, endIndex));
                } else {
                    TokenProducer3.this.handler.character(StringParser.this.previdx, StringParser.this.string.charAt(StringParser.this.previdx));
                }
            }
        }
    }

    private class ReaderParser
    extends AbstractReaderParser {
        ReaderParser(Reader reader) {
            this(reader, 256);
        }

        ReaderParser(Reader reader, int bufferCapacity) {
            super(reader, bufferCapacity);
            this.commentManager = new ReaderNoCommentManager();
        }

        ReaderParser(Reader reader, String start, String end) {
            this(reader, 256, start, end);
        }

        ReaderParser(Reader reader, int bufferCapacity, String start, String end) {
            super(reader, bufferCapacity);
            this.commentManager = new ReaderSingleCommentManager(start, end);
        }

        /*
         * Signature claims super is io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.NoCommentManager, not io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser$NoCommentManager - discarding signature.
         */
        private class ReaderNoCommentManager
        extends AbstractSequenceParser.NoCommentManager {
            private ReaderNoCommentManager() {
            }

            @Override
            void parse() throws Exception, IOException {
                super.parse();
                ReaderParser.this.rootIndex = 0;
                int cp = 0;
                while ((cp = ReaderParser.this.reader.read()) != -1) {
                    ReaderParser.this.processCodePoint(cp, true);
                    if (ReaderParser.this.prevtype == 2 || ReaderParser.this.prevtype == 1) {
                        ReaderParser.this.buffer.appendCodePoint(cp);
                    }
                    ReaderParser.this.rootIndex += Character.charCount(cp);
                }
                int buflen = ReaderParser.this.currentSequence().length();
                if (buflen != 0) {
                    if (buflen != 1 || !ReaderParser.this.isPreviousCpWCharacter()) {
                        TokenProducer3.this.handler.word(ReaderParser.this.previdx, ReaderParser.this.currentSequence());
                    } else {
                        TokenProducer3.this.handler.character(ReaderParser.this.previdx, ReaderParser.this.currentSequence().charAt(0));
                    }
                }
                TokenProducer3.this.handler.endOfStream(ReaderParser.this.rootIndex);
            }
        }

        /*
         * Signature claims super is io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.SingleCommentManager, not io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser$SingleCommentManager - discarding signature.
         */
        private class ReaderSingleCommentManager
        extends AbstractSequenceParser.SingleCommentManager {
            ReaderSingleCommentManager(String start, String end) {
                super(start, end);
            }

            @Override
            void parse() throws Exception, IOException {
                super.parse();
                int unprocessedIdx = -1;
                int[] unprocessed = new int[this.commentStart.length];
                ReaderParser.this.rootIndex = 0;
                int cp = 0;
                while ((cp = ReaderParser.this.reader.read()) != -1) {
                    int oldcp;
                    int j;
                    int ret;
                    if (unprocessedIdx == -2) {
                        unprocessedIdx = -1;
                        if (cp == 10) continue;
                    }
                    if ((ret = ReaderParser.this.processCodePoint(cp, false)) == 0) {
                        unprocessed[++unprocessedIdx] = cp;
                    } else if (ret == 2) {
                        unprocessedIdx = this.commentEnd[this.commentEnd.length - 1] == 13 ? -2 : -1;
                    } else if (ret == -1) {
                        for (j = 0; j <= unprocessedIdx; ++j) {
                            oldcp = unprocessed[j];
                            ReaderParser.this.processCodePoint(oldcp, true);
                            if (ReaderParser.this.prevtype != 2 && ReaderParser.this.prevtype != 1) continue;
                            ReaderParser.this.buffer.appendCodePoint(oldcp);
                        }
                        ReaderParser.this.processCodePoint(cp, true);
                        unprocessedIdx = -1;
                        if (ReaderParser.this.prevtype == 2 || ReaderParser.this.prevtype == 1) {
                            ReaderParser.this.buffer.appendCodePoint(cp);
                        }
                    } else if (ret == -2) {
                        for (j = 0; j <= unprocessedIdx; ++j) {
                            oldcp = unprocessed[j];
                            ReaderParser.this.processCodePoint(oldcp, true);
                            if (ReaderParser.this.prevtype != 2 && ReaderParser.this.prevtype != 1) continue;
                            ReaderParser.this.buffer.appendCodePoint(oldcp);
                        }
                        unprocessedIdx = -1;
                        if (ReaderParser.this.processCodePoint(cp, false) != -2) {
                            unprocessedIdx = 0;
                            unprocessed[0] = cp;
                        }
                    } else if (ReaderParser.this.prevtype == 2 || ReaderParser.this.prevtype == 1) {
                        ReaderParser.this.buffer.appendCodePoint(cp);
                    }
                    ReaderParser.this.rootIndex += Character.charCount(cp);
                }
                int buflen = ReaderParser.this.currentSequence().length();
                if (buflen != 0) {
                    if (buflen != 1 || !ReaderParser.this.isPreviousCpWCharacter()) {
                        TokenProducer3.this.handler.word(ReaderParser.this.previdx, ReaderParser.this.currentSequence());
                    } else {
                        TokenProducer3.this.handler.character(ReaderParser.this.previdx, ReaderParser.this.currentSequence().charAt(0));
                    }
                }
                if (unprocessedIdx != -1) {
                    ReaderParser.this.previdx = ReaderParser.this.rootIndex - unprocessedIdx - 1;
                    for (int i = 0; i <= unprocessedIdx; ++i) {
                        TokenProducer3.this.handler.character(ReaderParser.this.previdx + i, unprocessed[i]);
                    }
                }
                TokenProducer3.this.handler.endOfStream(ReaderParser.this.rootIndex);
            }

            @Override
            protected String commentedSequence() throws Exception, IOException {
                int ncp;
                boolean lastCp13 = false;
                int endIndex = 0;
                while ((ncp = ReaderParser.this.nextCodepoint()) != -1) {
                    ReaderParser.this.checkResourceUsage();
                    boolean isCp10 = ncp == 10 || ncp == 12 || ncp == 13;
                    if (isCp10) {
                        if (ReaderParser.this.externalControlHandling && (ncp != 10 || !lastCp13)) {
                            TokenProducer3.this.controlHandler.control(ReaderParser.this.rootIndex - 1, ncp);
                        }
                        boolean bl = lastCp13 = ncp == 13;
                        if (isCp10) {
                            ++ReaderParser.this.line;
                            ReaderParser.this.prevlinelength = ReaderParser.this.rootIndex - 1;
                        }
                    } else {
                        lastCp13 = false;
                    }
                    if (this.commentEnd[endIndex] == ncp) {
                        if (++endIndex != this.commentEnd.length) continue;
                        return ReaderParser.this.buffer.toString();
                    }
                    if (endIndex != 0) {
                        if ((endIndex = this.commentEndIndex(endIndex, ncp)) != 0) continue;
                        ReaderParser.this.buffer.appendCodePoint(ncp);
                        continue;
                    }
                    ReaderParser.this.buffer.appendCodePoint(ncp);
                }
                if (!this.closingEndsWith(10)) {
                    ReaderParser.this.error(ReaderParser.this.rootIndex, (byte)3);
                }
                return ReaderParser.this.buffer.toString();
            }

            private int commentEndIndex(int endIndex, int ncp) {
                int endIndexm1 = endIndex - 1;
                if (this.commentEnd[endIndexm1] != ncp || !this.repeatedEndCp(endIndexm1)) {
                    for (int j = 0; j < endIndex; ++j) {
                        ReaderParser.this.buffer.appendCodePoint(this.commentEnd[j]);
                    }
                    endIndex = 0;
                } else {
                    ReaderParser.this.buffer.appendCodePoint(this.commentEnd[0]);
                }
                return endIndex;
            }

            private boolean repeatedEndCp(int endIndexm1) {
                for (int i = endIndexm1; i > 0; --i) {
                    if (this.commentEnd[i] == this.commentEnd[i - 1]) continue;
                    return false;
                }
                return true;
            }
        }
    }

    private class ReaderMultiCommentParser
    extends AbstractReaderParser {
        ReaderMultiCommentParser(Reader reader, String[] start, String[] end) {
            this(reader, start, end, 256);
        }

        ReaderMultiCommentParser(Reader reader, String[] start, String[] end, int bufferCapacity) {
            super(reader, bufferCapacity);
            this.commentManager = new ReaderMultiCommentManager(start, end);
        }

        /*
         * Signature claims super is io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.MultiCommentManager, not io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser$MultiCommentManager - discarding signature.
         */
        private class ReaderMultiCommentManager
        extends AbstractSequenceParser.MultiCommentManager {
            ReaderMultiCommentManager(String[] start, String[] end) {
                super(start, end);
            }

            @Override
            void parse() throws Exception, IOException {
                super.parse();
                int unprocessedIdx = -1;
                int[] unprocessed = new int[this.getMaxOpeningLength()];
                ReaderMultiCommentParser.this.rootIndex = 0;
                int cp = 0;
                while ((cp = ReaderMultiCommentParser.this.reader.read()) != -1) {
                    int oldcp;
                    int j;
                    int ret;
                    if (unprocessedIdx == -2) {
                        unprocessedIdx = -1;
                        if (cp == 10) continue;
                    }
                    if ((ret = ReaderMultiCommentParser.this.processCodePoint(cp, false)) == 0) {
                        unprocessed[++unprocessedIdx] = cp;
                    } else if (ret == 2) {
                        unprocessedIdx = this.closingEndsWithLF() ? -2 : -1;
                    } else if (ret == -1) {
                        ReaderMultiCommentParser.this.rootIndex -= unprocessedIdx + 1;
                        for (j = 0; j <= unprocessedIdx; ++j) {
                            oldcp = unprocessed[j];
                            ReaderMultiCommentParser.this.processCodePoint(oldcp, true);
                            ++ReaderMultiCommentParser.this.rootIndex;
                            if (ReaderMultiCommentParser.this.prevtype != 2 && ReaderMultiCommentParser.this.prevtype != 1) continue;
                            ReaderMultiCommentParser.this.buffer.appendCodePoint(oldcp);
                        }
                        ReaderMultiCommentParser.this.processCodePoint(cp, true);
                        unprocessedIdx = -1;
                        if (ReaderMultiCommentParser.this.prevtype == 2 || ReaderMultiCommentParser.this.prevtype == 1) {
                            ReaderMultiCommentParser.this.buffer.appendCodePoint(cp);
                        }
                    } else if (ret == -2) {
                        ReaderMultiCommentParser.this.rootIndex -= unprocessedIdx + 1;
                        for (j = 0; j <= unprocessedIdx; ++j) {
                            oldcp = unprocessed[j];
                            ReaderMultiCommentParser.this.processCodePoint(oldcp, true);
                            ++ReaderMultiCommentParser.this.rootIndex;
                            if (ReaderMultiCommentParser.this.prevtype != 2 && ReaderMultiCommentParser.this.prevtype != 1) continue;
                            ReaderMultiCommentParser.this.buffer.appendCodePoint(oldcp);
                        }
                        unprocessedIdx = -1;
                        if (ReaderMultiCommentParser.this.processCodePoint(cp, false) != -2) {
                            unprocessedIdx = 0;
                            unprocessed[0] = cp;
                        }
                    } else if (ReaderMultiCommentParser.this.prevtype == 2 || ReaderMultiCommentParser.this.prevtype == 1) {
                        ReaderMultiCommentParser.this.buffer.appendCodePoint(cp);
                    }
                    ReaderMultiCommentParser.this.rootIndex += Character.charCount(cp);
                }
                int buflen = ReaderMultiCommentParser.this.currentSequence().length();
                if (buflen != 0) {
                    if (buflen != 1 || !ReaderMultiCommentParser.this.isPreviousCpWCharacter()) {
                        TokenProducer3.this.handler.word(ReaderMultiCommentParser.this.previdx, ReaderMultiCommentParser.this.currentSequence());
                    } else {
                        TokenProducer3.this.handler.character(ReaderMultiCommentParser.this.previdx, ReaderMultiCommentParser.this.currentSequence().charAt(0));
                    }
                }
                if (unprocessedIdx != -1) {
                    ReaderMultiCommentParser.this.previdx = ReaderMultiCommentParser.this.rootIndex - unprocessedIdx - 1;
                    for (int i = 0; i <= unprocessedIdx; ++i) {
                        TokenProducer3.this.handler.character(ReaderMultiCommentParser.this.previdx + i, unprocessed[i]);
                    }
                }
                TokenProducer3.this.handler.endOfStream(ReaderMultiCommentParser.this.rootIndex);
            }

            @Override
            protected String commentedSequence() throws Exception, IOException {
                int ncp;
                boolean lastCp13 = false;
                int endIndex = 0;
                while ((ncp = ReaderMultiCommentParser.this.nextCodepoint()) != -1) {
                    ReaderMultiCommentParser.this.checkResourceUsage();
                    boolean isCp10 = ncp == 10 || ncp == 12 || ncp == 13;
                    if (isCp10) {
                        if (ReaderMultiCommentParser.this.externalControlHandling && (ncp != 10 || !lastCp13)) {
                            TokenProducer3.this.controlHandler.control(ReaderMultiCommentParser.this.rootIndex - 1, ncp);
                        }
                        boolean bl = lastCp13 = ncp == 13;
                        if (isCp10) {
                            ++ReaderMultiCommentParser.this.line;
                            ReaderMultiCommentParser.this.prevlinelength = ReaderMultiCommentParser.this.rootIndex - 1;
                        }
                    } else {
                        lastCp13 = false;
                    }
                    if (this.closingCodepointAt(endIndex) == ncp) {
                        if (++endIndex != this.closingLength()) continue;
                        return ReaderMultiCommentParser.this.buffer.toString();
                    }
                    if (endIndex != 0) {
                        if ((endIndex = this.commentEndIndex(endIndex, ncp)) != 0) continue;
                        ReaderMultiCommentParser.this.buffer.appendCodePoint(ncp);
                        continue;
                    }
                    ReaderMultiCommentParser.this.buffer.appendCodePoint(ncp);
                }
                if (!this.closingEndsWith(10)) {
                    ReaderMultiCommentParser.this.error(ReaderMultiCommentParser.this.rootIndex, (byte)3);
                }
                return ReaderMultiCommentParser.this.buffer.toString();
            }

            private int commentEndIndex(int endIndex, int ncp) {
                int endIndexm1 = endIndex - 1;
                if (this.closingCodepointAt(endIndexm1) != ncp || !this.repeatedEndCp(endIndexm1)) {
                    for (int j = 0; j < endIndex; ++j) {
                        ReaderMultiCommentParser.this.buffer.appendCodePoint(this.closingCodepointAt(j));
                    }
                    endIndex = 0;
                } else {
                    ReaderMultiCommentParser.this.buffer.appendCodePoint(this.closingCodepointAt(0));
                }
                return endIndex;
            }

            private boolean repeatedEndCp(int endIndexm1) {
                for (int i = endIndexm1; i > 0; --i) {
                    if (this.closingCodepointAt(i) == this.closingCodepointAt(i - 1)) continue;
                    return false;
                }
                return true;
            }
        }
    }

    private abstract class AbstractReaderParser
    extends AbstractSequenceParser {
        Reader reader;
        StringBuilder buffer;

        AbstractReaderParser(Reader reader, int bufferCapacity) {
            this.reader = reader;
            this.buffer = new StringBuilder(bufferCapacity);
        }

        @Override
        protected void checkResourceUsage() {
            if (this.rootIndex > TokenProducer3.this.characterIndexLimit) {
                throw new SecurityException("Exceeded maximum allowed stream size: " + TokenProducer3.this.characterIndexLimit);
            }
        }

        @Override
        public CharSequence currentSequence() {
            return this.buffer;
        }

        @Override
        public void resetCurrentSequence() {
            this.buffer.setLength(0);
        }

        @Override
        protected int nextCodepoint() throws IOException {
            int ncp = this.reader.read();
            this.rootIndex += Character.charCount(ncp);
            return ncp;
        }

        @Override
        protected CharSequence quotedSequence(int qcp) throws Exception, IOException {
            int ncp;
            boolean containsControls = false;
            boolean lastCpEscaped13 = false;
            int idx = this.rootIndex;
            int prevcp = -1;
            while ((ncp = this.nextCodepoint()) != -1) {
                this.checkResourceUsage();
                if (ncp == qcp) {
                    if (prevcp != 92) {
                        if (!containsControls) {
                            return this.buffer;
                        }
                        TokenProducer3.this.handler.quotedWithControl(this.rootIndex, this.buffer, qcp);
                        return null;
                    }
                    ++idx;
                    this.buffer.appendCodePoint(qcp);
                } else if (Character.isISOControl(ncp)) {
                    if (ncp == 10 || ncp == 12 || ncp == 13) {
                        if (prevcp != 92) {
                            if (ncp != 10 || !lastCpEscaped13) {
                                TokenProducer3.this.errorHandler.error(this.rootIndex, (byte)1, this.buffer);
                                this.handleControl(ncp);
                                String s = !TokenProducer3.this.acceptNewlineEndingQuote ? null : this.buffer.toString();
                                this.buffer.setLength(0);
                                return s;
                            }
                        } else {
                            this.buffer.setLength(this.buffer.length() - 1);
                            TokenProducer3.this.controlHandler.quotedNewlineChar(idx, ncp);
                        }
                        if (!lastCpEscaped13) {
                            this.buffer.append('\n');
                        }
                        lastCpEscaped13 = ncp == 13;
                        prevcp = ncp;
                        continue;
                    }
                    this.buffer.appendCodePoint(ncp);
                    ++idx;
                    containsControls = true;
                } else {
                    this.buffer.appendCodePoint(ncp);
                    if (ncp == 92 && prevcp == 92) {
                        ncp = 65;
                    }
                    ++idx;
                }
                prevcp = ncp;
                lastCpEscaped13 = false;
            }
            if (TokenProducer3.this.acceptEofEndingQuoted) {
                if (!containsControls) {
                    return this.buffer;
                }
                TokenProducer3.this.handler.quotedWithControl(this.rootIndex, this.buffer, qcp);
            } else {
                this.error(this.rootIndex, (byte)1);
            }
            return null;
        }

        @Override
        protected void word() throws Exception {
            super.word();
            this.buffer.setLength(0);
        }

        @Override
        protected void quoted(int quoteCp) throws Exception, IOException {
            super.quoted(quoteCp);
            this.buffer.setLength(0);
        }

        @Override
        protected void error(int index, byte errCode) throws Exception {
            TokenProducer3.this.errorHandler.error(index, errCode, this.buffer);
        }
    }

    abstract class AbstractSequenceParser
    implements SequenceParser<E> {
        int prevtype = 12;
        int rootIndex = 0;
        int previdx = 0;
        int prevlinelength = -1;
        int line = 1;
        private boolean foundCp13andNotYet10or12 = false;
        boolean externalControlHandling = true;
        io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.CommentManager commentManager;

        AbstractSequenceParser() {
        }

        int processCodePoint(int cp, boolean nocomment) throws Exception, IOException {
            int result;
            this.checkResourceUsage();
            if (!nocomment && (result = this.commentManager.verifyComment(cp)) != 1) {
                return result;
            }
            int type = Character.getType(cp);
            block0 : switch (type) {
                case 12: 
                case 13: 
                case 14: {
                    if (TokenProducer3.this.handleAllSeparators || this.prevtype != 12) {
                        this.checkPreviousWord();
                        TokenProducer3.this.handler.separator(this.rootIndex, cp);
                        this.prevtype = 12;
                    }
                    this.previdx = this.rootIndex + 1;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 16: 
                case 23: {
                    this.prevtype = 2;
                    break;
                }
                case 15: {
                    this.checkPreviousWord();
                    this.prevtype = 15;
                    this.handleControl(cp);
                    this.previdx = this.rootIndex + 1;
                    break;
                }
                case 21: {
                    if (TokenProducer3.this.charCheck.isAllowedCharacter(cp, this)) {
                        this.prevtype = 1;
                        break;
                    }
                    this.checkPreviousWord();
                    switch (cp) {
                        case 40: {
                            TokenProducer3.this.handler.leftParenthesis(this.rootIndex);
                            this.previdx = this.rootIndex + 1;
                            this.prevtype = 24;
                            break block0;
                        }
                        case 91: {
                            TokenProducer3.this.handler.leftSquareBracket(this.rootIndex);
                            this.previdx = this.rootIndex + 1;
                            this.prevtype = 24;
                            break block0;
                        }
                        case 123: {
                            TokenProducer3.this.handler.leftCurlyBracket(this.rootIndex);
                            this.previdx = this.rootIndex + 1;
                            this.prevtype = 24;
                            break block0;
                        }
                    }
                    TokenProducer3.this.handler.startPunctuation(this.rootIndex, cp);
                    this.updatePrev(cp);
                    break;
                }
                case 22: {
                    if (TokenProducer3.this.charCheck.isAllowedCharacter(cp, this)) {
                        this.prevtype = 1;
                        break;
                    }
                    this.checkPreviousWord();
                    switch (cp) {
                        case 41: {
                            TokenProducer3.this.handler.rightParenthesis(this.rootIndex);
                            this.previdx = this.rootIndex + 1;
                            this.prevtype = 24;
                            break block0;
                        }
                        case 93: {
                            TokenProducer3.this.handler.rightSquareBracket(this.rootIndex);
                            this.previdx = this.rootIndex + 1;
                            this.prevtype = 24;
                            break block0;
                        }
                        case 125: {
                            TokenProducer3.this.handler.rightCurlyBracket(this.rootIndex);
                            this.previdx = this.rootIndex + 1;
                            this.prevtype = 24;
                            break block0;
                        }
                    }
                    TokenProducer3.this.handler.endPunctuation(this.rootIndex, cp);
                    this.updatePrev(cp);
                    break;
                }
                case 24: {
                    if (TokenProducer3.this.charCheck.isAllowedCharacter(cp, this)) {
                        this.prevtype = 1;
                        break;
                    }
                    this.checkPreviousWord();
                    if (cp == 34 || cp == 39) {
                        this.quoted(cp);
                    } else if (cp == 92) {
                        int ncp = this.nextCodepoint();
                        if (ncp != -1) {
                            TokenProducer3.this.handler.escaped(this.rootIndex, ncp);
                        } else {
                            this.error(this.rootIndex - 1, (byte)2);
                        }
                    } else {
                        this.handleCharacter(cp);
                    }
                    this.updatePrev(cp);
                    break;
                }
                case 19: 
                case 20: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    if (TokenProducer3.this.charCheck.isAllowedCharacter(cp, this)) {
                        this.prevtype = 1;
                        break;
                    }
                    this.checkPreviousWord();
                    this.handleCharacter(cp);
                }
                default: {
                    this.updatePrev(cp);
                }
            }
            return 1;
        }

        protected void checkResourceUsage() {
        }

        private void updatePrev(int cp) {
            this.previdx = this.rootIndex + Character.charCount(cp);
            this.prevtype = 24;
        }

        private void checkPreviousWord() throws Exception {
            if (this.isWordPreviousCodepoint()) {
                this.word();
            }
        }

        boolean isWordPreviousCodepoint() throws Exception {
            if (this.prevtype == 2) {
                return true;
            }
            if (this.isPreviousCpWCharacter()) {
                if (this.currentSequence().length() == 1) {
                    TokenProducer3.this.handler.character(this.previdx, Character.codePointAt(this.currentSequence(), 0));
                    this.resetCurrentSequence();
                } else {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isPreviousCpWCharacter() {
            return this.prevtype == 1;
        }

        protected void word() throws Exception {
            CharSequence seq = this.currentSequence();
            if (seq.length() != 1 || !this.isPreviousCpWCharacter()) {
                TokenProducer3.this.handler.word(this.previdx, seq);
            } else {
                TokenProducer3.this.handler.character(this.previdx, seq.charAt(0));
            }
        }

        private void handleCharacter(int cp) throws Exception {
            TokenProducer3.this.handler.character(this.rootIndex, cp);
        }

        void handleControl(int codepoint) throws Exception {
            if (this.externalControlHandling) {
                TokenProducer3.this.controlHandler.control(this.rootIndex, codepoint);
                return;
            }
            if (codepoint == 10) {
                TokenProducer3.this.handler.separator(this.rootIndex, 10);
                if (!this.foundCp13andNotYet10or12) {
                    ++this.line;
                    this.prevlinelength = this.rootIndex;
                } else {
                    this.foundCp13andNotYet10or12 = false;
                    if (this.rootIndex - this.prevlinelength == 1) {
                        ++this.prevlinelength;
                    } else {
                        TokenProducer3.this.errorHandler.error(this.rootIndex, (byte)4, "Unexpected codepoint: " + Integer.toHexString(codepoint));
                    }
                }
            } else if (codepoint == 12) {
                TokenProducer3.this.handler.separator(this.rootIndex, 10);
                if (!this.foundCp13andNotYet10or12) {
                    ++this.line;
                } else {
                    this.foundCp13andNotYet10or12 = false;
                    if (this.rootIndex - this.prevlinelength != 1) {
                        ++this.line;
                    }
                }
                this.prevlinelength = this.rootIndex;
            } else if (codepoint == 13) {
                ++this.line;
                this.prevlinelength = this.rootIndex;
                this.foundCp13andNotYet10or12 = true;
            } else if (codepoint == 9) {
                TokenProducer3.this.handler.separator(this.rootIndex, 9);
            } else if (codepoint < 128) {
                TokenProducer3.this.errorHandler.error(this.rootIndex, (byte)4, "Unexpected codepoint: " + Integer.toHexString(codepoint));
            } else {
                TokenProducer3.this.controlHandler.control(this.rootIndex, codepoint);
            }
        }

        protected void quoted(int quoteCp) throws Exception, IOException {
            CharSequence seq = this.quotedSequence(quoteCp);
            if (seq != null) {
                TokenProducer3.this.handler.quoted(this.previdx, seq, quoteCp);
            }
        }

        public void parse() throws Exception, IOException {
            this.commentManager.parse();
        }

        @Override
        public TokenControl getTokenControl() {
            return this.commentManager;
        }

        protected abstract int nextCodepoint() throws IOException;

        protected abstract CharSequence quotedSequence(int var1) throws Exception, IOException;

        protected abstract void error(int var1, byte var2) throws Exception;

        abstract class CommentManager
        implements TokenControl {
            int commentIndex = 0;
            int commentprevtype = 0;

            CommentManager() {
            }

            void parse() throws Exception, IOException {
                TokenProducer3.this.controlHandler.tokenStart(this);
            }

            @Override
            public void setAcceptNewlineEndingQuote(boolean accept) {
                TokenProducer3.this.setAcceptNewlineEndingQuote(accept);
            }

            @Override
            public void setAcceptEofEndingQuoted(boolean accept) {
                TokenProducer3.this.setAcceptEofEndingQuoted(accept);
            }

            @Override
            public void setExternalLocationHandling(boolean enable) {
                AbstractSequenceParser.this.externalControlHandling = enable;
            }

            @Override
            public int skipNextCodepoint() throws IOException {
                return AbstractSequenceParser.this.nextCodepoint();
            }

            @Override
            public ContentHandler<?> getContentHandler() {
                return TokenProducer3.this.handler;
            }

            @Override
            public void setContentHandler(ContentHandler<?> handler) {
                TokenProducer3.this.handler = handler;
            }

            @Override
            public ControlHandler<?> getControlHandler() {
                return TokenProducer3.this.controlHandler;
            }

            @Override
            public void setControlHandler(ControlHandler<?> handler) {
                TokenProducer3.this.controlHandler = handler;
            }

            @Override
            public TokenErrorHandler<?> getErrorHandler() {
                return TokenProducer3.this.errorHandler;
            }

            @Override
            public void setErrorHandler(TokenErrorHandler<?> handler) {
                TokenProducer3.this.errorHandler = handler;
            }

            public TokenHandler3<E> getTokenHandler() {
                return (TokenHandler3)TokenProducer3.this.handler;
            }

            @Override
            public void setTokenHandler(TokenHandler3<?> handler) {
                TokenHandler3<?> handler3 = handler;
                TokenProducer3.this.handler = handler3;
                TokenProducer3.this.controlHandler = handler3;
                TokenProducer3.this.errorHandler = handler3;
            }

            @Override
            public void setLocationTo(LocatorAccess locator) {
                locator.setLocation(AbstractSequenceParser.this.line, AbstractSequenceParser.this.rootIndex - AbstractSequenceParser.this.prevlinelength);
            }

            @Override
            public void setLocationTo(LocatorAccess locator, int index) {
                locator.setLocation(AbstractSequenceParser.this.line, index - AbstractSequenceParser.this.prevlinelength);
            }

            int verifyComment(int cp) throws Exception, IOException {
                if (this.matchesExpectedOpening(cp)) {
                    if (this.commentIndex == 0) {
                        this.commentprevtype = AbstractSequenceParser.this.prevtype;
                    }
                    ++this.commentIndex;
                    if (this.commentIndex == this.expectedOpeningLength()) {
                        AbstractSequenceParser.this.prevtype = this.commentprevtype;
                        if (AbstractSequenceParser.this.isWordPreviousCodepoint()) {
                            this.wordPrecedingComment();
                        }
                        int openingLength = this.expectedOpeningLength();
                        this.commentIndex = 0;
                        ++AbstractSequenceParser.this.rootIndex;
                        AbstractSequenceParser.this.previdx = AbstractSequenceParser.this.rootIndex--;
                        String comment = this.commentedSequence();
                        TokenProducer3.this.handler.commented(AbstractSequenceParser.this.previdx - openingLength, this.getLastCommentClass(), comment);
                        AbstractSequenceParser.this.resetCurrentSequence();
                        AbstractSequenceParser.this.prevtype = -1;
                        return 2;
                    }
                    return 0;
                }
                if (this.commentIndex != 0) {
                    this.commentIndex = 0;
                    this.commentprevtype = 0;
                    return this.matchesExpectedOpening(cp) ? -2 : -1;
                }
                return 1;
            }

            void wordPrecedingComment() throws Exception {
                AbstractSequenceParser.this.word();
            }

            abstract boolean matchesExpectedOpening(int var1);

            abstract int expectedOpeningLength();

            abstract int closingLength();

            abstract int getLastCommentClass();

            abstract String commentedSequence() throws Exception, IOException;
        }

        /*
         * Signature claims super is io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.CommentManager, not io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser$CommentManager - discarding signature.
         */
        abstract class MultiCommentManager
        extends CommentManager {
            private int delimcount = 0;
            private int[][] commentStart;
            private int[][] commentEnd;
            private boolean[] disabledComments;
            private int commentClass = -1;

            MultiCommentManager(String[] start, String[] end) {
                if (start == null || end == null) {
                    throw new NullPointerException("Null comment token arrays.");
                }
                this.setCommentDelimiters(start, end);
            }

            @Override
            boolean matchesExpectedOpening(int cp) {
                if (this.isBeginningOfOpening()) {
                    for (int i = 0; i < this.delimcount; ++i) {
                        if (this.commentStart[i][0] != cp || this.disabledComments[i]) continue;
                        this.commentClass = i;
                        return true;
                    }
                    return false;
                }
                if (this.commentStart[this.commentClass][this.commentIndex] == cp && !this.disabledComments[this.commentClass]) {
                    return true;
                }
                block1: for (int i = this.commentClass + 1; i < this.delimcount; ++i) {
                    int len = this.commentStart[i].length;
                    if (this.commentIndex >= len || this.commentStart[i][this.commentIndex] != cp || this.disabledComments[i]) continue;
                    for (int j = this.commentIndex - 1; j != -1; --j) {
                        if (this.commentStart[i][j] != cp) continue block1;
                    }
                    this.commentClass = i;
                    return true;
                }
                return false;
            }

            @Override
            int expectedOpeningLength() {
                return this.commentIndex == 0 ? -1 : this.commentStart[this.commentClass].length;
            }

            boolean isBeginningOfOpening() {
                return this.commentIndex == 0;
            }

            @Override
            int getLastCommentClass() {
                return this.commentClass;
            }

            int getMaxOpeningLength() {
                int slen = this.commentStart[0].length;
                for (int i = 1; i < this.delimcount; ++i) {
                    int len = this.commentStart[i].length;
                    if (len <= slen) continue;
                    slen = len;
                }
                return slen;
            }

            @Override
            int closingLength() {
                return this.commentEnd[this.commentClass].length;
            }

            boolean closingEndsWithLF() {
                return this.closingEndsWith(13);
            }

            boolean closingEndsWith(int cp) {
                return this.closingCodepointAt(this.closingLength() - 1) == cp;
            }

            int closingCodepointAt(int idx) {
                return this.commentEnd[this.commentClass][idx];
            }

            private void setCommentDelimiters(String[] start, String[] end) {
                this.delimcount = start.length;
                if (this.delimcount != end.length) {
                    throw new IllegalArgumentException("Unmatched begin/end comment delimiters");
                }
                this.disabledComments = new boolean[this.delimcount];
                int[][] commentStart = new int[this.delimcount][];
                int[][] commentEnd = new int[this.delimcount][];
                for (int i = 0; i < this.delimcount; ++i) {
                    int cp;
                    int j;
                    String s = start[i];
                    int len = s.length();
                    commentStart[i] = new int[len];
                    for (j = 0; j < len; ++j) {
                        commentStart[i][j] = cp = s.codePointAt(j);
                        if (cp != 92) continue;
                        throw new IllegalArgumentException("Not an allowed comment delimiter");
                    }
                    s = end[i];
                    len = s.length();
                    commentEnd[i] = new int[len];
                    for (j = 0; j < len; ++j) {
                        commentEnd[i][j] = cp = s.codePointAt(j);
                        if (cp != 92) continue;
                        throw new IllegalArgumentException("Not an allowed comment delimiter");
                    }
                }
                this.commentStart = commentStart;
                this.commentEnd = commentEnd;
            }

            @Override
            public void enableAllComments() {
                Arrays.fill(this.disabledComments, false);
            }

            @Override
            public void disableAllComments() {
                Arrays.fill(this.disabledComments, true);
            }

            @Override
            public void enableComments(int type) {
                this.disabledComments[type] = false;
            }

            @Override
            public void disableComments(int type) {
                this.disabledComments[type] = true;
            }
        }

        /*
         * Signature claims super is io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.CommentManager, not io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser$CommentManager - discarding signature.
         */
        abstract class SingleCommentManager
        extends CommentManager {
            int[] commentStart;
            int[] commentEnd;
            private boolean disabledComments = false;

            SingleCommentManager(String start, String end) {
                this.setCommentDelimiters(start, end);
            }

            @Override
            boolean matchesExpectedOpening(int cp) {
                return this.commentStart[this.commentIndex] == cp && !this.disabledComments;
            }

            @Override
            int expectedOpeningLength() {
                return this.commentStart.length;
            }

            @Override
            int getLastCommentClass() {
                return 0;
            }

            @Override
            int closingLength() {
                return this.commentEnd.length;
            }

            boolean closingEndsWithLF() {
                return this.closingEndsWith(13);
            }

            boolean closingEndsWith(int cp) {
                return this.closingCodepointAt(this.closingLength() - 1) == cp;
            }

            int closingCodepointAt(int idx) {
                return this.commentEnd[idx];
            }

            private void setCommentDelimiters(String start, String end) {
                int i;
                int slen = start.length();
                int elen = end.length();
                int[] commentStart = new int[slen];
                int[] commentEnd = new int[elen];
                for (i = 0; i < slen; ++i) {
                    commentStart[i] = start.codePointAt(i);
                    if (commentStart[i] != 92) continue;
                    throw new IllegalArgumentException("Not an allowed comment delimiter");
                }
                for (i = 0; i < elen; ++i) {
                    commentEnd[i] = end.codePointAt(i);
                    if (commentEnd[i] != 92) continue;
                    throw new IllegalArgumentException("Not an allowed comment delimiter");
                }
                this.commentStart = commentStart;
                this.commentEnd = commentEnd;
            }

            @Override
            public void enableAllComments() {
                this.disabledComments = false;
            }

            @Override
            public void disableAllComments() {
                this.disabledComments = true;
            }

            @Override
            public void enableComments(int type) {
                if (type == 0) {
                    this.disabledComments = false;
                }
            }

            @Override
            public void disableComments(int type) {
                if (type == 0) {
                    this.disabledComments = true;
                }
            }
        }

        /*
         * Signature claims super is io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser.CommentManager, not io.sf.carte.uparser.TokenProducer3$AbstractSequenceParser$CommentManager - discarding signature.
         */
        abstract class NoCommentManager
        extends CommentManager {
            NoCommentManager() {
            }

            @Override
            public void enableAllComments() {
            }

            @Override
            public void disableAllComments() {
            }

            @Override
            public void enableComments(int type) {
            }

            @Override
            public void disableComments(int type) {
            }

            @Override
            boolean matchesExpectedOpening(int cp) {
                return false;
            }

            @Override
            int verifyComment(int cp) throws IOException {
                return 1;
            }

            @Override
            int expectedOpeningLength() {
                return 0;
            }

            @Override
            int closingLength() {
                return 0;
            }

            @Override
            int getLastCommentClass() {
                return 0;
            }

            @Override
            String commentedSequence() throws IOException {
                return "";
            }
        }
    }

    public static interface SequenceParser<E extends Exception> {
        public CharSequence currentSequence();

        public boolean isPreviousCpWCharacter();

        public TokenControl getTokenControl();

        public void resetCurrentSequence();
    }
}

