/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import org.apache.solr.client.api.model.BackupDeletionResponseBody;
import org.apache.solr.client.api.model.ListCollectionBackupsResponse;
import org.apache.solr.client.api.model.PurgeUnusedFilesRequestBody;
import org.apache.solr.client.api.model.PurgeUnusedResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class CollectionBackupsApi {

    public static class ListBackupsAtLocation
    extends SolrRequest<ListBackupsAtLocationResponse> {
        private final String backupName;
        private String location;
        private String repository;

        public ListBackupsAtLocation(String backupName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/backups/{backupName}/versions".replace("{backupName}", backupName));
            this.backupName = backupName;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.location != null) {
                params.add("location", this.location);
            }
            if (this.repository != null) {
                params.add("repository", this.repository);
            }
            return params;
        }

        @Override
        protected ListBackupsAtLocationResponse createResponse(SolrClient client) {
            return new ListBackupsAtLocationResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ListBackupsAtLocationResponse
    extends JacksonParsingResponse<ListCollectionBackupsResponse> {
        public ListBackupsAtLocationResponse() {
            super(ListCollectionBackupsResponse.class);
        }
    }

    public static class GarbageCollectUnusedBackupFiles
    extends SolrRequest<GarbageCollectUnusedBackupFilesResponse> {
        private final PurgeUnusedFilesRequestBody requestBody;
        private final String backupName;

        public GarbageCollectUnusedBackupFiles(String backupName) {
            super(SolrRequest.METHOD.valueOf("PUT"), "/backups/{backupName}/purgeUnused".replace("{backupName}", backupName));
            this.backupName = backupName;
            this.requestBody = new PurgeUnusedFilesRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setLocation(String location) {
            this.requestBody.location = location;
        }

        public void setRepositoryName(String repositoryName) {
            this.requestBody.repositoryName = repositoryName;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected GarbageCollectUnusedBackupFilesResponse createResponse(SolrClient client) {
            return new GarbageCollectUnusedBackupFilesResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GarbageCollectUnusedBackupFilesResponse
    extends JacksonParsingResponse<PurgeUnusedResponse> {
        public GarbageCollectUnusedBackupFilesResponse() {
            super(PurgeUnusedResponse.class);
        }
    }

    public static class DeleteSingleBackupById
    extends SolrRequest<DeleteSingleBackupByIdResponse> {
        private final String backupName;
        private final String backupId;
        private String location;
        private String repository;
        private String async;

        public DeleteSingleBackupById(String backupName, String backupId) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/backups/{backupName}/versions/{backupId}".replace("{backupName}", backupName).replace("{backupId}", backupId));
            this.backupName = backupName;
            this.backupId = backupId;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public void setRepository(String repository) {
            this.repository = repository;
        }

        public void setAsync(String async) {
            this.async = async;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.location != null) {
                params.add("location", this.location);
            }
            if (this.repository != null) {
                params.add("repository", this.repository);
            }
            if (this.async != null) {
                params.add("async", this.async);
            }
            return params;
        }

        @Override
        protected DeleteSingleBackupByIdResponse createResponse(SolrClient client) {
            return new DeleteSingleBackupByIdResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteSingleBackupByIdResponse
    extends JacksonParsingResponse<BackupDeletionResponseBody> {
        public DeleteSingleBackupByIdResponse() {
            super(BackupDeletionResponseBody.class);
        }
    }

    public static class DeleteMultipleBackupsByRecency
    extends SolrRequest<DeleteMultipleBackupsByRecencyResponse> {
        private final String backupName;
        private Integer retainLatest;
        private String location;
        private String repository;
        private String async;

        public DeleteMultipleBackupsByRecency(String backupName) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/backups/{backupName}/versions".replace("{backupName}", backupName));
            this.backupName = backupName;
        }

        public void setRetainLatest(Integer retainLatest) {
            this.retainLatest = retainLatest;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public void setRepository(String repository) {
            this.repository = repository;
        }

        public void setAsync(String async) {
            this.async = async;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.retainLatest != null) {
                params.add("retainLatest", this.retainLatest.toString());
            }
            if (this.location != null) {
                params.add("location", this.location);
            }
            if (this.repository != null) {
                params.add("repository", this.repository);
            }
            if (this.async != null) {
                params.add("async", this.async);
            }
            return params;
        }

        @Override
        protected DeleteMultipleBackupsByRecencyResponse createResponse(SolrClient client) {
            return new DeleteMultipleBackupsByRecencyResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteMultipleBackupsByRecencyResponse
    extends JacksonParsingResponse<BackupDeletionResponseBody> {
        public DeleteMultipleBackupsByRecencyResponse() {
            super(BackupDeletionResponseBody.class);
        }
    }
}

