/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.CollectionProperties;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/collections/{collName}/properties/{propName}")
public class CollectionPropertyAPI
extends AdminAPIBase {
    public CollectionPropertyAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PUT
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    public SolrJerseyResponse createOrUpdateCollectionProperty(@PathParam(value="collName") String collName, @PathParam(value="propName") String propName, UpdateCollectionPropertyRequestBody requestBody) throws Exception {
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required request body");
        }
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        CollectionPropertyAPI.recordCollectionForLogAndTracing(collName, this.solrQueryRequest);
        this.modifyCollectionProperty(collName, propName, requestBody.value);
        return response;
    }

    @DELETE
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    public SolrJerseyResponse deleteCollectionProperty(@PathParam(value="collName") String collName, @PathParam(value="propName") String propName) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        CollectionPropertyAPI.recordCollectionForLogAndTracing(collName, this.solrQueryRequest);
        this.modifyCollectionProperty(collName, propName, null);
        return response;
    }

    private void modifyCollectionProperty(String collection, String propertyName, String propertyValue) throws IOException {
        String resolvedCollection = this.coreContainer.getAliases().resolveSimpleAlias(collection);
        CollectionProperties cp = new CollectionProperties(this.coreContainer.getZkController().getZkClient());
        cp.setCollectionProperty(resolvedCollection, propertyName, propertyValue);
    }

    public static class UpdateCollectionPropertyRequestBody
    implements JacksonReflectMapWriter {
        @JsonProperty(required=true)
        public String value;

        public UpdateCollectionPropertyRequestBody() {
        }

        public UpdateCollectionPropertyRequestBody(String value) {
            this.value = value;
        }
    }
}

