/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import javax.inject.Inject;
import org.apache.solr.client.api.endpoint.BalanceReplicasApi;
import org.apache.solr.client.api.model.BalanceReplicasRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class BalanceReplicas
extends AdminAPIBase
implements BalanceReplicasApi {
    @Inject
    public BalanceReplicas(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse balanceReplicas(BalanceReplicasRequestBody requestBody) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        ZkNodeProps remoteMessage = this.createRemoteMessage(requestBody);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.BALANCE_REPLICAS, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        this.disableResponseCaching();
        return response;
    }

    public ZkNodeProps createRemoteMessage(BalanceReplicasRequestBody requestBody) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        if (requestBody != null) {
            BalanceReplicas.insertIfNotNull(remoteMessage, "nodes", requestBody.nodes);
            BalanceReplicas.insertIfNotNull(remoteMessage, "waitForFinalState", requestBody.waitForFinalState);
            BalanceReplicas.insertIfNotNull(remoteMessage, "async", requestBody.async);
        }
        remoteMessage.put("operation", CollectionParams.CollectionAction.BALANCE_REPLICAS.toLower());
        return new ZkNodeProps(remoteMessage);
    }
}

