/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Phaser;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;
import org.apache.solr.api.AnnotatedApi;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.api.ConfigurablePlugin;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.V2HttpCall;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.PluginMeta;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.annotation.JsonProperty;
import org.apache.solr.common.cloud.ClusterPropertiesListener;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.PathTrie;
import org.apache.solr.common.util.ReflectMapWriter;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.handler.admin.ContainerPluginsApi;
import org.apache.solr.pkg.SolrPackageLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.SolrJacksonAnnotationInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerPluginsRegistry
implements ClusterPropertiesListener,
MapWriter,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ObjectMapper mapper = SolrJacksonAnnotationInspector.createObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS});
    private final List<PluginRegistryListener> listeners = new CopyOnWriteArrayList<PluginRegistryListener>();
    private final CoreContainer coreContainer;
    private final ApiBag containerApiBag;
    private final Map<String, ApiInfo> currentPlugins = new HashMap<String, ApiInfo>();
    private Phaser phaser;

    public boolean onChange(Map<String, Object> properties) {
        this.refresh();
        Phaser localPhaser = this.phaser;
        if (localPhaser != null) {
            localPhaser.arrive();
        }
        return false;
    }

    @VisibleForTesting
    public void setPhaser(Phaser phaser) {
        phaser.register();
        this.phaser = phaser;
    }

    public void registerListener(PluginRegistryListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(PluginRegistryListener listener) {
        this.listeners.remove(listener);
    }

    public ContainerPluginsRegistry(CoreContainer coreContainer, ApiBag apiBag) {
        this.coreContainer = coreContainer;
        this.containerApiBag = apiBag;
    }

    public synchronized void writeMap(MapWriter.EntryWriter ew) throws IOException {
        this.currentPlugins.forEach(ew.getBiConsumer());
    }

    @Override
    public synchronized void close() throws IOException {
        this.currentPlugins.values().forEach(apiInfo -> {
            if (apiInfo.instance instanceof Closeable) {
                org.apache.solr.common.util.IOUtils.closeQuietly((Closeable)((Closeable)apiInfo.instance));
            }
        });
    }

    public synchronized ApiInfo getPlugin(String name) {
        return this.currentPlugins.get(name);
    }

    public synchronized void refresh() {
        Map<String, Object> pluginInfos;
        try {
            pluginInfos = ContainerPluginsApi.plugins(this.coreContainer.zkClientSupplier);
        }
        catch (IOException e) {
            log.error("Could not read plugins data", (Throwable)e);
            return;
        }
        HashMap newState = CollectionUtil.newHashMap((int)pluginInfos.size());
        for (Map.Entry<String, Object> entry : pluginInfos.entrySet()) {
            try {
                newState.put(entry.getKey(), new PluginMetaHolder((Map)entry.getValue()));
            }
            catch (Exception exception) {
                log.error("Invalid apiInfo configuration :", (Throwable)exception);
            }
        }
        HashMap<String, PluginMetaHolder> currentState = new HashMap<String, PluginMetaHolder>();
        for (Map.Entry<String, ApiInfo> entry : this.currentPlugins.entrySet()) {
            currentState.put(entry.getKey(), entry.getValue().holder);
        }
        Map<String, Diff> map = ContainerPluginsRegistry.compareMaps(currentState, newState);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, Diff> e : map.entrySet()) {
            Object old;
            if (e.getValue() == Diff.UNCHANGED) continue;
            if (e.getValue() == Diff.REMOVED) {
                ApiInfo apiInfo = this.currentPlugins.remove(e.getKey());
                if (apiInfo == null) continue;
                this.listeners.forEach(listener -> listener.deleted(apiInfo));
                for (ApiHolder holder2 : apiInfo.holders) {
                    old = this.containerApiBag.unregister(holder2.api.getEndPoint().method()[0], ContainerPluginsRegistry.getActualPath(apiInfo, holder2.api.getEndPoint().path()[0]));
                    if (!(old instanceof Closeable)) continue;
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{(Closeable)old});
                }
                continue;
            }
            PluginMetaHolder info = (PluginMetaHolder)newState.get(e.getKey());
            ArrayList<String> errs = new ArrayList<String>();
            ApiInfo apiInfo = new ApiInfo(info, errs);
            if (!errs.isEmpty()) {
                log.error(StrUtils.join(errs, (char)','));
                continue;
            }
            try {
                apiInfo.init();
            }
            catch (Exception exp) {
                log.error("Cannot install apiInfo ", (Throwable)exp);
                continue;
            }
            if (e.getValue() == Diff.ADDED) {
                for (ApiHolder apiHolder : apiInfo.holders) {
                    this.containerApiBag.register(apiHolder, ContainerPluginsRegistry.getTemplateVars(apiInfo.info));
                }
                this.currentPlugins.put(e.getKey(), apiInfo);
                ApiInfo apiInfoFinal = apiInfo;
                this.listeners.forEach(listener -> listener.added(apiInfoFinal));
                continue;
            }
            old = this.currentPlugins.put(e.getKey(), apiInfo);
            for (ApiHolder holder4 : apiInfo.holders) {
                this.containerApiBag.register(holder4, ContainerPluginsRegistry.getTemplateVars(apiInfo.info));
            }
            ApiInfo apiInfo2 = apiInfo;
            this.listeners.forEach(arg_0 -> ContainerPluginsRegistry.lambda$refresh$3((ApiInfo)old, apiInfo2, arg_0));
            if (old == null) continue;
            for (ApiHolder oldHolder : ((ApiInfo)old).holders) {
                if (apiInfo.get(oldHolder.api.getEndPoint()) != null) continue;
                this.containerApiBag.unregister(oldHolder.getMethod(), ContainerPluginsRegistry.getActualPath((ApiInfo)old, oldHolder.getPath()));
            }
            if (!(old instanceof Closeable)) continue;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{(Closeable)old});
        }
    }

    private static String getActualPath(ApiInfo apiInfo, String path) {
        return path.replace("$path-prefix", Objects.requireNonNullElse(apiInfo.info.pathPrefix, "")).replace("$plugin-name", apiInfo.info.name);
    }

    private static Map<String, String> getTemplateVars(PluginMeta pluginMeta) {
        return Utils.makeMap((String)"plugin-name", (Object)pluginMeta.name, (String)"path-prefix", (Object)pluginMeta.pathPrefix);
    }

    public static <T extends MapWriter> Class<T> getConfigClass(ConfigurablePlugin<T> o) {
        Class<?> klas = o.getClass();
        do {
            Type[] interfaces;
            for (Type type : interfaces = klas.getGenericInterfaces()) {
                ParameterizedType parameterizedType;
                Type rawType;
                if (!(type instanceof ParameterizedType) || (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) != ConfigurablePlugin.class && (!(rawType instanceof Class) || !ConfigurablePlugin.class.isAssignableFrom((Class)rawType))) continue;
                return (Class)parameterizedType.getActualTypeArguments()[0];
            }
        } while ((klas = klas.getSuperclass()) != null && klas != Object.class);
        return null;
    }

    public ApiInfo createInfo(Map<String, Object> info, List<String> errs) throws IOException {
        return new ApiInfo(new PluginMetaHolder(info), errs);
    }

    public static Map<String, Diff> compareMaps(Map<String, ?> a, Map<String, ?> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return null;
        }
        HashMap result = CollectionUtil.newHashMap((int)Math.max(a.size(), b.size()));
        a.forEach((k, v) -> {
            Object newVal = b.get(k);
            if (newVal == null) {
                result.put(k, Diff.REMOVED);
                return;
            }
            result.put(k, Objects.equals(v, newVal) ? Diff.UNCHANGED : Diff.UPDATED);
        });
        b.forEach((k, v) -> {
            if (a.get(k) == null) {
                result.put(k, Diff.ADDED);
            }
        });
        for (Diff value : result.values()) {
            if (value == Diff.UNCHANGED) continue;
            return result;
        }
        return null;
    }

    private static /* synthetic */ void lambda$refresh$3(ApiInfo old, ApiInfo apiInfoFinal, PluginRegistryListener listener) {
        listener.modified(old, apiInfoFinal);
    }

    public static interface PluginRegistryListener {
        public void added(ApiInfo var1);

        public void deleted(ApiInfo var1);

        public void modified(ApiInfo var1, ApiInfo var2);
    }

    public static enum Diff {
        ADDED,
        REMOVED,
        UNCHANGED,
        UPDATED;

    }

    public class ApiInfo
    implements ReflectMapWriter {
        List<ApiHolder> holders;
        private final PluginMetaHolder holder;
        @JsonProperty
        private final PluginMeta info;
        @JsonProperty(value="package")
        public final String pkg;
        private SolrPackageLoader.SolrPackage.Version pkgVersion;
        private Class<?> klas;
        Object instance;

        ApiHolder get(EndPoint endPoint) {
            for (ApiHolder holder : this.holders) {
                EndPoint e = holder.api.getEndPoint();
                if (!Objects.equals(endPoint.method()[0], e.method()[0]) || !Objects.equals(endPoint.path()[0], e.path()[0])) continue;
                return holder;
            }
            return null;
        }

        public Object getInstance() {
            return this.instance;
        }

        public PluginMeta getInfo() {
            return this.info.copy();
        }

        public ApiInfo(PluginMetaHolder infoHolder, List<String> errs) {
            this.holder = infoHolder;
            this.info = infoHolder.meta;
            PluginInfo.ClassName klassInfo = new PluginInfo.ClassName(this.info.klass);
            this.pkg = klassInfo.pkg;
            if (this.pkg != null) {
                Optional<SolrPackageLoader.SolrPackage.Version> ver = ContainerPluginsRegistry.this.coreContainer.getPackageLoader().getPackageVersion(this.pkg, this.info.version);
                if (ver.isEmpty()) {
                    ContainerPluginsRegistry.this.coreContainer.getPackageLoader().getPackageAPI().refreshPackages(null);
                    ver = ContainerPluginsRegistry.this.coreContainer.getPackageLoader().getPackageVersion(this.pkg, this.info.version);
                }
                if (ver.isEmpty()) {
                    SolrPackageLoader.SolrPackage p = ContainerPluginsRegistry.this.coreContainer.getPackageLoader().getPackage(this.pkg);
                    if (p == null) {
                        errs.add("Invalid package " + klassInfo.pkg);
                        return;
                    }
                    errs.add("No such package version:" + this.pkg + ":" + this.info.version + " . available versions :" + p.allVersions());
                    return;
                }
                this.pkgVersion = ver.get();
                try {
                    this.klas = this.pkgVersion.getLoader().findClass(klassInfo.className, Object.class);
                }
                catch (Exception e) {
                    log.error("Error loading class", (Throwable)e);
                    errs.add("Error loading class " + e.toString());
                    return;
                }
            }
            try {
                this.klas = ContainerPluginsRegistry.this.coreContainer.getResourceLoader().findClass(klassInfo.className, Object.class);
            }
            catch (Exception e) {
                errs.add(e.toString());
                return;
            }
            this.pkgVersion = null;
            if (!Modifier.isPublic(this.klas.getModifiers())) {
                errs.add("Class must be public and static : " + this.klas.getName());
                return;
            }
            try {
                List<Api> apis = AnnotatedApi.getApis(this.klas, null, true);
                for (Api api : apis) {
                    EndPoint endPoint = ((AnnotatedApi)api).getEndPoint();
                    if (endPoint.path().length > 1 || endPoint.method().length > 1) {
                        errs.add("Only one HTTP method and url supported for each API");
                    }
                    if (endPoint.method().length != 1 || endPoint.path().length != 1) {
                        errs.add("The @EndPoint must have exactly one method and path attributes");
                    }
                    List pathSegments = StrUtils.splitSmart((String)endPoint.path()[0], (char)'/', (boolean)true);
                    PathTrie.replaceTemplates((List)pathSegments, ContainerPluginsRegistry.getTemplateVars(this.info));
                    if (!V2HttpCall.knownPrefixes.contains(pathSegments.get(0))) continue;
                    errs.add("path must not have a prefix: " + (String)pathSegments.get(0));
                }
            }
            catch (Exception e) {
                errs.add(e.toString());
            }
            if (!errs.isEmpty()) {
                return;
            }
            Constructor<?> constructor = this.klas.getConstructors()[0];
            if (constructor.getParameterTypes().length > 1 || constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0] != CoreContainer.class) {
                errs.add("Must have a no-arg constructor or CoreContainer constructor and it must not be a non static inner class");
                return;
            }
            if (!Modifier.isPublic(constructor.getModifiers())) {
                errs.add("Must have a public constructor ");
                return;
            }
        }

        public void init() throws Exception {
            Class c;
            if (this.holders != null) {
                return;
            }
            Constructor<?> constructor = this.klas.getConstructors()[0];
            if (constructor.getParameterTypes().length == 0) {
                this.instance = constructor.newInstance(new Object[0]);
            } else if (constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0] == CoreContainer.class) {
                this.instance = constructor.newInstance(ContainerPluginsRegistry.this.coreContainer);
            } else {
                throw new RuntimeException("Must have a no-arg constructor or CoreContainer constructor ");
            }
            if (this.instance instanceof ConfigurablePlugin && (c = ContainerPluginsRegistry.getConfigClass((ConfigurablePlugin)this.instance)) != null) {
                Map original = this.holder.original.getOrDefault("config", Collections.emptyMap());
                this.holder.meta.config = (MapWriter)mapper.readValue(Utils.toJSON(original), c);
                ((ConfigurablePlugin)this.instance).configure(this.holder.meta.config);
            }
            if (this.instance instanceof ResourceLoaderAware) {
                try {
                    ((ResourceLoaderAware)this.instance).inform((ResourceLoader)this.pkgVersion.getLoader());
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
            this.holders = new ArrayList<ApiHolder>();
            for (Api api : AnnotatedApi.getApis(this.instance.getClass(), this.instance, true)) {
                this.holders.add(new ApiHolder((AnnotatedApi)api));
            }
        }
    }

    private static class ApiHolder
    extends Api {
        final AnnotatedApi api;

        protected ApiHolder(AnnotatedApi api) {
            super(api);
            this.api = api;
        }

        @Override
        public void call(SolrQueryRequest req, SolrQueryResponse rsp) {
            this.api.call(req, rsp);
        }

        public String getPath() {
            return this.api.getEndPoint().path()[0];
        }

        public SolrRequest.METHOD getMethod() {
            return this.api.getEndPoint().method()[0];
        }
    }

    static class PluginMetaHolder {
        private final Map<String, Object> original;
        private final PluginMeta meta;

        PluginMetaHolder(Map<String, Object> original) throws IOException {
            this.original = original;
            this.meta = (PluginMeta)mapper.readValue(Utils.toJSON(original), PluginMeta.class);
        }

        public boolean equals(Object obj) {
            if (obj instanceof PluginMetaHolder) {
                PluginMetaHolder that = (PluginMetaHolder)obj;
                return Objects.equals(this.original, that.original);
            }
            return false;
        }

        public int hashCode() {
            return this.original.hashCode();
        }
    }
}

