/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.impl;

import java.util.Objects;
import org.ocpsoft.prettytime.Duration;
import org.ocpsoft.prettytime.TimeUnit;

public class DurationImpl
implements Duration {
    private long quantity;
    private long delta;
    private TimeUnit unit;

    @Override
    public long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(long quantity) {
        this.quantity = quantity;
    }

    @Override
    public TimeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    @Override
    public long getDelta() {
        return this.delta;
    }

    public void setDelta(long delta) {
        this.delta = delta;
    }

    @Override
    public boolean isInPast() {
        return this.getQuantity() < 0L;
    }

    @Override
    public boolean isInFuture() {
        return !this.isInPast();
    }

    @Override
    public long getQuantityRounded(int tolerance) {
        double threshold;
        long quantity = Math.abs(this.getQuantity());
        if (this.getDelta() != 0L && (threshold = Math.abs((double)this.getDelta() / (double)this.getUnit().getMillisPerUnit() * 100.0)) > (double)tolerance) {
            ++quantity;
        }
        return quantity;
    }

    public String toString() {
        return "DurationImpl [" + this.quantity + " " + this.unit + ", delta=" + this.delta + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Long.hashCode(this.delta);
        result = 31 * result + Long.hashCode(this.quantity);
        result = 31 * result + Objects.hashCode(this.unit);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DurationImpl other = (DurationImpl)obj;
        if (this.delta != other.delta) {
            return false;
        }
        if (this.quantity != other.quantity) {
            return false;
        }
        return Objects.equals(this.unit, other.unit);
    }
}

