/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.i18n;

import java.util.ListResourceBundle;
import org.ocpsoft.prettytime.Duration;
import org.ocpsoft.prettytime.TimeFormat;
import org.ocpsoft.prettytime.TimeUnit;
import org.ocpsoft.prettytime.impl.TimeFormatProvider;
import org.ocpsoft.prettytime.units.Century;
import org.ocpsoft.prettytime.units.Day;
import org.ocpsoft.prettytime.units.Decade;
import org.ocpsoft.prettytime.units.Hour;
import org.ocpsoft.prettytime.units.JustNow;
import org.ocpsoft.prettytime.units.Millennium;
import org.ocpsoft.prettytime.units.Millisecond;
import org.ocpsoft.prettytime.units.Minute;
import org.ocpsoft.prettytime.units.Month;
import org.ocpsoft.prettytime.units.Second;
import org.ocpsoft.prettytime.units.Week;
import org.ocpsoft.prettytime.units.Year;

public class Resources_pl
extends ListResourceBundle
implements TimeFormatProvider {
    private static final Object[][] OBJECTS = new Object[0][0];
    private static final int tolerance = 50;
    private static final int polishPluralForms = 3;

    @Override
    public Object[][] getContents() {
        return OBJECTS;
    }

    @Override
    public TimeFormat getFormatFor(TimeUnit t) {
        if (t instanceof JustNow) {
            return new TimeFormat(){

                @Override
                public String format(Duration duration) {
                    return this.performFormat(duration);
                }

                @Override
                public String formatUnrounded(Duration duration) {
                    return this.performFormat(duration);
                }

                private String performFormat(Duration duration) {
                    if (duration.isInFuture()) {
                        return "za chwil\u0119";
                    }
                    if (duration.isInPast()) {
                        return "przed chwil\u0105";
                    }
                    return null;
                }

                @Override
                public String decorate(Duration duration, String time) {
                    return time;
                }

                @Override
                public String decorateUnrounded(Duration duration, String time) {
                    return time;
                }
            };
        }
        if (t instanceof Century) {
            return new TimeFormatAided("wiek", "wieki", "wiek\u00f3w");
        }
        if (t instanceof Day) {
            return new TimeFormatAided("dzie\u0144", "dni", "dni");
        }
        if (t instanceof Decade) {
            return new TimeFormatAided("dekad\u0119", "dekady", "dekad");
        }
        if (t instanceof Hour) {
            return new TimeFormatAided("godzin\u0119", "godziny", "godzin");
        }
        if (t instanceof Millennium) {
            return new TimeFormatAided("milenium", "milenia", "mileni\u00f3w");
        }
        if (t instanceof Millisecond) {
            return new TimeFormatAided("milisekund\u0119", "milisekundy", "milisekund");
        }
        if (t instanceof Minute) {
            return new TimeFormatAided("minut\u0119", "minuty", "minut");
        }
        if (t instanceof Month) {
            return new TimeFormatAided("miesi\u0105c", "miesi\u0105ce", "miesi\u0119cy");
        }
        if (t instanceof Second) {
            return new TimeFormatAided("sekund\u0119", "sekundy", "sekund");
        }
        if (t instanceof Week) {
            return new TimeFormatAided("tydzie\u0144", "tygodnie", "tygodni");
        }
        if (t instanceof Year) {
            return new TimeFormatAided("rok", "lata", "lat");
        }
        return null;
    }

    private static class TimeFormatAided
    implements TimeFormat {
        private final String[] plurals;

        public TimeFormatAided(String ... plurals) {
            if (plurals.length != 3) {
                throw new IllegalArgumentException("Wrong plural forms number for Polish language!");
            }
            this.plurals = plurals;
        }

        @Override
        public String format(Duration duration) {
            long quantity = duration.getQuantityRounded(50);
            return String.valueOf(quantity);
        }

        @Override
        public String formatUnrounded(Duration duration) {
            long quantity = Math.abs(duration.getQuantity());
            return String.valueOf(quantity);
        }

        @Override
        public String decorate(Duration duration, String time) {
            return this.performDecoration(duration.isInPast(), duration.isInFuture(), duration.getQuantityRounded(50), time);
        }

        @Override
        public String decorateUnrounded(Duration duration, String time) {
            return this.performDecoration(duration.isInPast(), duration.isInFuture(), Math.abs(duration.getQuantity()), time);
        }

        private String performDecoration(boolean past, boolean future, long n, String time) {
            int pluralIdx;
            int n2 = n == 1L ? 0 : (pluralIdx = n % 10L >= 2L && n % 10L <= 4L && (n % 100L < 10L || n % 100L >= 20L) ? 1 : 2);
            if (pluralIdx > 3) {
                throw new IllegalStateException("Wrong plural index was calculated somehow for Polish language");
            }
            StringBuilder result = new StringBuilder();
            if (future) {
                result.append("za ");
            }
            result.append(time);
            result.append(' ');
            result.append(this.plurals[pluralIdx]);
            if (past) {
                result.append(" temu");
            }
            return result.toString();
        }
    }
}

