/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime;

import java.time.temporal.ChronoUnit;
import org.ocpsoft.prettytime.units.Century;
import org.ocpsoft.prettytime.units.Day;
import org.ocpsoft.prettytime.units.Decade;
import org.ocpsoft.prettytime.units.Hour;
import org.ocpsoft.prettytime.units.Millennium;
import org.ocpsoft.prettytime.units.Millisecond;
import org.ocpsoft.prettytime.units.Minute;
import org.ocpsoft.prettytime.units.Month;
import org.ocpsoft.prettytime.units.Second;
import org.ocpsoft.prettytime.units.Week;
import org.ocpsoft.prettytime.units.Year;

public interface TimeUnit {
    public long getMillisPerUnit();

    public long getMaxQuantity();

    public boolean isPrecise();

    public static TimeUnit of(ChronoUnit chronoUnit) {
        switch (chronoUnit) {
            case MILLIS: {
                return new Millisecond();
            }
            case SECONDS: {
                return new Second();
            }
            case MINUTES: {
                return new Minute();
            }
            case HOURS: {
                return new Hour();
            }
            case DAYS: {
                return new Day();
            }
            case WEEKS: {
                return new Week();
            }
            case MONTHS: {
                return new Month();
            }
            case YEARS: {
                return new Year();
            }
            case DECADES: {
                return new Decade();
            }
            case CENTURIES: {
                return new Century();
            }
            case MILLENNIA: {
                return new Millennium();
            }
        }
        throw new IllegalArgumentException("No corresponding TimeUnit for given ChronoUnit");
    }

    public static ChronoUnit toChronoUnit(TimeUnit timeUnit) {
        if (timeUnit instanceof Millisecond) {
            return ChronoUnit.MILLIS;
        }
        if (timeUnit instanceof Second) {
            return ChronoUnit.SECONDS;
        }
        if (timeUnit instanceof Minute) {
            return ChronoUnit.MINUTES;
        }
        if (timeUnit instanceof Hour) {
            return ChronoUnit.HOURS;
        }
        if (timeUnit instanceof Day) {
            return ChronoUnit.DAYS;
        }
        if (timeUnit instanceof Week) {
            return ChronoUnit.WEEKS;
        }
        if (timeUnit instanceof Month) {
            return ChronoUnit.MONTHS;
        }
        if (timeUnit instanceof Year) {
            return ChronoUnit.YEARS;
        }
        if (timeUnit instanceof Decade) {
            return ChronoUnit.DECADES;
        }
        if (timeUnit instanceof Century) {
            return ChronoUnit.CENTURIES;
        }
        if (timeUnit instanceof Millennium) {
            return ChronoUnit.MILLENNIA;
        }
        throw new IllegalArgumentException("No corresponding ChronoUnit for given TimeUnit");
    }
}

