/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.EmptyMessage;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Membership;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.ClientGmsImpl;
import org.jgroups.protocols.pbcast.CoordGmsImpl;
import org.jgroups.protocols.pbcast.DeltaView;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.Leaver;
import org.jgroups.protocols.pbcast.MergeData;
import org.jgroups.protocols.pbcast.Merger;
import org.jgroups.protocols.pbcast.ParticipantGmsImpl;
import org.jgroups.protocols.pbcast.ViewHandler;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.MembershipChangePolicy;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AckCollector;
import org.jgroups.util.BoundedList;
import org.jgroups.util.ByteArray;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Digest;
import org.jgroups.util.MergeId;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.NameCache;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

@MBean(description="Group membership protocol")
public class GMS
extends Protocol
implements DiagnosticsHandler.ProbeHandler {
    protected static final String CLIENT = "Client";
    protected static final String COORD = "Coordinator";
    protected static final String PART = "Participant";
    public static final short VIEW_PRESENT = 1;
    public static final short DIGEST_PRESENT = 2;
    public static final short MERGE_VIEW = 4;
    public static final short DELTA_VIEW = 8;
    public static final short READ_ADDRS = 16;
    @Property(description="Join timeout", type=AttributeType.TIME)
    protected long join_timeout = 2000L;
    @Property(description="Number of join attempts before we give up and become a singleton. 0 means 'never give up'")
    protected int max_join_attempts = 10;
    @Property(description="Time (in ms) to wait for another discovery round when all discovery responses were clients. A timeout of 0 means don't wait at all.", type=AttributeType.TIME)
    protected int all_clients_retry_timeout = 100;
    @Property(description="Max time (in ms) to wait for a LEAVE response after a LEAVE req has been sent to the coord", type=AttributeType.TIME)
    protected long leave_timeout = 1000L;
    @Property(description="Number of times a LEAVE request is sent to the coordinator (without receiving a LEAVE response, before giving up and leaving anyway (failure detection will eventually exclude the left member). A value of 0 means wait forever", deprecatedMessage="ignored")
    @Deprecated
    protected int max_leave_attempts = 1;
    @Property(description="Timeout (in ms) to complete merge", type=AttributeType.TIME)
    protected long merge_timeout = 5000L;
    @Property(description="Print local address of this member after connect. Default is true")
    protected boolean print_local_addr = true;
    @Property(description="Print physical address(es) on startup")
    protected boolean print_physical_addrs = true;
    @Property(description="If true, then GMS is allowed to send VIEW messages with delta views, otherwise it always sends full views. See https://issues.redhat.com/browse/JGRP-1354 for details.")
    protected boolean use_delta_views = true;
    @Property(description="Max number of old members to keep in history. Default is 50")
    protected int num_prev_mbrs = 50;
    @Property(description="Number of views to store in history")
    protected int num_prev_views = 10;
    @Property(description="Time in ms to wait for all VIEW acks (0 == wait forever. Default is 2000 msec", type=AttributeType.TIME)
    protected long view_ack_collection_timeout = 2000L;
    @Property(description="Logs failures for collecting all view acks if true")
    protected boolean log_collect_msgs;
    @Property(description="Logs warnings for reception of views less than the current, and for views which don't include self")
    protected boolean log_view_warnings = true;
    @Property(description="When true, left and joined members are printed in addition to the view")
    protected boolean print_view_details = true;
    @ManagedAttribute(description="The members of the current view")
    protected final Membership members = new Membership();
    @ManagedAttribute(description="The number of view installed in this member")
    protected int num_views;
    protected BoundedList<String> prev_views;
    protected GmsImpl impl;
    protected final Lock lock = new ReentrantLock();
    protected final Map<String, GmsImpl> impls = new HashMap<String, GmsImpl>(3);
    protected Merger merger;
    protected final Leaver leaver = new Leaver(this);
    protected final Membership tmp_members = new Membership();
    @ManagedAttribute(description="The set of currently suspected members")
    protected final Membership suspected_mbrs = new Membership();
    protected MembershipChangePolicy membership_change_policy = new DefaultMembershipPolicy();
    protected final List<Address> joining = new ArrayList<Address>(7);
    protected final List<Address> leaving = new ArrayList<Address>(7);
    protected BoundedList<Address> prev_members;
    protected volatile View view;
    protected long ltime;
    protected TimeScheduler timer;
    protected final ViewHandler<GmsImpl.Request> view_handler = new ViewHandler<GmsImpl.Request>(this, this::process, GmsImpl.Request::canBeProcessedTogether);
    protected final AckCollector ack_collector = new AckCollector();
    protected boolean first_view_sent;

    public long getJoinTimeout() {
        return this.join_timeout;
    }

    public GMS setJoinTimeout(long t) {
        this.join_timeout = t;
        return this;
    }

    public long getLeaveTimeout() {
        return this.leave_timeout;
    }

    public GMS setLeaveTimeout(long t) {
        this.leave_timeout = t;
        return this;
    }

    public long getMergeTimeout() {
        return this.merge_timeout;
    }

    public GMS setMergeTimeout(long t) {
        this.merge_timeout = t;
        return this;
    }

    public int getMaxJoinAttempts() {
        return this.max_join_attempts;
    }

    public GMS setMaxJoinAttempts(int t) {
        this.max_join_attempts = t;
        return this;
    }

    public boolean printLocalAddress() {
        return this.print_local_addr;
    }

    public GMS printLocalAddress(boolean p) {
        this.print_local_addr = p;
        return this;
    }

    public boolean printPhysicalAddress() {
        return this.print_physical_addrs;
    }

    public GMS printPhysicalAddress(boolean p) {
        this.print_physical_addrs = p;
        return this;
    }

    public boolean useDeltaViews() {
        return this.use_delta_views;
    }

    public GMS useDeltaViews(boolean b) {
        this.use_delta_views = b;
        return this;
    }

    public long getViewAckCollectionTimeout() {
        return this.view_ack_collection_timeout;
    }

    public GMS setViewAckCollectionTimeout(long v) {
        this.view_ack_collection_timeout = v;
        return this;
    }

    public boolean logCollectMessages() {
        return this.log_collect_msgs;
    }

    public GMS logCollectMessages(boolean b) {
        this.log_collect_msgs = b;
        return this;
    }

    public boolean logViewWarnings() {
        return this.log_view_warnings;
    }

    public GMS logViewWarnings(boolean b) {
        this.log_view_warnings = b;
        return this;
    }

    public boolean printViewDetails() {
        return this.print_view_details;
    }

    public GMS printViewDetails(boolean p) {
        this.print_view_details = p;
        return this;
    }

    public ViewId getViewId() {
        return this.view != null ? this.view.getViewId() : null;
    }

    public View view() {
        return this.view;
    }

    public Tuple<View, Digest> getViewAndDigest() {
        MutableDigest digest = new MutableDigest(this.view.getMembersRaw()).set(this.getDigest());
        return digest.allSet() || digest.set(this.getDigest()).allSet() ? new Tuple<View, Digest>(this.view, digest) : null;
    }

    @ManagedAttribute
    public String getView() {
        return this.view != null ? this.view.toString() : "null";
    }

    @ManagedAttribute(description="impl")
    public String getImplementation() {
        return this.impl == null ? "null" : this.impl.getClass().getSimpleName();
    }

    @ManagedAttribute(description="Whether or not the current instance is the coordinator")
    public boolean isCoord() {
        return this.impl instanceof CoordGmsImpl;
    }

    @ManagedAttribute(description="If true, the current member is in the process of leaving")
    public boolean isLeaving() {
        return this.leaver.leaving.get();
    }

    public MembershipChangePolicy getMembershipChangePolicy() {
        return this.membership_change_policy;
    }

    public GMS setMembershipChangePolicy(MembershipChangePolicy membership_change_policy) {
        if (membership_change_policy != null) {
            this.membership_change_policy = membership_change_policy;
        }
        return this;
    }

    @ManagedAttribute(description="Stringified version of merge_id")
    public String getMergeId() {
        return this.merger.getMergeIdAsString();
    }

    @ManagedAttribute(description="Is a merge currently running")
    public boolean isMergeInProgress() {
        return this.merger.isMergeInProgress();
    }

    public Merger getMerger() {
        return this.merger;
    }

    @Property(description="The fully qualified name of a class implementing MembershipChangePolicy.")
    public GMS setMembershipChangePolicy(String classname) {
        try {
            this.membership_change_policy = (MembershipChangePolicy)Util.loadClass(classname, this.getClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return this;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("membership_change_policy could not be created", e);
        }
    }

    @ManagedOperation(description="Prints the last (max 20) MergeIds")
    public String printMergeIdHistory() {
        return this.merger.getMergeIdHistory();
    }

    @ManagedOperation
    public String printPreviousMembers() {
        return this.prev_members == null ? "" : this.prev_members.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    @ManagedAttribute(type=AttributeType.SCALAR)
    public int getViewHandlerSize() {
        return this.view_handler.size();
    }

    @ManagedAttribute
    public boolean isViewHandlerSuspended() {
        return this.view_handler.suspended();
    }

    @ManagedOperation
    public String dumpViewHandlerQueue() {
        return this.view_handler.dumpQueue();
    }

    @ManagedOperation
    public String dumpViewHandlerHistory() {
        return this.view_handler.dumpHistory();
    }

    @ManagedOperation
    public void suspendViewHandler() {
        this.view_handler.suspend();
    }

    @ManagedOperation
    public void resumeViewHandler() {
        this.view_handler.resume();
    }

    public ViewHandler<GmsImpl.Request> getViewHandler() {
        return this.view_handler;
    }

    @ManagedOperation
    public String printPreviousViews() {
        return this.prev_views.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }

    @ManagedOperation
    public void suspect(String suspected_member) {
        if (suspected_member == null) {
            return;
        }
        Map<Address, String> contents = NameCache.getContents();
        for (Map.Entry<Address, String> entry : contents.entrySet()) {
            Address suspect;
            String logical_name = entry.getValue();
            if (!Objects.equals(logical_name, suspected_member) || (suspect = entry.getKey()) == null) continue;
            this.up(new Event(9, Collections.singletonList(suspect)));
        }
    }

    public MergeId _getMergeId() {
        return this.impl instanceof CoordGmsImpl ? ((CoordGmsImpl)this.impl).getMergeId() : null;
    }

    public GMS setLogCollectMessages(boolean flag) {
        this.log_collect_msgs = flag;
        return this;
    }

    public boolean getLogCollectMessages() {
        return this.log_collect_msgs;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_views = 0;
        this.prev_views.clear();
    }

    @Override
    public List<Integer> requiredDownServices() {
        return Arrays.asList(39, 41, 12, 11);
    }

    @Override
    public List<Integer> providedDownServices() {
        return Collections.singletonList(100);
    }

    public void setImpl(GmsImpl new_impl) {
        this.lock.lock();
        try {
            if (this.impl == new_impl) {
                return;
            }
            this.impl = new_impl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public GmsImpl getImpl() {
        return this.impl;
    }

    @Override
    public void init() throws Exception {
        this.merger = new Merger(this);
        if (this.view_ack_collection_timeout <= 0L) {
            throw new IllegalArgumentException("view_ack_collection_timeout has to be greater than 0");
        }
        if (this.merge_timeout <= 0L) {
            throw new IllegalArgumentException("merge_timeout has to be greater than 0");
        }
        this.prev_members = new BoundedList(this.num_prev_mbrs);
        this.prev_views = new BoundedList(this.num_prev_views);
        TP transport = this.getTransport();
        if (this.impl != null) {
            this.impl.init();
        }
        transport.registerProbeHandler(this);
    }

    @Override
    public void start() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        this.leaver.reset();
        this.initState();
        if (this.impl != null) {
            this.impl.start();
        }
    }

    @Override
    public void stop() {
        if (this.impl != null) {
            this.impl.stop();
        }
        this.leaver.reset();
        if (this.prev_members != null) {
            this.prev_members.clear();
        }
        this.view_handler.processing(false);
    }

    public void becomeCoordinator() {
        CoordGmsImpl tmp = (CoordGmsImpl)this.impls.get(COORD);
        if (tmp == null) {
            tmp = new CoordGmsImpl(this);
            this.impls.put(COORD, tmp);
        }
        try {
            this.first_view_sent = false;
            tmp.init();
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("ExceptionSwitchingToCoordinatorRole"), e);
        }
        this.setImpl(tmp);
    }

    public void becomeParticipant() {
        ParticipantGmsImpl tmp = (ParticipantGmsImpl)this.impls.get(PART);
        if (tmp == null) {
            tmp = new ParticipantGmsImpl(this);
            this.impls.put(PART, tmp);
        }
        try {
            tmp.init();
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("ExceptionSwitchingToParticipant"), e);
        }
        this.setImpl(tmp);
    }

    public void becomeClient() {
        ClientGmsImpl tmp = (ClientGmsImpl)this.impls.get(CLIENT);
        if (tmp == null) {
            tmp = new ClientGmsImpl(this);
            this.impls.put(CLIENT, tmp);
        }
        try {
            tmp.init();
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("ExceptionSwitchingToClientRole"), e);
        }
        this.setImpl(tmp);
    }

    boolean haveCoordinatorRole() {
        return this.impl instanceof CoordGmsImpl;
    }

    @ManagedOperation(description="Fetches digests from all members and installs them, unblocking blocked members")
    public void fixDigests() {
        if (this.impl instanceof CoordGmsImpl) {
            ((CoordGmsImpl)this.impl).fixDigests();
        }
    }

    @ManagedOperation(description="Forces cancellation of current merge task")
    public void cancelMerge() {
        this.merger.forceCancelMerge();
    }

    @ManagedAttribute(description="Is the merge task running")
    public boolean isMergeTaskRunning() {
        return this.merger.isMergeTaskRunning();
    }

    @ManagedAttribute(description="Is the merge killer task running")
    public boolean isMergeKillerRunning() {
        return this.merger.isMergeKillerTaskRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View getNextView(Collection<Address> joiners, Collection<Address> leavers, Collection<Address> suspected_mbrs) {
        this.lock.lock();
        try {
            long vid;
            ViewId view_id;
            ViewId viewId = view_id = this.view != null ? this.view.getViewId() : null;
            if (view_id == null) {
                this.log.error(Util.getMessage("ViewidIsNull"));
                View view = null;
                return view;
            }
            this.ltime = vid = Math.max(view_id.getId(), this.ltime) + 1L;
            List<Address> mbrs = this.computeNewMembership(this.tmp_members.getMembers(), joiners, leavers, suspected_mbrs);
            Address new_coord = !mbrs.isEmpty() ? mbrs.get(0) : this.local_addr;
            View v = new View(new_coord, vid, mbrs);
            this.tmp_members.set(mbrs);
            if (joiners != null) {
                joiners.stream().filter(tmp_mbr -> !this.joining.contains(tmp_mbr)).forEach(this.joining::add);
            }
            if (leavers != null) {
                leavers.stream().filter(addr -> !this.leaving.contains(addr)).forEach(this.leaving::add);
            }
            if (suspected_mbrs != null) {
                suspected_mbrs.stream().filter(addr -> !this.leaving.contains(addr)).forEach(this.leaving::add);
            }
            View view = v;
            return view;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected List<Address> computeNewMembership(List<Address> current_members, Collection<Address> joiners, Collection<Address> leavers, Collection<Address> suspects) {
        ArrayList<Address> joiners_copy = joiners == null ? Collections.emptyList() : new ArrayList<Address>(joiners);
        ArrayList<Address> leavers_copy = leavers == null ? Collections.emptyList() : new ArrayList<Address>(leavers);
        ArrayList<Address> suspects_copy = suspects == null ? Collections.emptyList() : new ArrayList<Address>(suspects);
        try {
            List<Address> retval = this.membership_change_policy.getNewMembership(current_members, joiners_copy, leavers_copy, suspects_copy);
            if (retval == null) {
                throw new IllegalStateException("null membership list");
            }
            return retval;
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("MembershipChangePolicy"), this.membership_change_policy.getClass().getSimpleName(), t);
            try {
                return new DefaultMembershipPolicy().getNewMembership(current_members, joiners_copy, leavers_copy, suspects_copy);
            }
            catch (Throwable t2) {
                this.log.error(Util.getMessage("DefaultMembershipChangePolicyFailed"), t2);
                return null;
            }
        }
    }

    protected List<Address> computeNewMembership(Collection<Collection<Address>> subviews) {
        try {
            List<Address> retval = this.membership_change_policy.getNewMembership(subviews);
            if (retval == null) {
                throw new IllegalStateException("null membership list");
            }
            return retval;
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("MembershipChangePolicy"), this.membership_change_policy.getClass().getSimpleName(), t);
            try {
                return new DefaultMembershipPolicy().getNewMembership(subviews);
            }
            catch (Throwable t2) {
                this.log.error(Util.getMessage("DefaultMembershipChangePolicyFailed"), t2);
                return null;
            }
        }
    }

    public void castViewChangeAndSendJoinRsps(View new_view, Digest digest, Collection<Address> expected_acks, Collection<Address> joiners, JoinRsp jr) {
        block7: {
            this.up_prot.up(new Event(15, new_view));
            this.down_prot.down(new Event(15, new_view));
            View full_view = new_view;
            if (this.use_delta_views && this.view != null && !(new_view instanceof MergeView)) {
                if (!this.first_view_sent) {
                    this.first_view_sent = true;
                } else {
                    new_view = GMS.createDeltaView(this.view, new_view);
                }
            }
            Message view_change_msg = new BytesMessage().putHeader(this.id, new GmsHeader(5)).setArray(GMS.marshal(new_view, digest)).setFlag(Message.TransientFlag.DONT_LOOPBACK, Message.TransientFlag.DONT_BLOCK).setFlag(Message.Flag.NO_RELAY, Message.Flag.NO_FC);
            if (new_view instanceof MergeView) {
                view_change_msg.setFlag(Message.Flag.NO_TOTAL_ORDER);
            }
            this.ack_collector.reset(expected_acks, this.local_addr).suspect(this.suspected_mbrs.getMembers());
            long start = System.currentTimeMillis();
            this.impl.handleViewChange(full_view, digest);
            this.log.trace("%s: mcasting view %s", this.local_addr, new_view);
            this.down_prot.down(view_change_msg);
            this.sendJoinResponses(jr, joiners);
            try {
                if (this.ack_collector.size() > 0) {
                    this.ack_collector.waitForAllAcks(this.view_ack_collection_timeout);
                    this.log.trace("%s: got all ACKs (%d) for view %s in %d ms", this.local_addr, this.ack_collector.expectedAcks(), new_view.getViewId(), System.currentTimeMillis() - start);
                }
            }
            catch (TimeoutException e) {
                if (!this.log_collect_msgs) break block7;
                this.log.warn("%s: failed to collect all ACKs (expected=%d) for view %s after %d ms, missing %d ACKs from %s", this.local_addr, this.ack_collector.expectedAcks(), new_view.getViewId(), System.currentTimeMillis() - start, this.ack_collector.size(), this.ack_collector.printMissing());
            }
        }
    }

    protected void sendJoinResponses(JoinRsp jr, Collection<Address> joiners) {
        if (jr == null || joiners == null || joiners.isEmpty()) {
            return;
        }
        ByteArray marshalled_jr = GMS.marshal(jr);
        for (Address joiner : joiners) {
            this.log.trace("%s: sending JOIN-RSP to %s: view=%s (%d mbrs)", this.local_addr, joiner, jr.getView(), jr.getView().size());
            this.sendJoinResponse(marshalled_jr, joiner);
        }
    }

    public void sendJoinResponse(JoinRsp rsp, Address dest) {
        Message m = new BytesMessage(dest).putHeader(this.id, new GmsHeader(2)).setFlag(Message.TransientFlag.DONT_BLOCK).setFlag(Message.Flag.OOB).setArray(GMS.marshal(rsp));
        ((Protocol)this.getDownProtocol()).down(m);
    }

    protected void sendJoinResponse(ByteArray marshalled_rsp, Address dest) {
        Message m = new BytesMessage(dest, marshalled_rsp).setFlag(Message.TransientFlag.DONT_BLOCK).putHeader(this.id, new GmsHeader(2));
        ((Protocol)this.getDownProtocol()).down(m);
    }

    public void installView(View new_view) {
        this.installView(new_view, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installView(View new_view, Digest digest) {
        boolean am_i_coord;
        Event view_event;
        ViewId vid = new_view.getViewId();
        List<Address> mbrs = new_view.getMembers();
        this.lock.lock();
        try {
            this.ltime = Math.max(vid.getId(), this.ltime);
            if (this.view != null && vid.compareToIDs(this.view.getViewId()) <= 0) {
                return;
            }
            if (!mbrs.contains(this.local_addr)) {
                if (this.log_view_warnings) {
                    this.log.warn("%s: not member of view %s; discarding it", this.local_addr, new_view.getViewId());
                }
                return;
            }
            if (digest != null) {
                if (new_view instanceof MergeView) {
                    this.mergeDigest(digest);
                } else {
                    this.setDigest(digest);
                }
            }
            if (this.log.isDebugEnabled()) {
                Address[][] diff = View.diff(this.view, new_view);
                this.log.debug("%s: installing view %s %s", this.local_addr, new_view, this.print_view_details ? View.printDiff(diff) : "");
            }
            boolean was_coord = this.view != null && Objects.equals(this.local_addr, this.view.getCoord());
            this.view = new_view;
            boolean is_coord = Objects.equals(this.local_addr, this.view.getCoord());
            view_event = new Event(6, new_view);
            if (!mbrs.isEmpty()) {
                this.members.set(mbrs);
                this.tmp_members.set(this.members);
                this.joining.removeAll(mbrs);
                this.leaving.retainAll(mbrs);
                this.tmp_members.add(this.joining).remove(this.leaving);
                this.suspected_mbrs.retainAll(mbrs);
                mbrs.stream().filter(addr -> !this.prev_members.contains(addr)).forEach(addr -> this.prev_members.add((Address)addr));
            }
            if (is_coord) {
                if (!was_coord) {
                    this.becomeCoordinator();
                }
            } else if (was_coord || this.impl instanceof ClientGmsImpl) {
                this.becomeParticipant();
            }
            this.ack_collector.retainAll(new_view.getMembers());
            if (this.stats) {
                ++this.num_views;
                this.prev_views.add(Util.utcNow() + ": " + new_view);
            }
            am_i_coord = Objects.equals(this.local_addr, new_view.getCoord());
        }
        finally {
            this.lock.unlock();
        }
        this.down_prot.down(view_event);
        this.up_prot.up(view_event);
        if (new_view instanceof MergeView && !am_i_coord) {
            this.merger.forceCancelMerge();
        }
    }

    protected Address getCoord() {
        this.lock.lock();
        try {
            Address address = this.isCoord() ? this.determineNextCoordinator() : this.determineCoordinator();
            return address;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Address determineCoordinator() {
        return this.members.getFirst();
    }

    protected Address determineNextCoordinator() {
        return this.members.nextCoord();
    }

    protected static View createDeltaView(View current_view, View next_view) {
        ViewId current_view_id = current_view.getViewId();
        ViewId next_view_id = next_view.getViewId();
        Address[][] diff = View.diff(current_view, next_view);
        return new DeltaView(next_view_id, current_view_id, diff[1], diff[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean wouldBeNewCoordinator(Address potential_new_coord) {
        if (potential_new_coord == null) {
            return false;
        }
        this.lock.lock();
        try {
            if (this.members.size() < 2) {
                boolean bl = false;
                return bl;
            }
            Address new_coord = this.members.elementAt(1);
            boolean bl = Objects.equals(new_coord, potential_new_coord);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setDigest(Digest d) {
        this.down_prot.down(new Event(41, d));
    }

    public void mergeDigest(Digest d) {
        this.down_prot.down(new Event(53, d));
    }

    public Digest getDigest() {
        return (Digest)this.down_prot.down(Event.GET_DIGEST_EVT);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 9: {
                Object retval = this.up_prot.up(evt);
                List<Address> suspects = evt.arg() instanceof Address ? Collections.singletonList((Address)evt.arg()) : (List<Address>)evt.arg();
                GmsImpl.Request[] suspect_reqs = new GmsImpl.Request[suspects.size()];
                int index = 0;
                for (Address mbr : suspects) {
                    suspect_reqs[index++] = new GmsImpl.Request(4, mbr);
                }
                this.suspected_mbrs.add(suspects);
                this.ack_collector.suspect(this.suspected_mbrs.getMembers());
                this.view_handler.add((GmsImpl.Request[])suspect_reqs);
                return retval;
            }
            case 51: {
                Address tmp = (Address)evt.getArg();
                this.suspected_mbrs.remove(tmp);
                this.impl.unsuspect((Address)evt.getArg());
                return null;
            }
            case 14: {
                this.view_handler.add(new GmsImpl.Request(5, null, (Map)evt.getArg()));
                return null;
            }
            case 100: {
                return this.merger.isMergeInProgress();
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        GmsHeader hdr = (GmsHeader)msg.getHeader(this.id);
        if (hdr == null) {
            return this.up_prot.up(msg);
        }
        return this.handle(hdr, msg);
    }

    @Override
    public void up(MessageBatch batch) {
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            GmsHeader hdr = (GmsHeader)msg.getHeader(this.id);
            if (hdr == null) continue;
            it.remove();
            this.handle(hdr, msg);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    @Override
    public Object down(Event evt) {
        int type = evt.getType();
        switch (type) {
            case 2: 
            case 80: {
                boolean state_transfer;
                boolean bl = state_transfer = type == 80;
                if (this.print_local_addr) {
                    PhysicalAddress physical_addr = this.print_physical_addrs ? (PhysicalAddress)this.down(new Event(87, this.local_addr)) : null;
                    System.out.println("\n-------------------------------------------------------------------\nGMS: address=" + this.local_addr + ", cluster=" + evt.getArg() + (String)(physical_addr != null ? ", physical address=" + physical_addr.printIpAddress() : "") + "\n-------------------------------------------------------------------");
                } else if (this.log.isDebugEnabled()) {
                    PhysicalAddress physical_addr = this.print_physical_addrs ? (PhysicalAddress)this.down(new Event(87, this.local_addr)) : null;
                    this.log.debug("address=" + this.local_addr + ", cluster=" + evt.getArg() + (String)(physical_addr != null ? ", physical address=" + physical_addr.printIpAddress() : ""));
                }
                this.down_prot.down(evt);
                if (this.local_addr == null) {
                    throw new IllegalStateException("local_addr is null");
                }
                if (state_transfer) {
                    this.impl.joinWithStateTransfer(this.local_addr);
                } else {
                    this.impl.join(this.local_addr);
                }
                return null;
            }
            case 4: {
                this.impl.leave();
                return this.down_prot.down(evt);
            }
            case 108: {
                Address coord;
                Address address = coord = this.view != null ? this.view.getCreator() : null;
                if (coord != null) {
                    ViewId view_id = this.view != null ? this.view.getViewId() : null;
                    Message msg = new BytesMessage(coord).putHeader(this.id, new GmsHeader(16)).setArray(GMS.marshal(view_id)).setFlag(Message.TransientFlag.DONT_BLOCK).setFlag(Message.Flag.OOB, Message.Flag.NO_FC);
                    this.down_prot.down(msg);
                }
                return null;
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Map<String, String> handleProbe(String ... keys) {
        for (String key : keys) {
            if (!key.equals("fix-digests")) continue;
            this.fixDigests();
        }
        return null;
    }

    @Override
    public String[] supportedKeys() {
        return new String[]{"fix-digests"};
    }

    protected Object handle(GmsHeader hdr, Message msg) {
        switch (hdr.type) {
            case 1: {
                this.view_handler.add(new GmsImpl.Request(1, hdr.mbr, null));
                break;
            }
            case 11: {
                this.view_handler.add(new GmsImpl.Request(6, hdr.mbr, null));
                break;
            }
            case 2: {
                JoinRsp join_rsp = this.readJoinRsp(msg.getArray(), msg.getOffset(), msg.getLength());
                if (join_rsp == null) break;
                this.impl.handleJoinResponse(join_rsp);
                break;
            }
            case 3: {
                if (hdr.mbr == null) break;
                this.view_handler.add(new GmsImpl.Request(2, hdr.mbr));
                break;
            }
            case 4: {
                this.impl.handleLeaveResponse(msg.getSrc());
                break;
            }
            case 5: {
                Address coord;
                View new_view;
                Tuple<View, Digest> tuple = this.readViewAndDigest(msg.getArray(), msg.getOffset(), msg.getLength());
                View view = new_view = tuple != null ? tuple.getVal1() : null;
                if (new_view == null) {
                    return null;
                }
                ViewId viewId = this.getViewId();
                if (viewId != null && new_view.getViewId().compareToIDs(viewId) <= 0) {
                    return null;
                }
                if (new_view instanceof DeltaView) {
                    try {
                        new_view = this.createViewFromDeltaView(this.view, (DeltaView)new_view);
                    }
                    catch (Throwable t) {
                        if (this.view != null) {
                            this.log.trace("%s: failed to create view from delta-view; dropping view: %s", this.local_addr, t.toString());
                        }
                        this.log.trace("%s: sending request for full view to %s", this.local_addr, msg.getSrc());
                        Message full_view_req = new EmptyMessage(msg.getSrc()).putHeader(this.id, new GmsHeader(16)).setFlag(Message.TransientFlag.DONT_BLOCK).setFlag(Message.Flag.OOB, Message.Flag.NO_FC);
                        this.down_prot.down(full_view_req);
                        return null;
                    }
                }
                if (!new_view.containsMember(coord = msg.getSrc())) {
                    this.sendViewAck(coord);
                    this.impl.handleViewChange(new_view, tuple.getVal2());
                    break;
                }
                this.impl.handleViewChange(new_view, tuple.getVal2());
                this.sendViewAck(coord);
                break;
            }
            case 10: {
                Address sender = msg.getSrc();
                this.ack_collector.ack(sender);
                return null;
            }
            case 6: {
                Collection<? extends Address> mbrs = this.readMembers(msg.getArray(), msg.getOffset(), msg.getLength());
                if (mbrs == null) break;
                this.impl.handleMergeRequest(msg.getSrc(), hdr.merge_id, mbrs);
                break;
            }
            case 7: {
                Tuple<View, Digest> tuple = this.readViewAndDigest(msg.getArray(), msg.getOffset(), msg.getLength());
                if (tuple == null) {
                    return null;
                }
                MergeData merge_data = new MergeData(msg.getSrc(), tuple.getVal1(), tuple.getVal2(), hdr.merge_rejected);
                this.log.trace("%s: got merge response from %s, merge_id=%s, merge data is %s", this.local_addr, msg.getSrc(), hdr.merge_id, merge_data);
                this.impl.handleMergeResponse(merge_data, hdr.merge_id);
                break;
            }
            case 8: {
                Tuple<View, Digest> tuple = this.readViewAndDigest(msg.getArray(), msg.getOffset(), msg.getLength());
                if (tuple == null) break;
                this.impl.handleMergeView(new MergeData(msg.getSrc(), tuple.getVal1(), tuple.getVal2()), hdr.merge_id);
                break;
            }
            case 15: {
                Tuple<View, Digest> tuple = this.readViewAndDigest(msg.getArray(), msg.getOffset(), msg.getLength());
                if (tuple == null) {
                    return null;
                }
                Digest tmp = tuple.getVal2();
                this.down_prot.down(new Event(53, tmp));
                break;
            }
            case 9: {
                this.impl.handleMergeCancelled(hdr.merge_id);
                break;
            }
            case 13: {
                if (!this.members.contains(msg.getSrc())) break;
                if (hdr.merge_id != null && !this.merger.matchMergeId(hdr.merge_id) && !this.merger.setMergeId(null, hdr.merge_id)) {
                    return null;
                }
                Digest digest = (Digest)this.down_prot.down(new Event(39, this.local_addr));
                if (digest == null) break;
                Message get_digest_rsp = new BytesMessage(msg.getSrc()).setFlag(Message.TransientFlag.DONT_BLOCK).setFlag(Message.Flag.OOB, Message.Flag.NO_FC).putHeader(this.id, new GmsHeader(14)).setArray(GMS.marshal(null, digest));
                this.down_prot.down(get_digest_rsp);
                break;
            }
            case 14: {
                Tuple<View, Digest> tuple = this.readViewAndDigest(msg.getArray(), msg.getOffset(), msg.getLength());
                if (tuple == null) {
                    return null;
                }
                Digest digest_rsp = tuple.getVal2();
                this.impl.handleDigestResponse(msg.getSrc(), digest_rsp);
                break;
            }
            case 16: {
                ViewId view_id = this.readViewId(msg.getArray(), msg.getOffset(), msg.getLength());
                if (view_id != null) {
                    ViewId my_view_id;
                    ViewId viewId = my_view_id = this.view != null ? this.view.getViewId() : null;
                    if (my_view_id != null && my_view_id.compareToIDs(view_id) <= 0) {
                        return null;
                    }
                }
                this.log.trace("%s: received request for full view from %s, sending view %s", this.local_addr, msg.getSrc(), this.view);
                Message view_msg = new BytesMessage(msg.getSrc()).putHeader(this.id, new GmsHeader(5)).setArray(GMS.marshal(this.view, null)).setFlag(Message.TransientFlag.DONT_BLOCK).setFlag(Message.Flag.OOB, Message.Flag.NO_FC);
                this.down_prot.down(view_msg);
                break;
            }
            default: {
                this.log.error(Util.getMessage("GmsHeaderWithType"), hdr.type);
            }
        }
        return null;
    }

    protected void initState() {
        this.becomeClient();
        this.view = null;
        this.first_view_sent = false;
    }

    protected void sendViewAck(Address dest) {
        Message view_ack = new EmptyMessage(dest).setFlag(Message.TransientFlag.DONT_BLOCK).setFlag(Message.Flag.OOB, Message.Flag.NO_FC).putHeader(this.id, new GmsHeader(10));
        this.down_prot.down(view_ack);
    }

    protected View createViewFromDeltaView(View current_view, DeltaView delta_view) {
        if (current_view == null || delta_view == null) {
            throw new IllegalStateException("current view (" + current_view + ") or delta view (" + delta_view + ") is null");
        }
        ViewId current_view_id = current_view.getViewId();
        ViewId delta_ref_view_id = delta_view.getRefViewId();
        ViewId delta_view_id = delta_view.getViewId();
        if (!current_view_id.equals(delta_ref_view_id)) {
            throw new IllegalStateException("the view-id of the delta view (" + delta_ref_view_id + ") doesn't match the current view-id (" + current_view_id + "); discarding delta view " + delta_view);
        }
        List<Address> current_mbrs = current_view.getMembers();
        List<Address> left_mbrs = Arrays.asList(delta_view.getLeftMembers());
        List<Address> new_mbrs = Arrays.asList(delta_view.getNewMembers());
        List<Address> new_mbrship = this.computeNewMembership(current_mbrs, new_mbrs, left_mbrs, Collections.emptyList());
        return new View(delta_view_id, new_mbrship);
    }

    protected static boolean writeAddresses(View view, Digest digest) {
        return digest == null || view == null || !Arrays.equals(view.getMembersRaw(), digest.getMembersRaw());
    }

    protected static short determineFlags(View view, Digest digest) {
        short retval = 0;
        if (view != null) {
            retval = (short)(retval | 1);
            if (view instanceof MergeView) {
                retval = (short)(retval | 4);
            } else if (view instanceof DeltaView) {
                retval = (short)(retval | 8);
            }
        }
        if (digest != null) {
            retval = (short)(retval | 2);
        }
        if (GMS.writeAddresses(view, digest)) {
            retval = (short)(retval | 0x10);
        }
        return retval;
    }

    protected static ByteArray marshal(View view, Digest digest) {
        try {
            int expected_size = 2;
            if (view != null) {
                expected_size += view.serializedSize();
            }
            boolean write_addrs = GMS.writeAddresses(view, digest);
            if (digest != null) {
                expected_size = (int)digest.serializedSize(write_addrs);
            }
            ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(expected_size + 10);
            out.writeShort(GMS.determineFlags(view, digest));
            if (view != null) {
                view.writeTo(out);
            }
            if (digest != null) {
                digest.writeTo(out, write_addrs);
            }
            return out.getBuffer();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static ByteArray marshal(JoinRsp join_rsp) {
        try {
            return Util.streamableToBuffer(join_rsp);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static ByteArray marshal(Collection<? extends Address> mbrs) {
        try {
            ByteArrayDataOutputStream out = new ByteArrayDataOutputStream((int)Util.size(mbrs));
            Util.writeAddresses(mbrs, (DataOutput)out);
            return out.getBuffer();
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected static ByteArray marshal(ViewId view_id) {
        try {
            ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(Util.size(view_id));
            Util.writeViewId(view_id, out);
            return out.getBuffer();
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected JoinRsp readJoinRsp(byte[] buffer, int offset, int length) {
        try {
            return buffer != null ? Util.streamableFromBuffer(JoinRsp::new, buffer, offset, length) : null;
        }
        catch (Exception ex) {
            this.log.error("%s: failed reading JoinRsp from message: %s", this.local_addr, ex);
            return null;
        }
    }

    protected Collection<? extends Address> readMembers(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            return null;
        }
        try {
            ByteArrayDataInputStream in = new ByteArrayDataInputStream(buffer, offset, length);
            return Util.readAddresses(in, ArrayList::new);
        }
        catch (Exception ex) {
            this.log.error("%s: failed reading members from message: %s", this.local_addr, ex);
            return null;
        }
    }

    protected Tuple<View, Digest> readViewAndDigest(byte[] buffer, int offset, int length) {
        try {
            return GMS._readViewAndDigest(buffer, offset, length);
        }
        catch (Exception ex) {
            this.log.error("%s: failed reading view and digest from message: %s", this.local_addr, ex);
            return null;
        }
    }

    public static Tuple<View, Digest> _readViewAndDigest(byte[] buffer, int offset, int length) throws Exception {
        if (buffer == null) {
            return null;
        }
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(buffer, offset, length);
        MergeView tmp_view = null;
        Digest digest = null;
        short flags = in.readShort();
        if ((flags & 1) == 1) {
            tmp_view = (flags & 4) == 4 ? new MergeView() : ((flags & 8) == 8 ? new DeltaView() : new View());
            ((View)tmp_view).readFrom(in);
        }
        if ((flags & 2) == 2) {
            if ((flags & 0x10) == 16) {
                digest = new Digest();
                digest.readFrom(in);
            } else {
                digest = new Digest(tmp_view.getMembersRaw());
                digest.readFrom(in, false);
            }
        }
        return new Tuple<MergeView, Object>(tmp_view, digest);
    }

    protected ViewId readViewId(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            return null;
        }
        try {
            ByteArrayDataInputStream in = new ByteArrayDataInputStream(buffer, offset, length);
            return Util.readViewId(in);
        }
        catch (Exception ex) {
            this.log.error("%s: failed reading ViewId from message: %s", this.local_addr, ex);
            return null;
        }
    }

    protected void process(Collection<GmsImpl.Request> requests) {
        if (requests.isEmpty()) {
            return;
        }
        GmsImpl.Request firstReq = requests.iterator().next();
        switch (firstReq.type) {
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                this.impl.handleMembershipChange(requests);
                break;
            }
            case 3: {
                this.impl.handleCoordLeave();
                break;
            }
            case 5: {
                this.impl.merge(firstReq.views);
                break;
            }
            default: {
                this.log.error("request type " + firstReq.type + " is unknown; discarded");
            }
        }
    }

    public static class GmsHeader
    extends Header {
        public static final byte JOIN_REQ = 1;
        public static final byte JOIN_RSP = 2;
        public static final byte LEAVE_REQ = 3;
        public static final byte LEAVE_RSP = 4;
        public static final byte VIEW = 5;
        public static final byte MERGE_REQ = 6;
        public static final byte MERGE_RSP = 7;
        public static final byte INSTALL_MERGE_VIEW = 8;
        public static final byte CANCEL_MERGE = 9;
        public static final byte VIEW_ACK = 10;
        public static final byte JOIN_REQ_WITH_STATE_TRANSFER = 11;
        public static final byte GET_DIGEST_REQ = 13;
        public static final byte GET_DIGEST_RSP = 14;
        public static final byte INSTALL_DIGEST = 15;
        public static final byte GET_CURRENT_VIEW = 16;
        public static final short MERGE_ID_PRESENT = 4;
        public static final short MERGE_REJECTED = 16;
        protected byte type;
        protected Address mbr;
        protected MergeId merge_id;
        protected boolean merge_rejected = false;

        public GmsHeader() {
        }

        public GmsHeader(byte type) {
            this.type = type;
        }

        public GmsHeader(byte type, Address mbr) {
            this.type = type;
            this.mbr = mbr;
        }

        @Override
        public short getMagicId() {
            return 55;
        }

        public byte getType() {
            return this.type;
        }

        public GmsHeader mbr(Address mbr) {
            this.mbr = mbr;
            return this;
        }

        public GmsHeader mergeId(MergeId merge_id) {
            this.merge_id = merge_id;
            return this;
        }

        public GmsHeader mergeRejected(boolean flag) {
            this.merge_rejected = flag;
            return this;
        }

        public Address getMember() {
            return this.mbr;
        }

        public MergeId getMergeId() {
            return this.merge_id;
        }

        public GmsHeader setMergeId(MergeId merge_id) {
            this.merge_id = merge_id;
            return this;
        }

        public boolean isMergeRejected() {
            return this.merge_rejected;
        }

        public GmsHeader setMergeRejected(boolean merge_rejected) {
            this.merge_rejected = merge_rejected;
            return this;
        }

        @Override
        public Supplier<? extends Header> create() {
            return GmsHeader::new;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeByte(this.type);
            short flags = this.determineFlags();
            out.writeShort(flags);
            Util.writeAddress(this.mbr, out);
            if (this.merge_id != null) {
                this.merge_id.writeTo(out);
            }
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            short flags = in.readShort();
            this.mbr = Util.readAddress(in);
            if ((flags & 4) == 4) {
                this.merge_id = new MergeId();
                this.merge_id.readFrom(in);
            }
            this.merge_rejected = (flags & 0x10) == 16;
        }

        @Override
        public int serializedSize() {
            int retval = 3 + Util.size(this.mbr);
            if (this.merge_id != null) {
                retval += this.merge_id.size();
            }
            return retval;
        }

        protected short determineFlags() {
            short retval = 0;
            if (this.merge_id != null) {
                retval = (short)(retval | 4);
            }
            if (this.merge_rejected) {
                retval = (short)(retval | 0x10);
            }
            return retval;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("GmsHeader[").append(GmsHeader.type2String(this.type) + "]");
            switch (this.type) {
                case 1: 
                case 3: 
                case 13: {
                    sb.append(": mbr=" + this.mbr);
                    break;
                }
                case 6: {
                    sb.append(": merge_id=" + this.merge_id);
                    break;
                }
                case 7: {
                    sb.append("merge_id=" + this.merge_id);
                    if (!this.merge_rejected) break;
                    sb.append(", merge_rejected=" + this.merge_rejected);
                    break;
                }
                case 9: {
                    sb.append(", merge_id=" + this.merge_id);
                }
            }
            return sb.toString();
        }

        public static String type2String(int type) {
            switch (type) {
                case 1: {
                    return "JOIN_REQ";
                }
                case 2: {
                    return "JOIN_RSP";
                }
                case 3: {
                    return "LEAVE_REQ";
                }
                case 4: {
                    return "LEAVE_RSP";
                }
                case 5: {
                    return "VIEW";
                }
                case 6: {
                    return "MERGE_REQ";
                }
                case 7: {
                    return "MERGE_RSP";
                }
                case 8: {
                    return "INSTALL_MERGE_VIEW";
                }
                case 9: {
                    return "CANCEL_MERGE";
                }
                case 10: {
                    return "VIEW_ACK";
                }
                case 11: {
                    return "JOIN_REQ_WITH_STATE_TRANSFER";
                }
                case 13: {
                    return "GET_DIGEST_REQ";
                }
                case 14: {
                    return "GET_DIGEST_RSP";
                }
                case 15: {
                    return "INSTALL_DIGEST";
                }
                case 16: {
                    return "GET_CURRENT_VIEW";
                }
            }
            return "<unknown>";
        }
    }

    public static class DefaultMembershipPolicy
    implements MembershipChangePolicy {
        @Override
        public List<Address> getNewMembership(Collection<Address> current_members, Collection<Address> joiners, Collection<Address> leavers, Collection<Address> suspects) {
            Membership mbrs = new Membership(current_members).remove(leavers).remove(suspects).add(joiners);
            return mbrs.getMembers();
        }

        public static List<Address> getNewMembershipOld(Collection<Collection<Address>> subviews) {
            Membership mbrs = new Membership();
            subviews.forEach(mbrs::add);
            return mbrs.sort().getMembers();
        }

        @Override
        public List<Address> getNewMembership(Collection<Collection<Address>> subviews) {
            Membership coords = new Membership();
            subviews.stream().filter(subview -> !subview.isEmpty()).forEach(subview -> coords.add((Address)subview.iterator().next()));
            coords.sort();
            Membership new_mbrs = new Membership().add(coords.elementAt(0));
            subviews.forEach(new_mbrs::add);
            return new_mbrs.getMembers();
        }
    }
}

