/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.module.servlet;

import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.sound.DefaultManageableSoundCaptchaService;
import com.octo.captcha.service.sound.SoundCaptchaService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class SimpleSoundCaptchaServlet
extends HttpServlet
implements Servlet {
    public static SoundCaptchaService service = new DefaultManageableSoundCaptchaService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setDateHeader("Expires", 0L);
        httpServletResponse.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        httpServletResponse.addHeader("Cache-Control", "post-check=0, pre-check=0");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setContentType("audio/wav");
        AudioInputStream audioInputStream = service.getSoundChallengeForID(httpServletRequest.getSession(true).getId());
        ServletOutputStream out = httpServletResponse.getOutputStream();
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, byteOutputStream);
        out.write(byteOutputStream.toByteArray());
        try {
            out.flush();
        }
        finally {
            out.close();
        }
    }

    public static boolean validateResponse(HttpServletRequest request, String userCaptchaResponse) {
        if (request.getSession(false) == null) {
            return false;
        }
        boolean validated = false;
        try {
            validated = service.validateResponseForID(request.getSession().getId(), (Object)userCaptchaResponse);
        }
        catch (CaptchaServiceException captchaServiceException) {
            // empty catch block
        }
        return validated;
    }
}

