/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.parsing.Attribute;

public class ContentTypeConfiguration
extends ConfigurationElement<ContentTypeConfiguration> {
    public static final AttributeDefinition<MediaType> MEDIA_TYPE = AttributeDefinition.builder((Enum)Attribute.MEDIA_TYPE, null, MediaType.class).immutable().build();
    private final MediaType mediaType;

    ContentTypeConfiguration(Enum<?> element, AttributeSet attributes, MediaType parentType) {
        super(element, attributes, new ConfigurationElement[0]);
        this.mediaType = parentType != null ? parentType : (MediaType)attributes.attribute(MEDIA_TYPE).get();
    }

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ContentTypeConfiguration.class, new AttributeDefinition[]{MEDIA_TYPE});
    }

    public MediaType mediaType() {
        return this.mediaType;
    }

    public boolean isMediaTypeChanged() {
        return this.mediaType != null;
    }

    public boolean isObjectStorage() {
        return MediaType.APPLICATION_OBJECT.match(this.mediaType);
    }
}

