/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.AbstractCSSRuleImpl;
import com.steadystate.css.dom.CSSMediaRuleImpl;
import com.steadystate.css.dom.CSSRuleListImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.MediaListImpl;
import com.steadystate.css.format.CSSFormat;
import com.steadystate.css.format.CSSFormatable;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.util.LangUtils;
import com.steadystate.css.util.ThrowCssExceptionErrorHandler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;
import org.w3c.dom.stylesheets.StyleSheet;

public class CSSStyleSheetImpl
implements CSSStyleSheet,
CSSFormatable,
Serializable {
    private static final long serialVersionUID = -2300541300646796363L;
    private boolean disabled_;
    private Node ownerNode_;
    private StyleSheet parentStyleSheet_;
    private String href_;
    private String title_;
    private MediaList media_;
    private CSSRule ownerRule_;
    private boolean readOnly_;
    private CSSRuleList cssRules_;
    private String baseUri_;

    public void setMedia(MediaList media) {
        this.media_ = media;
    }

    private String getBaseUri() {
        return this.baseUri_;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri_ = baseUri;
    }

    @Override
    public String getType() {
        return "text/css";
    }

    @Override
    public boolean getDisabled() {
        return this.disabled_;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled_ = disabled;
    }

    @Override
    public Node getOwnerNode() {
        return this.ownerNode_;
    }

    @Override
    public StyleSheet getParentStyleSheet() {
        return this.parentStyleSheet_;
    }

    @Override
    public String getHref() {
        return this.href_;
    }

    @Override
    public String getTitle() {
        return this.title_;
    }

    @Override
    public MediaList getMedia() {
        return this.media_;
    }

    @Override
    public CSSRule getOwnerRule() {
        return this.ownerRule_;
    }

    @Override
    public CSSRuleList getCssRules() {
        if (this.cssRules_ == null) {
            this.cssRules_ = new CSSRuleListImpl();
        }
        return this.cssRules_;
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        if (this.readOnly_) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource((Reader)new StringReader(rule));
            CSSOMParser parser = new CSSOMParser();
            parser.setParentStyleSheet(this);
            parser.setErrorHandler(ThrowCssExceptionErrorHandler.INSTANCE);
            CSSRule r = parser.parseRule(is);
            if (r == null) {
                throw new DOMExceptionImpl(12, 0, "Parsing rule '" + rule + "' failed.");
            }
            if (this.getCssRules().getLength() > 0) {
                int msg = -1;
                if (r.getType() == 2) {
                    if (index != 0) {
                        msg = 15;
                    } else if (this.getCssRules().item(0).getType() == 2) {
                        msg = 16;
                    }
                } else if (r.getType() == 3) {
                    if (index <= this.getCssRules().getLength()) {
                        for (int i = 0; i < index; ++i) {
                            short rt = this.getCssRules().item(i).getType();
                            if (rt == 2 || rt == 3) continue;
                            msg = 17;
                            break;
                        }
                    }
                } else if (index <= this.getCssRules().getLength()) {
                    for (int i = index; i < this.getCssRules().getLength(); ++i) {
                        short rt = this.getCssRules().item(i).getType();
                        if (rt != 2 && rt != 3) continue;
                        msg = 20;
                        break;
                    }
                }
                if (msg > -1) {
                    throw new DOMExceptionImpl(3, msg);
                }
            }
            ((CSSRuleListImpl)this.getCssRules()).insert(r, index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DOMExceptionImpl(1, 1, e.getMessage());
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        return index;
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        if (this.readOnly_) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            ((CSSRuleListImpl)this.getCssRules()).delete(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DOMExceptionImpl(1, 1, e.getMessage());
        }
    }

    public boolean isReadOnly() {
        return this.readOnly_;
    }

    public void setReadOnly(boolean b) {
        this.readOnly_ = b;
    }

    public void setOwnerNode(Node ownerNode) {
        this.ownerNode_ = ownerNode;
    }

    public void setParentStyleSheet(StyleSheet parentStyleSheet) {
        this.parentStyleSheet_ = parentStyleSheet;
    }

    public void setHref(String href) {
        this.href_ = href;
    }

    public void setTitle(String title) {
        this.title_ = title;
    }

    public void setMediaText(String mediaText) {
        InputSource source = new InputSource((Reader)new StringReader(mediaText));
        try {
            CSSOMParser parser = new CSSOMParser();
            SACMediaList sml = parser.parseMedia(source);
            this.media_ = new MediaListImpl(sml);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setOwnerRule(CSSRule ownerRule) {
        this.ownerRule_ = ownerRule;
    }

    public void setCssRules(CSSRuleList rules) {
        this.cssRules_ = rules;
    }

    public String getCssText() {
        return this.getCssText(null);
    }

    @Override
    public String getCssText(CSSFormat format) {
        CSSRuleList rules = this.getCssRules();
        if (rules instanceof CSSFormatable) {
            return ((CSSRuleListImpl)rules).getCssText(format);
        }
        return this.getCssRules().toString();
    }

    public String toString() {
        return this.getCssText(null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSStyleSheet)) {
            return false;
        }
        CSSStyleSheet css = (CSSStyleSheet)obj;
        boolean eq = LangUtils.equals(this.getCssRules(), css.getCssRules());
        eq = eq && this.getDisabled() == css.getDisabled();
        eq = eq && LangUtils.equals(this.getHref(), css.getHref());
        eq = eq && LangUtils.equals(this.getMedia(), css.getMedia());
        eq = eq && LangUtils.equals(this.getTitle(), css.getTitle());
        return eq;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.baseUri_);
        hash = LangUtils.hashCode(hash, this.cssRules_);
        hash = LangUtils.hashCode(hash, this.disabled_);
        hash = LangUtils.hashCode(hash, this.href_);
        hash = LangUtils.hashCode(hash, this.media_);
        hash = LangUtils.hashCode(hash, this.ownerNode_);
        hash = LangUtils.hashCode(hash, this.readOnly_);
        hash = LangUtils.hashCode(hash, this.title_);
        return hash;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.baseUri_);
        out.writeObject(this.cssRules_);
        out.writeBoolean(this.disabled_);
        out.writeObject(this.href_);
        out.writeObject(this.media_);
        out.writeBoolean(this.readOnly_);
        out.writeObject(this.title_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.baseUri_ = (String)in.readObject();
        this.cssRules_ = (CSSRuleList)in.readObject();
        if (this.cssRules_ != null) {
            for (int i = 0; i < this.cssRules_.getLength(); ++i) {
                CSSRule cssRule = this.cssRules_.item(i);
                if (!(cssRule instanceof AbstractCSSRuleImpl)) continue;
                ((AbstractCSSRuleImpl)((Object)cssRule)).setParentStyleSheet(this);
            }
        }
        this.disabled_ = in.readBoolean();
        this.href_ = (String)in.readObject();
        this.media_ = (MediaList)in.readObject();
        this.readOnly_ = in.readBoolean();
        this.title_ = (String)in.readObject();
    }

    public void importImports(boolean recursive) throws DOMException {
        for (int i = 0; i < this.getCssRules().getLength(); ++i) {
            CSSRule cssRule = this.getCssRules().item(i);
            if (cssRule.getType() != 3) continue;
            CSSImportRule cssImportRule = (CSSImportRule)cssRule;
            try {
                MediaList mediaList;
                URI importURI = new URI(this.getBaseUri()).resolve(cssImportRule.getHref());
                CSSStyleSheetImpl importedCSS = (CSSStyleSheetImpl)new CSSOMParser().parseStyleSheet(new InputSource(importURI.toString()), null, importURI.toString());
                if (recursive) {
                    importedCSS.importImports(recursive);
                }
                if ((mediaList = cssImportRule.getMedia()).getLength() == 0) {
                    mediaList.appendMedium("all");
                }
                CSSMediaRuleImpl cssMediaRule = new CSSMediaRuleImpl(this, null, mediaList);
                cssMediaRule.setRuleList((CSSRuleListImpl)importedCSS.getCssRules());
                this.deleteRule(i);
                ((CSSRuleListImpl)this.getCssRules()).insert(cssMediaRule, i);
                continue;
            }
            catch (URISyntaxException e) {
                throw new DOMException(12, e.getLocalizedMessage());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

