/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.CachedXHTMLElement;
import io.sf.carte.doc.dom4j.StyleDefinerElement;
import io.sf.carte.doc.dom4j.XHTMLDocument;
import java.util.Iterator;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.w3c.dom.Element;

class HrefAttribute
extends DOMAttribute {
    private static final long serialVersionUID = 3L;

    HrefAttribute(QName qname) {
        super(qname);
    }

    HrefAttribute(QName qname, String value) {
        super(qname, value);
    }

    HrefAttribute(org.dom4j.Element parent, QName qname, String value) {
        super(parent, qname, value);
    }

    public void setValue(String value) {
        Element owner;
        super.setValue(value);
        XHTMLDocument doc = (XHTMLDocument)this.getDocument();
        if (doc != null && (owner = this.getOwnerElement()) != null) {
            if (owner instanceof StyleDefinerElement) {
                StyleDefinerElement element = (StyleDefinerElement)((Object)owner);
                element.resetLinkedSheet();
            } else if ("base".equalsIgnoreCase(owner.getLocalName())) {
                doc.setBaseURL(null);
                if (value != null && value.length() != 0) {
                    doc.setBaseURL(owner, value);
                }
                HrefAttribute.onBaseModify(doc);
            }
            if (owner instanceof CachedXHTMLElement) {
                ((CachedXHTMLElement)((Object)owner)).onStyleModify();
            }
        }
    }

    static void onBaseModify(XHTMLDocument doc) {
        Iterator<StyleDefinerElement> links = doc.linkedStyle.iterator();
        while (links.hasNext()) {
            links.next().resetLinkedSheet();
        }
    }
}

