/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.dom4j.BaseURLElement;
import io.sf.carte.doc.dom4j.HrefAttribute;
import io.sf.carte.doc.dom4j.XHTMLDocument;
import io.sf.carte.doc.dom4j.XHTMLElement;
import org.dom4j.Node;
import org.dom4j.QName;
import org.w3c.dom.Element;

class HeadElement
extends XHTMLElement {
    private static final long serialVersionUID = 3L;

    HeadElement(String name) {
        super(name);
    }

    HeadElement(QName qname) {
        super(qname);
    }

    HeadElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    @Override
    protected void childAdded(Node node) {
        XHTMLDocument doc;
        super.childAdded(node);
        if (node instanceof BaseURLElement) {
            String href;
            XHTMLDocument doc2 = this.getOwnerDocument();
            if (doc2 != null && (href = ((BaseURLElement)node).getAttribute("href").trim()).length() != 0) {
                doc2.setBaseURL((Element)((Object)this), href);
            }
        } else if ("meta".equalsIgnoreCase(node.getName()) && (doc = this.getOwnerDocument()) != null) {
            Element elt = (Element)node;
            String name = elt.getAttribute("http-equiv");
            if (name.length() == 0) {
                name = elt.getAttribute("name");
            }
            doc.onMetaAdded(name, elt.getAttribute("content"));
        }
    }

    @Override
    protected void childRemoved(Node node) {
        XHTMLDocument doc;
        String nName = node.getName();
        if ("meta".equalsIgnoreCase(nName)) {
            Element elt = (Element)node;
            String name = elt.getAttribute("http-equiv");
            if (name.length() == 0) {
                name = elt.getAttribute("name");
            }
            this.getOwnerDocument().onMetaRemoved(name, elt.getAttribute("content"));
        } else if (node instanceof BaseURLElement && (doc = this.getOwnerDocument()) != null) {
            doc.setBaseURL(null);
            HrefAttribute.onBaseModify(doc);
        }
        super.childRemoved(node);
    }
}

