/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom4j;

import io.sf.carte.doc.DirectionalityHelper;
import io.sf.carte.doc.dom4j.StyleAttribute;
import io.sf.carte.doc.dom4j.XHTMLDocument;
import io.sf.carte.doc.dom4j.XHTMLDocumentFactory;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSStyleDeclaration;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.nsac.SimpleSelector;
import io.sf.carte.doc.style.css.om.AbstractSelectorMatcher;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.parser.CSSParser;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.dom4j.Attribute;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.dom4j.tree.DefaultAttribute;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CSSStylableElement
extends DOMElement
implements CSSElement {
    private static final long serialVersionUID = 8L;
    private SelectorMatcher selectorMatcher = null;
    private Map<Condition, CSSStyleDeclaration> overrideStyleSet = null;

    protected CSSStylableElement(String name) {
        super(name);
    }

    protected CSSStylableElement(QName qname) {
        super(qname);
    }

    protected CSSStylableElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    public XHTMLDocument getOwnerDocument() {
        return (XHTMLDocument)super.getDocument();
    }

    public XHTMLDocument getDocument() {
        return (XHTMLDocument)super.getDocument();
    }

    protected XHTMLDocumentFactory getDocumentFactory() {
        return (XHTMLDocumentFactory)super.getDocumentFactory();
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "No modification allowed");
        }
        Attribute attribute = this.attribute(newAttr);
        if (attribute != newAttr) {
            if (newAttr.getOwnerElement() != null) {
                throw new DOMException(10, "Attribute is already in use");
            }
            if (attribute != null) {
                attribute.detach();
                this.add((Attribute)newAttr);
                if (attribute instanceof Attr) {
                    return (Attr)attribute;
                }
            } else {
                this.add((Attribute)newAttr);
            }
        }
        return null;
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return this.setAttributeNode(newAttr);
    }

    protected Attribute attribute(Attr attr) {
        return this.attribute(((DefaultAttribute)attr).getQName());
    }

    public String getBaseURI() {
        URL baseURL = this.getOwnerDocument().getBaseURL();
        if (baseURL != null) {
            return baseURL.toExternalForm();
        }
        return null;
    }

    @Deprecated
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Deprecated
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        if (isId && !"id".equalsIgnoreCase(name)) {
            super.setIdAttribute(name, isId);
        }
    }

    @Deprecated
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        if (isId && !"id".equalsIgnoreCase(localName)) {
            super.setIdAttributeNS(namespaceURI, localName, isId);
        }
    }

    @Deprecated
    public void setIdAttributeNode(Attr idAttr, boolean isId) {
        if (isId && !"id".equalsIgnoreCase(idAttr.getLocalName())) {
            super.setIdAttributeNode(idAttr, isId);
        }
    }

    public abstract String getId();

    public CSSStyleDeclaration getStyle() {
        StyleAttribute styleAttr = (StyleAttribute)((Object)this.getAttributeNode("style"));
        if (styleAttr == null) {
            Iterator it = this.attributeIterator();
            while (it.hasNext()) {
                Attribute dom4jattr = (Attribute)it.next();
                if (!dom4jattr.getQualifiedName().equalsIgnoreCase("style")) continue;
                styleAttr = (StyleAttribute)dom4jattr;
                break;
            }
            if (styleAttr == null) {
                return null;
            }
        }
        return styleAttr.getStyle();
    }

    public boolean hasPresentationalHints() {
        return false;
    }

    public void exportHintsToStyle(CSSStyleDeclaration style) {
    }

    public boolean hasOverrideStyle(Condition pseudoElt) {
        if (this.overrideStyleSet == null) {
            return false;
        }
        return this.overrideStyleSet.containsKey(pseudoElt);
    }

    public CSSStyleDeclaration getOverrideStyle(Condition pseudoElt) {
        CSSStyleDeclaration overrideStyle = null;
        if (this.overrideStyleSet == null) {
            this.overrideStyleSet = new HashMap<Condition, CSSStyleDeclaration>(1);
        } else {
            overrideStyle = this.overrideStyleSet.get(pseudoElt);
        }
        if (overrideStyle == null) {
            overrideStyle = this.getDocumentFactory().createInlineStyle((Node)((Object)this));
            this.overrideStyleSet.put(pseudoElt, overrideStyle);
        }
        return overrideStyle;
    }

    public ComputedCSSStyle getComputedStyle(String pseudoElt) {
        XHTMLDocument doc = this.getOwnerDocument();
        if (doc != null) {
            Condition peCond;
            if (pseudoElt != null) {
                CSSParser parser = new CSSParser();
                peCond = parser.parsePseudoElement(pseudoElt);
            } else {
                peCond = null;
            }
            ComputedCSSStyle styledecl = (ComputedCSSStyle)doc.getStyleSheet().getComputedStyle((CSSElement)this, peCond);
            return styledecl;
        }
        return null;
    }

    public ComputedCSSStyle getComputedStyle() {
        DocumentCSSStyleSheet css = this.getOwnerDocument().getStyleSheet();
        if (css != null) {
            ComputedCSSStyle styledecl = (ComputedCSSStyle)css.getComputedStyle((CSSElement)this, null);
            return styledecl;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getAttributeValue(String attrName) {
        String value = null;
        Attribute attr = this.attribute(attrName);
        if (attr == null) {
            String localName;
            String prefix = "";
            int idx = attrName.indexOf(58);
            if (idx != -1) {
                prefix = attrName.substring(0, idx);
                if (++idx >= attrName.length()) return "";
                localName = attrName.substring(idx);
            } else {
                localName = attrName;
            }
            List list = this.attributeList();
            for (Attribute item : list) {
                String nsuri;
                if (!localName.equalsIgnoreCase(item.getName()) || (nsuri = item.getNamespaceURI()) != null && nsuri.length() != 0 && !"http://www.w3.org/1999/xhtml".equals(nsuri) && !localName.equals(item.getName()) || !Objects.equals(prefix, item.getNamespacePrefix())) continue;
                value = item.getValue();
                break;
            }
        } else {
            value = attr.getValue();
        }
        if (value == null) return "";
        String string = value;
        return string;
    }

    public SelectorMatcher getSelectorMatcher() {
        if (this.selectorMatcher == null) {
            this.selectorMatcher = new DOM4JSelectorMatcher();
        }
        return this.selectorMatcher;
    }

    public boolean matches(String selectorString, String pseudoElement) throws DOMException {
        Condition peCond;
        SelectorList list;
        CSSParser parser = new CSSParser();
        try {
            list = parser.parseSelectors((Reader)new StringReader(selectorString));
        }
        catch (Exception e) {
            throw new DOMException(12, "Unable to parse selector in: " + selectorString);
        }
        if (pseudoElement != null) {
            try {
                peCond = parser.parsePseudoElement(pseudoElement);
            }
            catch (Exception e) {
                throw new DOMException(12, "Unable to parse pseudo-element in: " + pseudoElement);
            }
        } else {
            peCond = null;
        }
        return this.matches(list, peCond);
    }

    public boolean matches(SelectorList selist, Condition pseudoElement) {
        SelectorMatcher matcher = this.getSelectorMatcher();
        matcher.setPseudoElement(pseudoElement);
        return matcher.matches(selist) != -1;
    }

    class DOM4JSelectorMatcher
    extends AbstractSelectorMatcher {
        private static final long serialVersionUID = 1L;

        DOM4JSelectorMatcher() {
            this.setLocalName(CSSStylableElement.this.getName().toLowerCase(Locale.ROOT).intern());
        }

        protected AbstractSelectorMatcher getParentSelectorMatcher() {
            org.dom4j.Element parent = CSSStylableElement.this.getParent();
            if (parent instanceof CSSStylableElement) {
                return (AbstractSelectorMatcher)((CSSStylableElement)parent).getSelectorMatcher();
            }
            return null;
        }

        protected AbstractSelectorMatcher getPreviousSiblingSelectorMatcher() {
            Object sibling;
            org.dom4j.Element parent = CSSStylableElement.this.getParent();
            if (parent == null) {
                return null;
            }
            List elements = parent.elements();
            int sibindex = elements.indexOf((Object)CSSStylableElement.this) - 1;
            if (sibindex != -1 && (sibling = elements.get(sibindex)) instanceof CSSStylableElement) {
                return (AbstractSelectorMatcher)((CSSStylableElement)((Object)sibling)).getSelectorMatcher();
            }
            return null;
        }

        protected int indexOf(SelectorList selectors) {
            org.dom4j.Element parent = CSSStylableElement.this.getParent();
            if (parent == null) {
                return 1;
            }
            NodeList list = CSSStylableElement.this.getParentNode().getChildNodes();
            int sz = list.getLength();
            int idx = 0;
            for (int i = 0; i < sz; ++i) {
                Node node = list.item(i);
                if (node.getNodeType() != 1 || !this.matchSelectors(selectors, (CSSStylableElement)((Object)node))) continue;
                ++idx;
                if (node != CSSStylableElement.this) continue;
                return idx;
            }
            return -1;
        }

        protected int reverseIndexOf(SelectorList selectors) {
            org.dom4j.Element parent = CSSStylableElement.this.getParent();
            if (parent == null) {
                return 1;
            }
            NodeList list = CSSStylableElement.this.getParentNode().getChildNodes();
            int sz = list.getLength();
            int idx = 0;
            for (int i = sz - 1; i >= 0; --i) {
                Node node = list.item(i);
                if (node.getNodeType() != 1 || !this.matchSelectors(selectors, (CSSStylableElement)((Object)node))) continue;
                ++idx;
                if (node == CSSStylableElement.this) break;
            }
            return idx;
        }

        private boolean matchSelectors(SelectorList selectors, CSSStylableElement node) {
            if (selectors == null) {
                return true;
            }
            int sz = selectors.getLength();
            for (int i = 0; i < sz; ++i) {
                if (!node.getSelectorMatcher().matches(selectors.item(i))) continue;
                return true;
            }
            return false;
        }

        protected boolean isActivePseudoClass(String pseudoclassName) {
            CSSCanvas canvas;
            XHTMLDocument doc = CSSStylableElement.this.getOwnerDocument();
            if (doc != null && (canvas = doc.getCanvas()) != null) {
                return canvas.isActivePseudoClass((CSSElement)CSSStylableElement.this, pseudoclassName);
            }
            return false;
        }

        protected boolean isFirstChild() {
            org.dom4j.Element parent = CSSStylableElement.this.getParent();
            if (parent == null) {
                return true;
            }
            return parent.elements().indexOf((Object)CSSStylableElement.this) == 0;
        }

        protected boolean isLastChild() {
            org.dom4j.Element parent = CSSStylableElement.this.getParent();
            if (parent == null) {
                return true;
            }
            List elems = parent.elements();
            return elems.indexOf((Object)CSSStylableElement.this) == elems.size() - 1;
        }

        protected boolean isFirstOfType() {
            for (Node sibling = CSSStylableElement.this.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
                if (sibling.getNodeType() != 1 || !this.getLocalName().equals(sibling.getNodeName())) continue;
                return false;
            }
            return true;
        }

        protected boolean isLastOfType() {
            for (Node sibling = CSSStylableElement.this.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                if (sibling.getNodeType() != 1 || !this.getLocalName().equals(sibling.getNodeName())) continue;
                return false;
            }
            return true;
        }

        protected boolean isNthOfType(int step, int offset) {
            int idx = 0;
            org.dom4j.Element parent = CSSStylableElement.this.getParent();
            if (parent != null) {
                NodeList list = CSSStylableElement.this.getParentNode().getChildNodes();
                int sz = list.getLength();
                for (int i = 0; i < sz; ++i) {
                    Node node = list.item(i);
                    if (node.getNodeType() != 1 || !this.getLocalName().equals(node.getNodeName())) continue;
                    ++idx;
                    if (node != CSSStylableElement.this) {
                        continue;
                    }
                    break;
                }
            } else {
                idx = 1;
            }
            return step == 0 ? idx == 0 : Math.floorMod(idx -= offset, step) == 0;
        }

        protected boolean isNthLastOfType(int step, int offset) {
            int idx = 0;
            org.dom4j.Element parent = CSSStylableElement.this.getParent();
            if (parent != null) {
                NodeList list = CSSStylableElement.this.getParentNode().getChildNodes();
                int sz = list.getLength();
                for (int i = sz - 1; i >= 0; --i) {
                    Node node = list.item(i);
                    if (node.getNodeType() != 1 || !this.getLocalName().equals(node.getNodeName())) continue;
                    ++idx;
                    if (node != CSSStylableElement.this) {
                        continue;
                    }
                    break;
                }
            } else {
                idx = 1;
            }
            return step == 0 ? idx == 0 : Math.floorMod(idx -= offset, step) == 0;
        }

        protected boolean isTarget() {
            int idx;
            String uri = CSSStylableElement.this.getOwnerDocument().getDocumentURI();
            if (uri != null && (idx = uri.lastIndexOf(35)) != -1) {
                int len = uri.length();
                return ++idx < len && this.getId().equals(uri.subSequence(idx, len));
            }
            return false;
        }

        protected boolean isRoot() {
            return CSSStylableElement.this.getOwnerDocument().getDocumentElement() == CSSStylableElement.this;
        }

        protected boolean isEmpty() {
            if (CSSStylableElement.this.hasChildNodes()) {
                NodeList list = CSSStylableElement.this.getChildNodes();
                int sz = list.getLength();
                for (int i = 0; i < sz; ++i) {
                    String value;
                    Node node = list.item(i);
                    short type = node.getNodeType();
                    if (type == 1) {
                        return false;
                    }
                    if (!(type == 3 ? (value = node.getNodeValue()) != null && value.length() > 0 : type == 5 && node.hasChildNodes())) continue;
                    return false;
                }
            }
            return true;
        }

        protected boolean isBlank() {
            if (CSSStylableElement.this.hasChildNodes()) {
                NodeList list = CSSStylableElement.this.getChildNodes();
                int sz = list.getLength();
                for (int i = 0; i < sz; ++i) {
                    String value;
                    Node node = list.item(i);
                    short type = node.getNodeType();
                    if (type == 1) {
                        return false;
                    }
                    if (!(type == 3 ? (value = node.getNodeValue()) != null && value.trim().length() > 0 : type == 5 && node.hasChildNodes())) continue;
                    return false;
                }
            }
            return true;
        }

        protected boolean isDisabled() {
            if (this.hasAttribute("disabled")) {
                return true;
            }
            org.dom4j.Element parent = CSSStylableElement.this.getParent();
            if (parent != null && "fieldset".equalsIgnoreCase(parent.getName()) && !"legend".equals(this.getLocalName())) {
                return parent.attribute("disabled") != null;
            }
            return false;
        }

        protected boolean isDefaultButton() {
            CSSStylableElement parent = (CSSStylableElement)CSSStylableElement.this.getParent();
            if (parent == null) {
                return false;
            }
            while (parent != null && !"form".equalsIgnoreCase(parent.getTagName())) {
                parent = (CSSStylableElement)parent.getParent();
            }
            String formid = parent == null ? null : parent.getId();
            Node sibling = CSSStylableElement.this.getPreviousSibling();
            while (sibling != null) {
                if (sibling.getNodeType() != 1) continue;
                CSSStylableElement element = (CSSStylableElement)((Object)sibling);
                if (!this.defaultButtonCheck(element, formid)) {
                    return false;
                }
                if (element.hasChildNodes()) {
                    NodeList list = element.getChildNodes();
                    int sz = list.getLength();
                    for (int i = 0; i < sz; ++i) {
                        Node node = list.item(i);
                        if (node.getNodeType() != 1 || this.defaultButtonCheck((CSSStylableElement)((Object)node), formid)) continue;
                        return false;
                    }
                }
                sibling = sibling.getPreviousSibling();
            }
            return true;
        }

        private boolean defaultButtonCheck(CSSElement element, String formid) {
            String type;
            String tagname;
            String form;
            return element.hasAttribute("disabled") || (form = element.getAttribute("form")) != null && !form.equals(formid) || !((tagname = element.getTagName().toLowerCase(Locale.ROOT)).equals("input") ? "submit".equalsIgnoreCase(type = element.getAttribute("type")) || "image".equalsIgnoreCase(type) : tagname.equals("button") && "submit".equalsIgnoreCase(element.getAttribute("type")));
        }

        protected String getNamespaceURI() {
            return CSSStylableElement.this.getNamespaceURI();
        }

        protected String getAttributeValue(String attrName) {
            return CSSStylableElement.this.getAttributeValue(attrName);
        }

        protected boolean hasAttribute(String attrName) {
            Attribute attr = CSSStylableElement.this.attribute(attrName);
            if (attr == null) {
                List list = CSSStylableElement.this.attributeList();
                for (Attribute item : list) {
                    String nsuri;
                    if (!attrName.equalsIgnoreCase(item.getName()) || (nsuri = item.getNamespaceURI()) != null && nsuri.length() != 0 && !"http://www.w3.org/1999/xhtml".equals(nsuri)) continue;
                    return true;
                }
                return false;
            }
            return attr != null;
        }

        protected String getId() {
            return CSSStylableElement.this.getId();
        }

        protected CSSDocument.ComplianceMode getComplianceMode() {
            return CSSStylableElement.this.getOwnerDocument().getComplianceMode();
        }

        protected boolean isVisitedURI(String href) {
            return CSSStylableElement.this.getOwnerDocument().isVisitedURI(href);
        }

        protected String getLanguage() {
            String lang = CSSStylableElement.this.attributeValue("lang");
            if (lang == null) {
                lang = CSSStylableElement.this.attributeValue("LANG");
            }
            CSSStylableElement parent = CSSStylableElement.this;
            while ((lang == null || lang.length() == 0) && (parent = parent.getParent()) != null) {
                lang = parent.attributeValue("lang");
                if (lang != null) continue;
                lang = CSSStylableElement.this.attributeValue("LANG");
            }
            if (lang == null) {
                lang = "";
            }
            return lang;
        }

        protected boolean isDir(String argument) {
            try {
                return super.isDir(argument);
            }
            catch (RuntimeException e) {
                return false;
            }
        }

        protected DirectionalityHelper.Directionality getDirectionality() {
            return DirectionalityHelper.getDirectionality((Element)((Object)CSSStylableElement.this));
        }

        protected boolean scopeMatchChild(CombinatorSelector selector) {
            SimpleSelector desc = selector.getSecondSelector();
            NodeList list = CSSStylableElement.this.getChildNodes();
            int sz = list.getLength();
            for (int i = 0; i < sz; ++i) {
                SelectorMatcher childSM;
                Node node = list.item(i);
                if (node.getNodeType() != 1 || !(childSM = ((CSSStylableElement)((Object)node)).getSelectorMatcher()).matches((Selector)desc)) continue;
                return true;
            }
            return false;
        }

        protected boolean scopeMatchDescendant(CombinatorSelector selector) {
            SimpleSelector desc = selector.getSecondSelector();
            NodeList list = CSSStylableElement.this.getChildNodes();
            return this.scopeMatchRecursive(list, (Selector)desc);
        }

        public boolean matchesRelational(Selector selector) {
            NodeList list = CSSStylableElement.this.getChildNodes();
            return this.scopeMatchRecursive(list, selector);
        }

        private boolean scopeMatchRecursive(NodeList list, Selector desc) {
            int sz = list.getLength();
            for (int i = 0; i < sz; ++i) {
                SelectorMatcher childSM;
                Node node = list.item(i);
                if (node.getNodeType() != 1 || !(childSM = ((CSSStylableElement)((Object)node)).getSelectorMatcher()).matches(desc) && !this.scopeMatchRecursive(node.getChildNodes(), desc)) continue;
                return true;
            }
            return false;
        }

        protected boolean scopeMatchDirectAdjacent(CombinatorSelector selector) {
            SelectorMatcher siblingSM = null;
            for (Node sibling = CSSStylableElement.this.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                if (sibling.getNodeType() != 1) continue;
                siblingSM = ((CSSStylableElement)((Object)sibling)).getSelectorMatcher();
                break;
            }
            if (siblingSM != null) {
                return siblingSM.matches((Selector)selector.getSecondSelector());
            }
            return false;
        }
    }
}

