/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueFactory;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.OperandExpression;
import io.sf.carte.doc.style.css.property.ProductExpression;
import io.sf.carte.doc.style.css.property.StyleExpression;
import io.sf.carte.doc.style.css.property.SumExpression;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import org.w3c.dom.DOMException;

public class ExpressionFactory {
    private LexicalUnit nextLexicalUnit;

    public ExpressionFactory(LexicalUnit nextLexicalUnit) {
        this.nextLexicalUnit = nextLexicalUnit;
    }

    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit;
    }

    public CSSExpression createExpression(LexicalUnit calcParams) throws DOMException {
        return this.createExpression(calcParams, this.getCSSValueFactory());
    }

    protected CSSValueFactory getCSSValueFactory() {
        return new ValueFactory();
    }

    private StyleExpression createExpression(LexicalUnit lu, CSSValueFactory factory) throws DOMException {
        StyleExpression expression = null;
        LexicalUnit.LexicalType lastlutype = LexicalUnit.LexicalType.UNKNOWN;
        block10: while (lu != null) {
            boolean inverse = false;
            LexicalUnit.LexicalType lutype = lu.getLexicalUnitType();
            switch (lutype) {
                case OPERATOR_MINUS: {
                    inverse = true;
                }
                case OPERATOR_PLUS: {
                    StyleExpression operation;
                    if (expression == null) {
                        if (inverse) {
                            expression = new SumExpression();
                            expression.nextOperandInverse = true;
                            break;
                        }
                        throw new DOMException(12, "Missing operand");
                    }
                    if (expression.getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
                        operation = new SumExpression();
                        operation.addExpression(expression);
                        operation.nextOperandInverse = inverse;
                        expression = operation;
                        break;
                    }
                    if (expression.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                        expression.nextOperandInverse = inverse;
                        break;
                    }
                    ExpressionFactory.sanityCheck(lastlutype);
                    StyleExpression parent = expression.getParentExpression();
                    if (parent == null) {
                        operation = new SumExpression();
                        operation.addExpression(expression);
                        operation.nextOperandInverse = inverse;
                        expression = operation;
                        break;
                    }
                    expression = parent;
                    expression.nextOperandInverse = inverse;
                    break;
                }
                case OPERATOR_SLASH: {
                    inverse = true;
                }
                case OPERATOR_MULTIPLY: {
                    StyleExpression operation;
                    if (expression == null) {
                        throw new DOMException(12, "Missing factor");
                    }
                    if (expression.getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
                        operation = new ProductExpression();
                        operation.addExpression(expression);
                        operation.nextOperandInverse = inverse;
                        expression = operation;
                        break;
                    }
                    if (expression.getPartType() == CSSExpression.AlgebraicPart.SUM) {
                        ExpressionFactory.sanityCheck(lastlutype);
                        operation = new ProductExpression();
                        if (lastlutype != LexicalUnit.LexicalType.SUB_EXPRESSION) {
                            expression.replaceLastExpression(operation);
                        } else {
                            operation.addExpression(expression);
                        }
                        operation.nextOperandInverse = inverse;
                        expression = operation;
                        break;
                    }
                    ExpressionFactory.sanityCheck(lastlutype);
                    expression.nextOperandInverse = inverse;
                    break;
                }
                case SUB_EXPRESSION: {
                    LexicalUnit subval = lu.getSubValues();
                    if (subval == null) {
                        throw new DOMException(12, "Empty sub-expression");
                    }
                    StyleExpression subexpr = this.createExpression(subval, factory);
                    if (subexpr != null) {
                        if (expression != null) {
                            expression.addExpression(subexpr);
                            if (expression.getPartType() != CSSExpression.AlgebraicPart.SUM) break;
                            expression = subexpr;
                            break;
                        }
                        expression = subexpr;
                        break;
                    }
                    throw new DOMException(12, "Bad subexpression");
                }
                case OPERATOR_COMMA: {
                    if (this.nextLexicalUnit != null || expression.getParentExpression() != null) {
                        throw new DOMException(5, "Bad operand: ','");
                    }
                    this.nextLexicalUnit = lu;
                    return expression;
                }
                case IDENT: {
                    String constname = lu.getStringValue();
                    TypedValue typed = this.createConstant(constname);
                    if (this.isInvalidOperand(typed, lutype, lastlutype)) {
                        throw new DOMException(5, "Bad operands");
                    }
                    OperandExpression operand = new OperandExpression();
                    operand.setOperand(typed);
                    expression = ExpressionFactory.addOperand(expression, operand);
                    lastlutype = LexicalUnit.LexicalType.DIMENSION;
                    lu = lu.getNextLexicalUnit();
                    continue block10;
                }
                case CALC: {
                    StyleExpression subexpr;
                    LexicalUnit subval;
                    if (this.isCalcValue()) {
                        lutype = LexicalUnit.LexicalType.SUB_EXPRESSION;
                        subval = lu.getParameters();
                        if (subval == null) {
                            throw new DOMException(12, "Empty sub-calc()");
                        }
                        subexpr = this.createExpression(subval, factory);
                        if (subexpr != null) {
                            subexpr.setInverseOperation(inverse);
                            if (expression != null) {
                                expression.addExpression(subexpr);
                                break;
                            }
                            expression = subexpr;
                            break;
                        }
                        throw new DOMException(12, "Invalid sub-calc()");
                    }
                }
                default: {
                    CSSPrimitiveValue primi = factory.createCSSPrimitiveValue(lu);
                    if (this.isInvalidOperand(primi, lutype, lastlutype)) {
                        throw new DOMException(5, "Bad operands");
                    }
                    OperandExpression operand = new OperandExpression();
                    operand.setOperand(primi);
                    expression = ExpressionFactory.addOperand(expression, operand);
                    lastlutype = LexicalUnit.LexicalType.DIMENSION;
                    lu = lu.getNextLexicalUnit();
                    continue block10;
                }
            }
            lastlutype = lutype;
            lu = lu.getNextLexicalUnit();
        }
        if (ExpressionFactory.isOperatorType(lastlutype)) {
            throw new DOMException(12, "Missing operand");
        }
        if (expression.getParentExpression() != null) {
            expression = expression.getParentExpression();
        }
        return expression;
    }

    private static void sanityCheck(LexicalUnit.LexicalType lastlutype) throws DOMException {
        if (lastlutype != LexicalUnit.LexicalType.DIMENSION && lastlutype != LexicalUnit.LexicalType.REAL && lastlutype != LexicalUnit.LexicalType.INTEGER && lastlutype != LexicalUnit.LexicalType.SUB_EXPRESSION && lastlutype != LexicalUnit.LexicalType.ENV) {
            throw new DOMException(12, "Missing operand");
        }
    }

    private static StyleExpression addOperand(StyleExpression expression, OperandExpression operand) throws DOMException {
        if (expression == null) {
            expression = operand;
        } else {
            if (expression.getPartType() == CSSExpression.AlgebraicPart.OPERAND) {
                throw new DOMException(5, "Bad expression");
            }
            expression.addExpression(operand);
        }
        return expression;
    }

    protected boolean isInvalidOperand(CSSPrimitiveValue primi, LexicalUnit.LexicalType lutype, LexicalUnit.LexicalType lastlutype) {
        if (ExpressionFactory.isOperatorType(lutype)) {
            return ExpressionFactory.isOperatorType(lastlutype);
        }
        return !ExpressionFactory.isOperatorType(lastlutype) && lastlutype != LexicalUnit.LexicalType.UNKNOWN && lutype != LexicalUnit.LexicalType.OPERATOR_COMMA;
    }

    private static boolean isOperatorType(LexicalUnit.LexicalType lutype) {
        switch (lutype) {
            case OPERATOR_MINUS: 
            case OPERATOR_PLUS: 
            case OPERATOR_SLASH: 
            case OPERATOR_MULTIPLY: {
                return true;
            }
        }
        return false;
    }

    private TypedValue createConstant(String constname) {
        NumberValue number = new NumberValue();
        if ("pi".equalsIgnoreCase(constname)) {
            number.setFloatValue((short)0, (float)Math.PI);
        } else if ("e".equalsIgnoreCase(constname)) {
            number.setFloatValue((short)0, (float)Math.E);
        } else {
            if (this.isCalcValue()) {
                throw new DOMException(5, "Unknown constant: " + constname);
            }
            IdentifierValue ident = new IdentifierValue();
            ident.setStringValue(CSSValue.Type.IDENT, constname);
            return ident;
        }
        return number;
    }

    protected boolean isCalcValue() {
        return false;
    }
}

