/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSEnvVariableValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.impl.CSSUtil;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ProxyValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import org.w3c.dom.DOMException;

public class EnvVariableValue
extends ProxyValue
implements CSSEnvVariableValue {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private int[] indices = null;
    private LexicalUnit fallback = null;

    EnvVariableValue() {
        super(CSSValue.Type.ENV);
    }

    protected EnvVariableValue(EnvVariableValue copied) {
        super(copied);
        this.name = copied.name;
        if (copied.indices != null) {
            this.indices = (int[])copied.indices.clone();
        }
        if (copied.fallback != null) {
            this.fallback = copied.fallback.clone();
        }
    }

    @Override
    public String getCssText() {
        if (this.name == null) {
            return "";
        }
        BufferSimpleWriter sw = new BufferSimpleWriter(42);
        try {
            this.writeCssText((SimpleWriter)sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        StringBuilder buf = new StringBuilder();
        buf.append("env(").append(this.name);
        if (this.indices != null) {
            for (int index : this.indices) {
                buf.append(' ');
                buf.append(Integer.toString(index));
            }
        }
        if (this.fallback != null) {
            buf.append(',').append(LexicalValue.serializeMinifiedSequence(this.fallback));
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)"env(");
        wri.write((CharSequence)this.name);
        if (this.indices != null) {
            for (int index : this.indices) {
                wri.write(' ');
                wri.write((CharSequence)Integer.toString(index));
            }
        }
        if (this.fallback != null) {
            wri.write((CharSequence)", ");
            wri.write((CharSequence)this.fallback.toString());
        }
        wri.write(')');
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.checkModifiableProperty();
        ValueFactory factory = new ValueFactory();
        StyleValue cssval = factory.parseProperty(cssText);
        if (cssval == null || cssval.getPrimitiveType() != CSSValue.Type.ENV) {
            throw new DOMException(13, "Not an environment variable value.");
        }
        EnvVariableValue env = (EnvVariableValue)cssval;
        this.name = env.getName();
        this.fallback = env.fallback;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.indices);
        result = 31 * result + Objects.hash(this.fallback, this.name);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnvVariableValue other = (EnvVariableValue)obj;
        return this.name.equals(other.name) && Arrays.equals(this.indices, other.indices) && Objects.equals(this.fallback, other.fallback);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int[] getIndices() {
        return this.indices;
    }

    @Override
    public LexicalUnit getFallback() {
        return this.fallback;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax syntax) {
        CSSValueSyntax rootSyntax = syntax;
        if (syntax != null) {
            if (syntax.getCategory() == CSSValueSyntax.Category.universal) {
                return CSSValueSyntax.Match.TRUE;
            }
            do {
                CSSValueSyntax.Match result;
                if ((result = CSSUtil.matchEnv(rootSyntax, syntax, this.name, this.fallback)) == CSSValueSyntax.Match.FALSE) continue;
                return result;
            } while ((syntax = syntax.getNext()) != null);
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax syntax) {
        return CSSUtil.matchEnv(syntax, syntax, this.name, this.fallback);
    }

    @Override
    public EnvVariableValue clone() {
        return new EnvVariableValue(this);
    }

    static /* synthetic */ int[] access$102(EnvVariableValue x0, int[] x1) {
        x0.indices = x1;
        return x1;
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(EnvVariableValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            LinkedList<Integer> indexList;
            block8: {
                LexicalUnit lu = lunit.getParameters();
                if (lu == null || lu.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
                    throw new DOMException(17, "Variable name must be an identifier");
                }
                EnvVariableValue.this.name = lu.getStringValue();
                EnvVariableValue.access$102(EnvVariableValue.this, null);
                indexList = null;
                while (true) {
                    if ((lu = lu.getNextLexicalUnit()) == null) {
                        EnvVariableValue.this.fallback = null;
                        break block8;
                    }
                    LexicalUnit.LexicalType type = lu.getLexicalUnitType();
                    if (type == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        EnvVariableValue.this.fallback = lu.getNextLexicalUnit();
                        if (EnvVariableValue.this.fallback != null) {
                            EnvVariableValue.this.fallback = EnvVariableValue.this.fallback.clone();
                        }
                        break block8;
                    }
                    if (type != LexicalUnit.LexicalType.INTEGER) break;
                    if (indexList == null) {
                        indexList = new LinkedList<Integer>();
                    }
                    indexList.add(lu.getIntegerValue());
                }
                throw new DOMException(12, "Unexpected token: " + lu.getCssText());
            }
            if (indexList != null) {
                EnvVariableValue.access$102(EnvVariableValue.this, new int[indexList.size()]);
                for (int i = 0; i < EnvVariableValue.this.indices.length; ++i) {
                    ((EnvVariableValue)EnvVariableValue.this).indices[i] = (Integer)indexList.get(i);
                }
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

