/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.EasingFunction;
import io.sf.carte.doc.style.css.property.FunctionValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import java.util.Iterator;
import org.w3c.dom.DOMException;

class CubicBezierFunction
extends EasingFunction {
    private static final long serialVersionUID = 1L;

    CubicBezierFunction() {
        super(CSSValue.Type.CUBIC_BEZIER);
    }

    protected CubicBezierFunction(CubicBezierFunction copied) {
        super(copied);
    }

    private void validate() throws DOMException {
        LinkedCSSValueList args = this.getArguments();
        int len = args.size();
        if (len != 4) {
            throw new DOMException(12, "cubic-bezier() requires four arguments: " + this.getCssText());
        }
        CSSValueSyntax syn = SyntaxParser.createSimpleSyntax("number");
        Iterator it = args.iterator();
        StyleValue arg = (StyleValue)it.next();
        this.checkX(arg, syn);
        arg = (StyleValue)it.next();
        this.checkY(arg, syn);
        arg = (StyleValue)it.next();
        this.checkX(arg, syn);
        arg = (StyleValue)it.next();
        this.checkY(arg, syn);
    }

    private void checkX(StyleValue arg, CSSValueSyntax syn) {
        CSSNumberValue number;
        if (arg.getPrimitiveType() == CSSValue.Type.NUMERIC ? (number = (CSSNumberValue)((Object)arg)).getUnitType() == 0 && !number.isNegativeNumber() : arg.matches(syn) == CSSValueSyntax.Match.TRUE) {
            return;
        }
        throw this.createUnexpectedArgumentTypeException(arg);
    }

    private void checkY(StyleValue arg, CSSValueSyntax syn) {
        if (arg.matches(syn) == CSSValueSyntax.Match.FALSE) {
            throw this.createUnexpectedArgumentTypeException(arg);
        }
    }

    private DOMException createUnexpectedArgumentTypeException(StyleValue arg) {
        return new DOMException(17, "Unexpected argument in cubic-bezier(): " + arg.getCssText());
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new BezierLexicalSetter();
    }

    @Override
    public CubicBezierFunction clone() {
        return new CubicBezierFunction(this);
    }

    class BezierLexicalSetter
    extends FunctionValue.FunctionLexicalSetter {
        BezierLexicalSetter() {
            super(CubicBezierFunction.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) throws DOMException {
            super.setLexicalUnit(lunit);
            CubicBezierFunction.this.validate();
        }
    }
}

