/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class MaskShorthandSetter
extends ShorthandSetter {
    private StringBuilder layerBuffer = null;
    private StringBuilder miniLayerBuffer = null;
    private int layerCount = 0;
    private final ValueList lstImage = ValueList.createCSValueList();
    private final ValueList lstPosition = ValueList.createCSValueList();
    private final ValueList lstSize = ValueList.createCSValueList();
    private final ValueList lstRepeat = ValueList.createCSValueList();
    private final ValueList lstClip = ValueList.createCSValueList();
    private final ValueList lstOrigin = ValueList.createCSValueList();
    private final ValueList lstMode = ValueList.createCSValueList();
    private final ValueList lstComposite = ValueList.createCSValueList();
    private LexicalUnit geometryBox = null;

    MaskShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "mask");
    }

    @Override
    public void init(LexicalUnit shorthandValue, boolean important) {
        this.currentValue = shorthandValue;
        this.setPriority(important);
        this.countLayers(shorthandValue);
    }

    void countLayers(LexicalUnit shorthandValue) {
        this.layerCount = 0;
        int valueCount = 0;
        for (LexicalUnit value = shorthandValue; value != null; value = value.getNextLexicalUnit()) {
            if (value.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                if (valueCount <= 0) continue;
                ++this.layerCount;
                valueCount = 0;
                continue;
            }
            ++valueCount;
        }
        if (valueCount > 0) {
            ++this.layerCount;
        }
    }

    @Override
    StringBuilder getValueItemBuffer() {
        return this.layerBuffer;
    }

    @Override
    StringBuilder getValueItemBufferMini() {
        return this.miniLayerBuffer;
    }

    @Override
    public short assignSubproperties() {
        this.layerBuffer = new StringBuilder(64);
        this.miniLayerBuffer = new StringBuilder(64);
        String[] subparray = this.getShorthandSubproperties();
        HashSet<String> subp = new HashSet<String>(subparray.length);
        int i = 0;
        while (i < this.layerCount && this.currentValue != null) {
            int layerStatus = 2;
            subp.clear();
            Collections.addAll(subp, subparray);
            while (this.currentValue != null) {
                if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    if (layerStatus != 0) break;
                    this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
                    this.layerBuffer.setLength(0);
                    this.miniLayerBuffer.setLength(0);
                    if (++i != this.layerCount) {
                        this.layerBuffer.append(',');
                        this.miniLayerBuffer.append(',');
                    }
                    this.currentValue = this.currentValue.getNextLexicalUnit();
                    break;
                }
                LexicalUnit.LexicalType lutype = this.currentValue.getLexicalUnitType();
                if (lutype == LexicalUnit.LexicalType.INHERIT || lutype == LexicalUnit.LexicalType.INITIAL || lutype == LexicalUnit.LexicalType.UNSET || lutype == LexicalUnit.LexicalType.REVERT) {
                    if (this.layerCount != 1 || i != 0 || this.currentValue.getNextLexicalUnit() != null) {
                        layerStatus = 2;
                        break;
                    }
                    StyleValue keyword = this.valueFactory.createCSSValueItem(this.currentValue, true).getCSSValue();
                    this.setSubpropertiesToKeyword(keyword);
                    this.appendValueItemString(keyword);
                    this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
                    this.layerBuffer.setLength(0);
                    this.miniLayerBuffer.setLength(0);
                    return 0;
                }
                layerStatus = this.assignLayerValue(i, subp);
                if (layerStatus == 0) continue;
                if (layerStatus == 1) {
                    this.flush();
                    return 1;
                }
                this.reportUnknownValue(subp);
                break;
            }
            if (layerStatus != 0) {
                this.layerBuffer.setLength(0);
                this.miniLayerBuffer.setLength(0);
                StringBuilder msgbuf = new StringBuilder(64);
                msgbuf.append("Invalid layer found: ").append(i);
                if (this.currentValue != null) {
                    msgbuf.append(' ').append(this.currentValue.toString());
                }
                this.reportDeclarationError("mask", msgbuf.toString());
                return 2;
            }
            this.assignPendingValues(i, subp);
            if (subp.isEmpty()) continue;
            this.resetUnsetProperties(subp);
        }
        this.appendToValueBuffer(this.layerBuffer, this.miniLayerBuffer);
        this.setListSubpropertyValue("mask-image", this.lstImage);
        this.setListSubpropertyValue("mask-position", this.lstPosition);
        this.setListSubpropertyValue("mask-size", this.lstSize);
        this.setListSubpropertyValue("mask-origin", this.lstOrigin);
        this.setListSubpropertyValue("mask-clip", this.lstClip);
        this.setListSubpropertyValue("mask-repeat", this.lstRepeat);
        this.setListSubpropertyValue("mask-composite", this.lstComposite);
        this.setListSubpropertyValue("mask-mode", this.lstMode);
        this.resetMaskBorderProperties();
        this.flush();
        return 0;
    }

    private short assignLayerValue(int i, Set<String> subp) {
        int retVal = 2;
        if (subp.contains("mask-image") && this.testImage(i, subp)) {
            this.nextCurrentValue();
            retVal = 0;
        } else if (subp.contains("mask-position") && this.testPosition(this.lstPosition)) {
            subp.remove("mask-position");
            this.nextCurrentValue();
            retVal = 0;
            if (this.currentValue != null && LexicalUnit.LexicalType.OPERATOR_SLASH == this.currentValue.getLexicalUnitType()) {
                StyleDeclarationErrorHandler eh;
                this.currentValue = this.currentValue.getNextLexicalUnit();
                if (this.currentValue != null) {
                    if (this.testSize(i, subp)) {
                        this.nextCurrentValue();
                        return 0;
                    }
                    if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.PREFIXED_FUNCTION) {
                        this.setPrefixedValue(this.currentValue);
                        return 1;
                    }
                }
                if ((eh = this.styleDeclaration.getStyleDeclarationErrorHandler()) != null) {
                    eh.shorthandSyntaxError("mask", "Size not found after slash");
                }
                retVal = 2;
            }
        } else if (subp.contains("mask-mode") && this.testIdentifierProperty(i, subp, "mask-mode", this.lstMode)) {
            this.nextCurrentValue();
            subp.remove("mask-mode");
            retVal = 0;
        } else if (subp.contains("mask-composite") && this.testIdentifierProperty(i, subp, "mask-composite", this.lstComposite)) {
            this.nextCurrentValue();
            subp.remove("mask-composite");
            retVal = 0;
        } else if (subp.contains("mask-repeat") && this.testRepeat(this.lstRepeat)) {
            subp.remove("mask-repeat");
            retVal = 0;
        } else if (subp.contains("mask-origin") && this.testIdentifierProperty(i, subp, "mask-origin", this.lstOrigin)) {
            this.geometryBox = this.currentValue;
            this.nextCurrentValue();
            subp.remove("mask-origin");
            retVal = 0;
        } else if (subp.contains("mask-clip") && this.testIdentifierProperty(i, subp, "mask-clip", this.lstClip)) {
            this.nextCurrentValue();
            subp.remove("mask-clip");
            this.geometryBox = null;
            retVal = 0;
        } else if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.PREFIXED_FUNCTION || this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && this.isPrefixedIdentValue()) {
            this.setPrefixedValue(this.currentValue);
            retVal = 1;
        }
        return (short)retVal;
    }

    private void assignPendingValues(int i, Set<String> subp) {
        if (subp.contains("mask-clip") && this.geometryBox != null) {
            StyleValue value = this.createCSSValue("mask-clip", this.geometryBox);
            this.lstClip.add(value);
            subp.remove("mask-clip");
        }
        this.geometryBox = null;
    }

    @Override
    protected void nextCurrentValue() {
        this.appendValueItemString();
        this.currentValue = this.currentValue.getNextLexicalUnit();
    }

    private void reportUnknownValue(Set<String> subp) {
        BaseCSSDeclarationRule prule = this.styleDeclaration.getParentRule();
        if (prule != null) {
            StyleDeclarationErrorHandler eh = prule.getStyleDeclarationErrorHandler();
            if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                eh.unknownIdentifier("mask", this.currentValue.getStringValue());
            } else {
                LexicalUnit[] lua = new LexicalUnit[]{this.currentValue};
                eh.unassignedShorthandValues("mask", subp.toArray(new String[0]), lua);
            }
        }
    }

    private void resetUnsetProperties(Set<String> subp) {
        for (String pname : subp) {
            StyleValue cssVal = this.defaultPropertyValue(pname);
            if ("mask-image".equals(pname)) {
                this.lstImage.add(cssVal);
                continue;
            }
            if ("mask-position".equals(pname)) {
                this.lstPosition.add(cssVal);
                continue;
            }
            if ("mask-size".equals(pname)) {
                ValueList list = ValueList.createWSValueList();
                list.add(cssVal);
                list.add(cssVal);
                this.lstSize.add(list);
                continue;
            }
            if ("mask-origin".equals(pname)) {
                this.lstOrigin.add(cssVal);
                continue;
            }
            if ("mask-clip".equals(pname)) {
                this.lstClip.add(cssVal);
                continue;
            }
            if ("mask-repeat".equals(pname)) {
                this.lstRepeat.add(cssVal);
                continue;
            }
            if ("mask-mode".equals(pname)) {
                this.lstMode.add(cssVal);
                continue;
            }
            if (!"mask-composite".equals(pname)) continue;
            this.lstComposite.add(cssVal);
        }
    }

    private boolean testImage(int i, Set<String> subp) {
        if (!this.isAttrTainted() && this.isImage()) {
            this.lstImage.add(this.createCSSValue("mask-image", this.currentValue));
            subp.remove("mask-image");
            return true;
        }
        if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && "none".equals(this.currentValue.getStringValue())) {
            this.lstImage.add(this.createCSSValue("mask-image", this.currentValue));
            subp.remove("mask-image");
            return true;
        }
        return false;
    }

    private boolean testPosition(ValueList posList) {
        if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && this.testIdentifiers("mask-position") || ValueFactory.isLengthPercentageSACUnit(this.currentValue)) {
            ValueList list = ValueList.createWSValueList();
            StyleValue value = this.createCSSValue("mask-position", this.currentValue);
            list.add(value);
            int count = 1;
            LexicalUnit nlu = this.currentValue.getNextLexicalUnit();
            while (nlu != null && count < 4) {
                if (nlu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && this.getShorthandDatabase().isIdentifierValue("mask-position", nlu.getStringValue()) || ValueFactory.isLengthPercentageSACUnit(nlu)) {
                    value = this.createCSSValue("mask-position", nlu);
                    list.add(value);
                    count = (short)(count + 1);
                    this.nextCurrentValue();
                    nlu = this.currentValue.getNextLexicalUnit();
                    continue;
                }
                nlu = null;
            }
            if (list.getLength() == 1) {
                posList.add(list.item(0));
            } else if (this.checkPositionProperty(list)) {
                posList.add(list);
            } else {
                BaseCSSDeclarationRule prule = this.styleDeclaration.getParentRule();
                if (prule != null) {
                    CSSPropertyValueException ex = new CSSPropertyValueException("Wrong value for mask-position");
                    ex.setValueText(list.getCssText());
                    prule.getStyleDeclarationErrorHandler().wrongValue("mask-position", ex);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkPositionProperty(ValueList list) {
        int count = list.getLength();
        if (count == 2) {
            return true;
        }
        if (count == 4) {
            return list.item(0).getPrimitiveType() == CSSValue.Type.IDENT && list.item(1).getPrimitiveType() != CSSValue.Type.IDENT && list.item(2).getPrimitiveType() == CSSValue.Type.IDENT && list.item(3).getPrimitiveType() != CSSValue.Type.IDENT;
        }
        if (list.item(0).getPrimitiveType() != CSSValue.Type.IDENT) {
            return false;
        }
        if (list.item(1).getPrimitiveType() == CSSValue.Type.IDENT && list.item(2).getPrimitiveType() != CSSValue.Type.IDENT) {
            return true;
        }
        return list.item(1).getPrimitiveType() != CSSValue.Type.IDENT && list.item(2).getPrimitiveType() == CSSValue.Type.IDENT;
    }

    private boolean testSize(int i, Set<String> subp) {
        if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && this.testIdentifiers("mask-size") || ValueFactory.isLengthPercentageSACUnit(this.currentValue)) {
            ValueList list = ValueList.createWSValueList();
            StyleValue value = this.createCSSValue("mask-size", this.currentValue);
            list.add(value);
            this.layerBuffer.append(" /");
            this.miniLayerBuffer.append('/');
            LexicalUnit nlu = this.currentValue.getNextLexicalUnit();
            if (nlu != null && (nlu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && this.getShorthandDatabase().isIdentifierValue("mask-size", nlu.getStringValue()) || ValueFactory.isLengthPercentageSACUnit(nlu))) {
                value = this.createCSSValue("mask-size", nlu);
                list.add(value);
                this.nextCurrentValue();
            }
            if (list.getLength() == 1) {
                this.lstSize.add(list.item(0));
            } else {
                this.lstSize.add(list);
            }
            subp.remove("mask-size");
            return true;
        }
        return false;
    }

    private boolean testRepeat(ValueList rptList) {
        if (LexicalUnit.LexicalType.IDENT == this.currentValue.getLexicalUnitType() && this.testIdentifiers("mask-repeat")) {
            StyleValue value = this.createCSSValue("mask-repeat", this.currentValue);
            String s = value.getCssText();
            this.nextCurrentValue();
            if (s.equals("repeat-y") || s.equals("repeat-x")) {
                rptList.add(value);
            } else if (this.currentValue != null && LexicalUnit.LexicalType.IDENT == this.currentValue.getLexicalUnitType() && this.testIdentifiers("mask-repeat")) {
                ValueList list = ValueList.createWSValueList();
                list.add(value);
                list.add(this.createCSSValue("mask-repeat", this.currentValue));
                rptList.add(list);
                this.nextCurrentValue();
            } else {
                rptList.add(value);
            }
            return true;
        }
        return false;
    }

    private boolean testIdentifierProperty(int layer, Set<String> subp, String subpropertyName, ValueList lst) {
        if (LexicalUnit.LexicalType.IDENT == this.currentValue.getLexicalUnitType() && this.testIdentifiers(subpropertyName)) {
            StyleValue value = this.createCSSValue(subpropertyName, this.currentValue);
            lst.add(value);
            return true;
        }
        return false;
    }

    @Override
    protected void resetSubproperties() {
        super.resetSubproperties();
        this.resetMaskBorderProperties();
    }

    private void resetMaskBorderProperties() {
        this.setPropertyToDefault("mask-border-source");
        this.setPropertyToDefault("mask-border-slice");
        this.setPropertyToDefault("mask-border-width");
        this.setPropertyToDefault("mask-border-outset");
        this.setPropertyToDefault("mask-border-repeat");
        this.setPropertyToDefault("mask-border-mode");
    }

    @Override
    protected void setSubpropertiesToKeyword(StyleValue keyword) {
        super.setSubpropertiesToKeyword(keyword);
        this.setProperty("mask-border-source", keyword, this.isPriorityImportant());
        this.setProperty("mask-border-slice", keyword, this.isPriorityImportant());
        this.setProperty("mask-border-width", keyword, this.isPriorityImportant());
        this.setProperty("mask-border-outset", keyword, this.isPriorityImportant());
        this.setProperty("mask-border-repeat", keyword, this.isPriorityImportant());
        this.setProperty("mask-border-mode", keyword, this.isPriorityImportant());
        this.flush();
    }
}

