/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.LinkedStringList;
import io.sf.carte.doc.style.css.CSSGroupingRule;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.nsac.ParserControl;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.SheetHandler;
import io.sf.carte.doc.style.css.parser.CSSParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.dom.DOMException;

public abstract class GroupingRule
extends BaseCSSRule
implements CSSGroupingRule {
    private static final long serialVersionUID = 1L;
    CSSRuleArrayList cssRules;

    protected GroupingRule(AbstractCSSStyleSheet parentSheet, short type, byte origin) {
        super(parentSheet, type, origin);
        this.cssRules = new CSSRuleArrayList();
    }

    protected GroupingRule(AbstractCSSStyleSheet parentSheet, GroupingRule copyfrom) {
        super(parentSheet, copyfrom.getType(), copyfrom.getOrigin());
        if (copyfrom.getPrecedingComments() != null) {
            this.setPrecedingComments(new LinkedStringList());
            this.getPrecedingComments().addAll(copyfrom.getPrecedingComments());
        }
        this.cssRules = new CSSRuleArrayList(copyfrom.getCssRules().getLength());
        for (AbstractCSSRule rule : copyfrom.getCssRules()) {
            AbstractCSSRule cloned = rule.clone(parentSheet);
            cloned.setParentRule(this);
            this.cssRules.add(cloned);
        }
    }

    public CSSRuleArrayList getCssRules() {
        return this.cssRules;
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        if (index < 0 || index > this.cssRules.size()) {
            throw new DOMException(1, "Index out of bounds in rule list");
        }
        StringReader re = new StringReader(rule);
        RuleHandler handler = new RuleHandler();
        handler.setCurrentInsertionIndex(index);
        BaseCSSRule.AllowWarningsRuleErrorHandler errorHandler = new BaseCSSRule.AllowWarningsRuleErrorHandler();
        CSSParser parser = (CSSParser)this.createSACParser();
        parser.setDocumentHandler(handler);
        parser.setErrorHandler(errorHandler);
        try {
            this.parseRule((Reader)re, parser);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return index;
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        if (index < 0 || index >= this.cssRules.size()) {
            throw new DOMException(1, "Could not delete rule in rule list: index out of bounds.");
        }
        this.cssRules.remove(index);
    }

    int insertRule(AbstractCSSRule cssrule, int index) {
        cssrule.setParentRule(this);
        return this.cssRules.insertRule(cssrule, index);
    }

    int addRule(AbstractCSSRule cssrule) {
        int len = this.cssRules.getLength();
        this.cssRules.add(cssrule);
        cssrule.setParentRule(this);
        return len;
    }

    @Override
    void setRule(AbstractCSSRule copyMe) {
        GroupingRule groupingRule = (GroupingRule)copyMe;
        this.setGroupingRule(groupingRule);
        this.setPrecedingComments(groupingRule.getPrecedingComments());
        this.setTrailingComments(groupingRule.getTrailingComments());
        this.cssRules.clear();
        this.cssRules.addAll(groupingRule.getCssRules());
        for (AbstractCSSRule rule : this.cssRules) {
            rule.setParentRule(this);
        }
    }

    @Override
    void clear() {
        this.cssRules.clear();
        this.resetComments();
    }

    protected abstract void setGroupingRule(GroupingRule var1) throws DOMException;

    @Override
    boolean hasErrorsOrWarnings() {
        for (AbstractCSSRule rule : this.cssRules) {
            if (!rule.hasErrorsOrWarnings()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cssRules == null ? 0 : this.cssRules.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupingRule)) {
            return false;
        }
        GroupingRule other = (GroupingRule)obj;
        return !(this.cssRules == null ? other.cssRules != null : !this.cssRules.equals(other.cssRules));
    }

    private class RuleHandler
    extends SheetHandler {
        private AbstractCSSRule currentRule;
        private int currentInsertionIndex;

        private RuleHandler() {
            super((BaseCSSStyleSheet)GroupingRule.this.getParentStyleSheet(), GroupingRule.this.getOrigin(), (short)0);
            this.currentRule = null;
            this.currentInsertionIndex = 0;
        }

        public void setCurrentInsertionIndex(int index) {
            this.currentInsertionIndex = index;
        }

        @Override
        public void parseStart(ParserControl parserctl) {
            super.parseStart(parserctl);
            this.currentRule = null;
        }

        @Override
        public void importStyle(String uri, MediaQueryList media, String defaultNamespaceURI) {
        }

        @Override
        protected void addLocalRule(AbstractCSSRule rule) throws DOMException {
            if (this.currentRule != null) {
                throw new DOMException(13, "Attempted to parse more than one rule inside this one");
            }
            this.currentRule = rule;
            this.currentInsertionIndex = GroupingRule.this.insertRule(this.currentRule, this.currentInsertionIndex);
        }
    }
}

