/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.agent.HeadlessDeviceFactory;
import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSPropertyDefinition;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSStyleSheet;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingFactory;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.CSSValueMediaQueryFactory;
import io.sf.carte.doc.style.css.om.DefaultSheetErrorHandler;
import io.sf.carte.doc.style.css.om.DefaultStyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.om.DefaultStyleFormattingFactory;
import io.sf.carte.doc.style.css.om.LenientSystemDefaultValue;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.doc.style.css.om.MediaQueryListImpl;
import io.sf.carte.doc.style.css.om.PropertyDefinition;
import io.sf.carte.doc.style.css.om.StyleRule;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.SystemDefaultValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.agent.AgentUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Locale;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class BaseCSSStyleSheetFactory
extends AbstractCSSStyleSheetFactory {
    private static final long serialVersionUID = 1L;
    private static final String HTML_DEFAULT_SHEET = "/io/sf/carte/doc/style/css/html.css";
    private static final String HTML_DEFAULT_SHEET_QUIRKS = "/io/sf/carte/doc/style/css/html-quirks.css";
    private ClassLoader classLoader = null;
    private StyleFormattingFactory formattingFactory;
    private final EnumSet<Parser.Flag> parserFlags;
    private short flags = 0;
    private boolean lenientSystemValues = true;
    private AbstractCSSStyleSheet userImportantSheet = null;
    private AbstractCSSStyleSheet userNormalSheet = null;
    private DeviceFactory deviceFactory = null;

    protected BaseCSSStyleSheetFactory() {
        this(EnumSet.noneOf(Parser.Flag.class));
    }

    protected BaseCSSStyleSheetFactory(EnumSet<Parser.Flag> parserFlags) {
        this.parserFlags = parserFlags;
        this.setDeviceFactory(new HeadlessDeviceFactory());
        this.setStyleFormattingFactory(this.createDefaultStyleFormattingFactory());
    }

    protected StyleFormattingFactory createDefaultStyleFormattingFactory() {
        return new DefaultStyleFormattingFactory();
    }

    protected abstract BaseDocumentCSSStyleSheet createDocumentStyleSheet(byte var1);

    @Override
    public AbstractCSSStyleSheet createStyleSheet(String title, MediaQueryList media) {
        if (media == null) {
            media = CSSValueMediaQueryFactory.getAllMediaInstance();
        }
        return this.createLinkedStyleSheet(null, title, media);
    }

    @Override
    protected abstract AbstractCSSStyleSheet createRuleStyleSheet(AbstractCSSRule var1, String var2, MediaQueryList var3);

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    @Override
    public CSSPropertyDefinition createPropertyDefinition(String name, CSSValueSyntax syntax, boolean inherited, LexicalUnit initialValue) throws DOMException {
        if (name == null) {
            throw new NullPointerException("Null name.");
        }
        if (syntax == null) {
            throw new NullPointerException("Null syntax.");
        }
        if (initialValue == null) {
            if (syntax.getCategory() != CSSValueSyntax.Category.universal) {
                throw new DOMException(15, "Null initial value.");
            }
        } else if (initialValue.matches(syntax) != CSSValueSyntax.Match.TRUE) {
            throw new DOMException(15, "Value " + initialValue.getCssText() + " does not match syntax " + syntax.toString() + '.');
        }
        PropertyDefinition def = new PropertyDefinition(name, syntax, inherited, initialValue);
        return def;
    }

    @Override
    public StyleFormattingFactory getStyleFormattingFactory() {
        return this.formattingFactory;
    }

    @Override
    public void setStyleFormattingFactory(StyleFormattingFactory factory) {
        this.formattingFactory = factory;
    }

    @Override
    public void setUserStyleSheet(String url, Reader re) throws DOMException, IOException {
        block18: {
            if (re != null) {
                this.loadUserStyleSheet(url, re);
            } else {
                if (url != null) {
                    URI uri;
                    try {
                        uri = new URI(url);
                    }
                    catch (URISyntaxException e) {
                        throw new MalformedURLException(e.getMessage());
                    }
                    if (!uri.isAbsolute()) {
                        throw new MalformedURLException("Cannot convert relative URI " + uri);
                    }
                    URL href = uri.toURL();
                    URLConnection uconn = href.openConnection();
                    String conType = uconn.getContentType();
                    String contentEncoding = uconn.getContentEncoding();
                    try (InputStream is = uconn.getInputStream();
                         Reader reader = AgentUtil.inputStreamToReader((InputStream)is, (String)conType, (String)contentEncoding, (Charset)StandardCharsets.UTF_8);){
                        this.loadUserStyleSheet(href.toExternalForm(), reader);
                        break block18;
                    }
                }
                this.userImportantSheet = null;
                this.userNormalSheet = null;
            }
        }
    }

    private void loadUserStyleSheet(String url, Reader re) throws DOMException, IOException {
        BaseDocumentCSSStyleSheet cssSheet = this.createDocumentStyleSheet((byte)9);
        ((AbstractCSSStyleSheet)cssSheet).parseStyleSheet(re);
        this.userImportantSheet = this.createDocumentStyleSheet((byte)3);
        this.userNormalSheet = this.createDocumentStyleSheet((byte)9);
        this.userImportantSheet.setHref(url);
        this.userNormalSheet.setHref(url);
        this.userNormalSheet.getCssRules().ensureCapacity(((AbstractCSSStyleSheet)cssSheet).getCssRules().getLength());
        BaseCSSStyleSheetFactory.prioritySplit(cssSheet, this.userImportantSheet, this.userNormalSheet);
    }

    @Override
    public void setUserStyleSheet(Reader re) throws DOMException, IOException {
        this.setUserStyleSheet(null, re);
    }

    @Override
    protected AbstractCSSStyleSheet getUserImportantStyleSheet() {
        return this.userImportantSheet;
    }

    @Override
    protected AbstractCSSStyleSheet getUserNormalStyleSheet() {
        return this.userNormalSheet;
    }

    static void prioritySplit(AbstractCSSStyleSheet cssSheet, AbstractCSSStyleSheet importantSheet, AbstractCSSStyleSheet normalSheet) {
        AbstractCSSStyleDeclaration userImportantStyle = cssSheet.createStyleDeclaration();
        AbstractCSSStyleDeclaration userNormalStyle = cssSheet.createStyleDeclaration();
        CSSRuleArrayList rules = cssSheet.getCssRules();
        int rl = rules.getLength();
        for (int i = 0; i < rl; ++i) {
            AbstractCSSRule r = (AbstractCSSRule)rules.item(i);
            if (r.getType() == 1) {
                BaseCSSStyleDeclaration style;
                StyleRule newrule;
                userImportantStyle.clear();
                userNormalStyle.clear();
                StyleRule rule = (StyleRule)r;
                AbstractCSSStyleDeclaration st = rule.getStyle();
                st.prioritySplit(userImportantStyle, userNormalStyle);
                if (!userImportantStyle.isEmpty()) {
                    newrule = importantSheet.createStyleRule();
                    newrule.setSelectorList(rule.getSelectorList());
                    style = (BaseCSSStyleDeclaration)newrule.getStyle();
                    style.setProperties((BaseCSSStyleDeclaration)userImportantStyle);
                    importantSheet.addRule(newrule);
                }
                if (userNormalStyle.isEmpty()) continue;
                newrule = normalSheet.createStyleRule();
                newrule.setSelectorList(rule.getSelectorList());
                style = (BaseCSSStyleDeclaration)newrule.getStyle();
                style.setProperties((BaseCSSStyleDeclaration)userNormalStyle);
                normalSheet.addRule(newrule);
                continue;
            }
            normalSheet.addRule(r.clone(normalSheet));
        }
    }

    protected BaseDocumentCSSStyleSheet htmlDefaultSheet() throws IllegalStateException {
        InputStream is = this.loadCSSfromClasspath(HTML_DEFAULT_SHEET);
        try {
            return this.loadDefaultSheet(is);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read the default style sheet", e);
        }
    }

    protected BaseDocumentCSSStyleSheet htmlQuirksDefaultSheet() throws IllegalStateException {
        InputStream is = this.loadCSSfromClasspath(HTML_DEFAULT_SHEET_QUIRKS);
        try {
            return this.loadDefaultSheet(is);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read the default style sheet", e);
        }
    }

    private BaseDocumentCSSStyleSheet loadDefaultSheet(InputStream is) throws IOException {
        BaseDocumentCSSStyleSheet cssSheet;
        InputStreamReader re = null;
        try {
            re = new InputStreamReader(is, "UTF-8");
            cssSheet = this.createDocumentStyleSheet((byte)16);
            cssSheet.parseStyleSheet(re, (short)0);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (re != null) {
                try {
                    ((Reader)re).close();
                }
                catch (IOException iOException) {}
            }
        }
        return cssSheet;
    }

    private InputStream loadCSSfromClasspath(String cssFilename) {
        if (this.classLoader != null) {
            return this.classLoader.getResourceAsStream(BaseCSSStyleSheetFactory.resourcePath(BaseCSSStyleSheetFactory.class.getPackage().getName(), cssFilename));
        }
        return BaseCSSStyleSheetFactory.class.getResourceAsStream(cssFilename);
    }

    private static String resourcePath(String clase, String filename) {
        return '/' + clase.replace('.', '/') + '/' + filename;
    }

    @Override
    protected ValueFactory getValueFactory() {
        return new ValueFactory(this.flags);
    }

    @Override
    public void setFactoryFlag(short flag) {
        if (flag < 3) {
            this.flags = (short)(this.flags & 0x7C);
            this.flags = (short)(this.flags | flag);
        } else {
            this.flags = flag = (short)(flag | this.flags & 3);
        }
    }

    @Override
    protected boolean hasFactoryFlag(short flag) {
        return (this.flags & flag) == flag;
    }

    @Override
    public void setLenientSystemValues(boolean lenient) {
        this.lenientSystemValues = lenient;
    }

    @Override
    public TypedValue getSystemDefaultValue(String propertyName) {
        if (this.lenientSystemValues) {
            TypedValue value = null;
            if ("color".equals(propertyName = propertyName.toLowerCase(Locale.ROOT)) || propertyName.endsWith("-color")) {
                value = (TypedValue)new ValueFactory().parseProperty("#000");
                ((ColorValue)value).setSystemDefault();
                return value;
            }
            if ("font-family".equals(propertyName)) {
                value = (TypedValue)new ValueFactory().parseProperty("serif");
                return new LenientSystemDefaultValue((CSSTypedValue)value);
            }
        }
        return SystemDefaultValue.getInstance();
    }

    @Override
    protected Parser createSACParser() {
        CSSOMParser parser = new CSSOMParser();
        EnumSet<Parser.Flag> flags = this.getParserFlags();
        for (Parser.Flag flag : flags) {
            parser.setFlag(flag);
        }
        return parser;
    }

    @Override
    protected EnumSet<Parser.Flag> getParserFlags() {
        return this.parserFlags;
    }

    @Override
    protected boolean hasCompatValueFlags() {
        EnumSet<Parser.Flag> flags = this.parserFlags;
        return flags.contains((Object)Parser.Flag.IEVALUES) || flags.contains((Object)Parser.Flag.IEPRIO) || flags.contains((Object)Parser.Flag.IEPRIOCHAR);
    }

    @Override
    public StyleDeclarationErrorHandler createInlineStyleErrorHandler(CSSElement owner) {
        return new DefaultStyleDeclarationErrorHandler();
    }

    @Override
    public StyleDeclarationErrorHandler createStyleDeclarationErrorHandler(CSSDeclarationRule rule) {
        return new DefaultStyleDeclarationErrorHandler();
    }

    @Override
    public SheetErrorHandler createSheetErrorHandler(CSSStyleSheet<? extends CSSRule> sheet) {
        return new DefaultSheetErrorHandler(sheet);
    }

    @Override
    public MediaQueryList createMediaQueryList(String mediaQueryString, Node owner) throws CSSBudgetException {
        if (mediaQueryString == null) {
            return new MediaQueryListImpl();
        }
        return this.parseMediaQueryList(mediaQueryString, owner);
    }

    @Override
    public MediaQueryList createImmutableMediaQueryList(String media, Node owner) throws CSSBudgetException {
        if (media == null) {
            return CSSValueMediaQueryFactory.getAllMediaInstance();
        }
        return ((MediaListAccess)((Object)this.parseMediaQueryList(media, owner))).unmodifiable();
    }

    MediaQueryList parseMediaQueryList(String mediaQueryString, Node owner) throws CSSBudgetException {
        CSSOMParser parser = new CSSOMParser();
        if (this.getParserFlags().contains((Object)Parser.Flag.IEVALUES)) {
            parser.setFlag(Parser.Flag.IEVALUES);
        }
        return parser.parseMediaQueryList(mediaQueryString, owner);
    }

    @Override
    public DeviceFactory getDeviceFactory() {
        return this.deviceFactory;
    }

    public void setDeviceFactory(DeviceFactory deviceFactory) {
        this.deviceFactory = deviceFactory;
    }
}

