/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSDeclarationRule;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSNamespaceRule;
import io.sf.carte.doc.style.css.CSSStyleRule;
import io.sf.carte.doc.style.css.CSSStyleSheet;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.nsac.SheetContext;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.AbstractStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.FontFaceRule;
import io.sf.carte.doc.style.css.om.ImportRule;
import io.sf.carte.doc.style.css.om.MediaRule;
import io.sf.carte.doc.style.css.om.PageRule;
import io.sf.carte.doc.style.css.om.StyleRule;
import io.sf.carte.doc.style.css.om.SupportsRule;
import io.sf.carte.doc.style.css.om.UnknownRule;
import io.sf.carte.doc.style.css.om.ViewportRule;
import io.sf.carte.util.Visitor;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class AbstractCSSStyleSheet
extends AbstractStyleSheet
implements CSSStyleSheet<AbstractCSSRule>,
SheetContext {
    private static final long serialVersionUID = 1L;
    static final int CONNECT_TIMEOUT = 10000;

    protected AbstractCSSStyleSheet(String title) {
        super(title);
    }

    @Override
    public abstract CSSRuleArrayList getCssRules();

    @Override
    public abstract AbstractCSSStyleSheet getParentStyleSheet();

    @Override
    public abstract AbstractCSSRule getOwnerRule();

    @Override
    public abstract AbstractCSSStyleSheetFactory getStyleSheetFactory();

    @Override
    public abstract boolean parseStyleSheet(Reader var1) throws DOMException, IOException;

    @Override
    public abstract boolean parseStyleSheet(Reader var1, short var2) throws DOMException, IOException;

    @Override
    public abstract void addStyleSheet(AbstractCSSStyleSheet var1);

    public abstract boolean loadStyleSheet(URL var1, String var2) throws DOMException, IOException;

    @Override
    public abstract FontFaceRule createFontFaceRule();

    @Override
    public abstract ImportRule createImportRule(MediaQueryList var1, String var2);

    @Override
    public abstract MediaRule createMediaRule(MediaQueryList var1);

    @Override
    public abstract PageRule createPageRule();

    @Override
    public abstract StyleRule createStyleRule();

    @Override
    public abstract SupportsRule createSupportsRule(String var1) throws DOMException;

    @Override
    public abstract SupportsRule createSupportsRule(BooleanCondition var1);

    @Override
    @Deprecated
    public abstract SupportsRule createSupportsRule();

    @Override
    public abstract UnknownRule createUnknownRule();

    @Override
    public abstract ViewportRule createViewportRule();

    @Override
    public abstract AbstractCSSStyleDeclaration createStyleDeclaration();

    protected abstract AbstractCSSStyleDeclaration createStyleDeclaration(BaseCSSDeclarationRule var1);

    protected abstract void registerNamespace(CSSNamespaceRule var1);

    protected abstract void unregisterNamespace(String var1);

    @Override
    public abstract String getNamespacePrefix(String var1);

    @Override
    public abstract boolean hasDefaultNamespace();

    @Override
    public boolean hasFactoryFlag(short flag) {
        return this.getStyleSheetFactory().hasFactoryFlag(flag);
    }

    public abstract void setHref(String var1);

    public abstract byte getOrigin();

    @Override
    public abstract AbstractCSSStyleSheet clone();

    @Override
    public URLConnection openConnection(URL url, String referrerPolicy) throws IOException {
        URLConnection ucon;
        Node node;
        AbstractCSSStyleSheet pss;
        CSSDocument doc = null;
        if (this.getOwnerNode() != null) {
            doc = (CSSDocument)this.getOwnerNode().getOwnerDocument();
        } else if (this.getOwnerRule() != null && (pss = this.getOwnerRule().getParentStyleSheet()) != null && (node = pss.getOwnerNode()) != null) {
            doc = node.getNodeType() != 9 ? (CSSDocument)node.getOwnerDocument() : (CSSDocument)node;
        }
        if (doc != null) {
            ucon = doc.openConnection(url);
            String docuri = doc.getDocumentURI();
            if (docuri != null) {
                String referrer;
                if ("".equals(referrerPolicy)) {
                    referrerPolicy = doc.getReferrerPolicy();
                }
                if ((referrer = this.getReferrer(docuri, url, referrerPolicy)) != null) {
                    ucon.setRequestProperty("Referer", referrer);
                }
            }
        } else {
            ucon = url.openConnection();
        }
        ucon.setAllowUserInteraction(false);
        ucon.setConnectTimeout(10000);
        return ucon;
    }

    private String getReferrer(String referrer, URL destinationUrl, String referrerPolicy) {
        if ("no-referrer".equals(referrerPolicy)) {
            referrer = null;
        } else if ("origin".equals(referrerPolicy)) {
            referrer = this.getOrigin(referrer);
        } else if ("same-origin".equals(referrerPolicy)) {
            referrer = this.getSameOrigin(referrer, destinationUrl);
        } else if ("strict-origin".equals(referrerPolicy)) {
            referrer = this.getStrictOrigin(referrer, destinationUrl);
        } else if (!"unsafe-url".equals(referrerPolicy)) {
            referrer = this.getNoReferrerWhenDowngrade(referrer, destinationUrl);
        }
        return referrer;
    }

    private String getOrigin(String referrer) {
        try {
            URI uri = new URI(referrer);
            if (!AbstractCSSStyleSheet.isLocalScheme(uri.getScheme())) {
                return AbstractCSSStyleSheet.referrerURL(uri.toURL(), "/");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getSameOrigin(String referrer, URL destinationUrl) {
        try {
            String desthost;
            URI uri = new URI(referrer);
            if (!AbstractCSSStyleSheet.isLocalScheme(uri.getScheme()) && (desthost = destinationUrl.getHost()) != null && desthost.equalsIgnoreCase(uri.getHost())) {
                return AbstractCSSStyleSheet.referrerURL(uri.toURL(), uri.getRawPath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getStrictOrigin(String referrer, URL destinationUrl) {
        try {
            URI uri = new URI(referrer);
            if (!AbstractCSSStyleSheet.isLocalScheme(uri.getScheme())) {
                String destproto = destinationUrl.getProtocol();
                String desthost = destinationUrl.getHost();
                if (!"https".equals(uri.getScheme()) || "https".equals(destproto) && desthost != null && desthost.equalsIgnoreCase(uri.getHost())) {
                    return AbstractCSSStyleSheet.referrerURL(uri.toURL(), "/");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getNoReferrerWhenDowngrade(String referrer, URL destinationUrl) {
        try {
            URI uri = new URI(referrer);
            if (!AbstractCSSStyleSheet.isLocalScheme(uri.getScheme())) {
                String destproto = destinationUrl.getProtocol();
                if (!"https".equals(uri.getScheme()) || "https".equals(destproto)) {
                    return AbstractCSSStyleSheet.referrerURL(uri.toURL(), uri.getRawPath());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String referrerURL(URL url, String file) throws MalformedURLException, URISyntaxException {
        URI uri = new URI(url.getProtocol(), null, url.getHost(), AbstractCSSStyleSheet.urlPort(url), file, null, null);
        return uri.toASCIIString();
    }

    private static boolean isLocalScheme(String proto) {
        return !"https".equals(proto) && !"http".equals(proto);
    }

    private static int urlPort(URL url) {
        int port = url.getPort();
        if (port == url.getDefaultPort()) {
            port = -1;
        }
        return port;
    }

    public abstract StyleRule getFirstStyleRule(SelectorList var1);

    public abstract CSSRuleArrayList getStyleRules(Selector var1);

    public abstract void acceptStyleRuleVisitor(Visitor<CSSStyleRule> var1);

    public abstract void acceptDeclarationRuleVisitor(Visitor<CSSDeclarationRule> var1);

    public abstract void acceptDescriptorRuleVisitor(Visitor<CSSDeclarationRule> var1);

    protected abstract void setParentStyleSheet(AbstractCSSStyleSheet var1);

    public static byte parseRelAttribute(String relText) {
        boolean styleSheet = false;
        boolean alternate = false;
        byte result = -1;
        int idx = (relText = relText.trim()).indexOf(32);
        if (idx == -1) {
            boolean bl = styleSheet = relText.length() == 0 || relText.equalsIgnoreCase("stylesheet");
            if (!styleSheet) {
                styleSheet = alternate = "alternate".equalsIgnoreCase(relText);
            }
        } else {
            String first = relText.substring(0, idx);
            String second = relText.substring(idx + 1).trim();
            alternate = "alternate".equalsIgnoreCase(first) || "alternate".equalsIgnoreCase(second);
            boolean bl = styleSheet = alternate && ("stylesheet".equalsIgnoreCase(second) || "stylesheet".equalsIgnoreCase(first));
        }
        if (styleSheet) {
            result = alternate ? (byte)1 : 0;
        }
        return result;
    }
}

