/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.agent;

import io.sf.carte.doc.agent.Cookie;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;

@Deprecated(forRemoval=true)
public class DefaultCookie
implements Cookie,
Serializable,
Cloneable {
    private static final long serialVersionUID = 3L;
    private long creationTime;
    private long expiryTime = 0L;
    private String name = null;
    private String value = null;
    private String domain = null;
    private String path = null;
    private boolean secure = false;
    private boolean httpOnly = false;
    private String comment = null;

    public DefaultCookie() {
        this(null, null);
    }

    public DefaultCookie(String name, String value) {
        this(name, value, System.currentTimeMillis());
    }

    public DefaultCookie(String name, String value, long creationTime) {
        this.name = name;
        this.value = value;
        this.creationTime = creationTime;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void setCreationTime(long time) {
        this.creationTime = time;
    }

    @Override
    public long getExpiryTime() {
        return this.expiryTime;
    }

    @Override
    public void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void setSecure() {
        this.secure = true;
    }

    @Override
    public boolean isPersistent() {
        return this.expiryTime != 0L;
    }

    @Override
    public void setHttpOnly() {
        this.httpOnly = true;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.name, this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultCookie other = (DefaultCookie)obj;
        return Objects.equals(this.domain, other.domain) && Objects.equals(this.name, other.name) && Objects.equals(this.path, other.path);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(32);
        buf.append(this.name);
        buf.append('=');
        buf.append(URLEncoder.encode(this.value, StandardCharsets.UTF_8));
        buf.append(";Domain=");
        buf.append(this.domain);
        buf.append(";Path=");
        buf.append(this.path);
        if (this.isPersistent()) {
            SimpleDateFormat cookieDateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz", Locale.ROOT);
            Date date = new Date(this.expiryTime);
            buf.append(";Expires=");
            buf.append(cookieDateFormat.format(date));
        }
        if (this.secure) {
            buf.append(";Secure");
        }
        if (this.httpOnly) {
            buf.append(";HttpOnly");
        }
        return buf.toString();
    }

    public DefaultCookie clone() {
        DefaultCookie clon;
        try {
            clon = (DefaultCookie)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        clon.domain = this.domain;
        clon.path = this.path;
        clon.name = this.name;
        clon.value = this.value;
        clon.secure = this.secure;
        clon.httpOnly = this.httpOnly;
        clon.creationTime = this.creationTime;
        clon.expiryTime = this.expiryTime;
        clon.comment = this.comment;
        return clon;
    }

    static class CookieComparator
    implements Comparator<Cookie> {
        CookieComparator() {
        }

        @Override
        public int compare(Cookie c1, Cookie c2) {
            return c2.getPath().length() - c1.getPath().length();
        }
    }
}

