/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.refactoring.AutoValue_CodeReplacement;
import java.util.Comparator;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class CodeReplacement
implements Comparable<CodeReplacement> {
    private static final Comparator<CodeReplacement> APPLICATION_ORDER = Comparator.comparingInt(CodeReplacement::getStartPosition).thenComparingInt(CodeReplacement::getLength).thenComparing(CodeReplacement::getSortKey).thenComparing(CodeReplacement::getNewContent);

    static CodeReplacement create(int startPosition, int length, String newContent) {
        return CodeReplacement.create(startPosition, length, newContent, "");
    }

    static CodeReplacement create(int startPosition, int length, String newContent, String sortKey) {
        return new AutoValue_CodeReplacement(startPosition, length, newContent, sortKey);
    }

    public abstract int getStartPosition();

    public abstract int getLength();

    public int getEndPosition() {
        return this.getStartPosition() + this.getLength();
    }

    public abstract String getNewContent();

    abstract String getSortKey();

    @Override
    public final int compareTo(CodeReplacement x) {
        return APPLICATION_ORDER.compare(this, x);
    }
}

