/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMapInput;
import com.google.javascript.jscomp.SourceMapResolver;
import com.google.javascript.jscomp.base.JSCompObjects;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.serialization.AutoValue_TypedAstDeserializer_DeserializedAst;
import com.google.javascript.jscomp.serialization.ColorPool;
import com.google.javascript.jscomp.serialization.LazyAst;
import com.google.javascript.jscomp.serialization.ScriptNodeDeserializer;
import com.google.javascript.jscomp.serialization.SourceFileProto;
import com.google.javascript.jscomp.serialization.StringPool;
import com.google.javascript.jscomp.serialization.TypedAst;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.nullness.Nullable;

@GwtIncompatible(value="protobuf.lite")
public final class TypedAstDeserializer {
    private final Mode mode;
    private final SourceFile syntheticExterns;
    private final Optional<ColorPool.Builder> colorPoolBuilder;
    private final Optional<ImmutableSet<SourceFile>> requiredInputFiles;
    private final LinkedHashMap<String, SourceFile> filePoolBuilder = new LinkedHashMap();
    private final ConcurrentMap<SourceFile, Supplier<Node>> typedAstFilesystem = new ConcurrentHashMap<SourceFile, Supplier<Node>>();
    private final ImmutableSet.Builder<String> externProperties = ImmutableSet.builder();
    private final ArrayList<ScriptNodeDeserializer> syntheticExternsDeserializers = new ArrayList();

    private TypedAstDeserializer(SourceFile syntheticExterns, Optional<ColorPool.Builder> existingColorPool, Optional<ImmutableSet<SourceFile>> requiredInputFiles, Mode mode, boolean includeTypeInformation) {
        this.syntheticExterns = syntheticExterns;
        this.mode = mode;
        this.colorPoolBuilder = includeTypeInformation ? Optional.of((Object)((ColorPool.Builder)existingColorPool.or((Object)ColorPool.builder()))) : Optional.absent();
        this.requiredInputFiles = requiredInputFiles;
    }

    public static DeserializedAst deserializeFullAst(AbstractCompiler compiler, SourceFile syntheticExterns, ImmutableSet<SourceFile> requiredInputFiles, InputStream typedAstsStream, boolean includeTypeInformation, boolean resolveSourceMapAnnotations, boolean parseInlineSourceMaps) {
        ImmutableMap sourceFilesByName = (ImmutableMap)requiredInputFiles.stream().collect(ImmutableMap.toImmutableMap(SourceFile::getName, Function.identity()));
        return TypedAstDeserializer.deserialize(compiler, syntheticExterns, (Optional<ImmutableSet<SourceFile>>)Optional.of(requiredInputFiles), (ImmutableMap<String, SourceFile>)sourceFilesByName, (Optional<ColorPool.Builder>)Optional.absent(), typedAstsStream, Mode.FULL_AST, includeTypeInformation, resolveSourceMapAnnotations, parseInlineSourceMaps);
    }

    public static DeserializedAst deserializeRuntimeLibraries(AbstractCompiler compiler, SourceFile syntheticExterns, Optional<ColorPool.Builder> colorPool, InputStream typedAstsStream, boolean resolveSourceMapAnnotations, boolean parseInlineSourceMaps) {
        return TypedAstDeserializer.deserialize(compiler, syntheticExterns, (Optional<ImmutableSet<SourceFile>>)Optional.absent(), (ImmutableMap<String, SourceFile>)ImmutableMap.of(), colorPool, typedAstsStream, Mode.RUNTIME_LIBRARY_ONLY, colorPool.isPresent(), resolveSourceMapAnnotations, parseInlineSourceMaps);
    }

    private static DeserializedAst deserialize(AbstractCompiler compiler, SourceFile syntheticExterns, Optional<ImmutableSet<SourceFile>> requiredInputFiles, ImmutableMap<String, SourceFile> scriptSourceFiles, Optional<ColorPool.Builder> colorPool, InputStream typedAstStream, Mode mode, boolean includeTypeInformation, boolean resolveSourceMapAnnotations, boolean parseInlineSourceMaps) {
        Preconditions.checkArgument((colorPool.isPresent() == (mode.equals((Object)Mode.RUNTIME_LIBRARY_ONLY) && includeTypeInformation) ? 1 : 0) != 0, (Object)"ColorPool.Builder required iff deserializing runtime libraries & including types");
        TypedAstDeserializer deserializer = new TypedAstDeserializer(syntheticExterns, colorPool, requiredInputFiles, mode, includeTypeInformation);
        deserializer.filePoolBuilder.put(syntheticExterns.getName(), syntheticExterns);
        deserializer.filePoolBuilder.putAll((Map<String, SourceFile>)scriptSourceFiles);
        if (!mode.equals((Object)Mode.RUNTIME_LIBRARY_ONLY)) {
            compiler.initRuntimeLibraryTypedAsts(deserializer.colorPoolBuilder);
        }
        TypedAstDeserializer.deserializeTypedAsts(typedAstStream, deserializer, compiler, resolveSourceMapAnnotations, parseInlineSourceMaps);
        deserializer.typedAstFilesystem.put(syntheticExterns, new SyntheticExternsDeserializer(syntheticExterns, deserializer.syntheticExternsDeserializers)::deserialize);
        return deserializer.toDeserializedAst();
    }

    private DeserializedAst toDeserializedAst() {
        Optional registry = this.mode.equals((Object)Mode.RUNTIME_LIBRARY_ONLY) || !this.colorPoolBuilder.isPresent() ? Optional.absent() : Optional.of((Object)((ColorPool.Builder)this.colorPoolBuilder.get()).build().getRegistry());
        return DeserializedAst.create(this.typedAstFilesystem, (Optional<ColorRegistry>)registry, (ImmutableSet<String>)this.externProperties.build());
    }

    private void deserializeTypedAst(TypedAst typedAstProto, AbstractCompiler compiler, boolean resolveSourceMapAnnotations, boolean parseInlineSourceMaps) {
        ImmutableList<SourceFile> fileShard = this.toFileShard(typedAstProto);
        if (this.mode.equals((Object)Mode.FULL_AST)) {
            boolean containsRequiredInput = false;
            for (LazyAst lazyAst : Iterables.concat(typedAstProto.getExternAstList(), typedAstProto.getCodeAstList())) {
                SourceFile file = (SourceFile)fileShard.get(lazyAst.getSourceFile() - 1);
                if (!((ImmutableSet)this.requiredInputFiles.get()).contains((Object)file)) continue;
                containsRequiredInput = true;
                break;
            }
            if (!containsRequiredInput) {
                return;
            }
        }
        StringPool stringShard = StringPool.fromProto(typedAstProto.getStringPool());
        Optional colorShard = this.colorPoolBuilder.transform(builder -> builder.addShard(typedAstProto.getTypePool(), stringShard));
        for (int x : typedAstProto.getExternsSummary().getPropNamePtrList()) {
            this.externProperties.add((Object)stringShard.get(x));
        }
        for (LazyAst lazyAst : Iterables.concat(typedAstProto.getExternAstList(), typedAstProto.getCodeAstList())) {
            this.initLazyAstDeserializer(lazyAst, fileShard, (Optional<ColorPool.ShardView>)colorShard, stringShard, compiler, resolveSourceMapAnnotations, parseInlineSourceMaps);
        }
    }

    private ImmutableList<SourceFile> toFileShard(TypedAst typedAstProto) {
        ImmutableList.Builder fileShardBuilder = ImmutableList.builder();
        List<SourceFileProto> protos = typedAstProto.getSourceFilePool().getSourceFileList();
        for (int i = 0; i < protos.size(); ++i) {
            SourceFileProto p = protos.get(i);
            SourceFile existingFile = this.filePoolBuilder.get(p.getFilename());
            if (existingFile != null) {
                existingFile.restoreCachedStateFrom(p);
                fileShardBuilder.add((Object)existingFile);
                continue;
            }
            SourceFile protoFile = SourceFile.fromProto(p);
            fileShardBuilder.add((Object)protoFile);
        }
        return fileShardBuilder.build();
    }

    private void initLazyAstDeserializer(LazyAst lazyAst, ImmutableList<SourceFile> fileShard, Optional<ColorPool.ShardView> colorShard, StringPool stringShard, AbstractCompiler compiler, boolean resolveSourceMapAnnotations, boolean parseInlineSourceMaps) {
        SourceFile file = (SourceFile)fileShard.get(lazyAst.getSourceFile() - 1);
        if (this.requiredInputFiles.isPresent() && !((ImmutableSet)this.requiredInputFiles.get()).contains((Object)file) && !JSCompObjects.identical(this.syntheticExterns, file)) {
            return;
        }
        if (file.isWeak()) {
            this.typedAstFilesystem.computeIfAbsent(file, TypedAstDeserializer::createStubWeakScriptNode);
            return;
        }
        ScriptNodeDeserializer deserializer = new ScriptNodeDeserializer(lazyAst, stringShard, colorShard, fileShard);
        if (JSCompObjects.identical(this.syntheticExterns, file)) {
            this.syntheticExternsDeserializers.add(deserializer);
        } else {
            this.typedAstFilesystem.computeIfAbsent(file, f -> deserializer::deserializeNew);
        }
        TypedAstDeserializer.addInputSourceMap(deserializer, compiler, resolveSourceMapAnnotations, parseInlineSourceMaps);
    }

    private static void addInputSourceMap(ScriptNodeDeserializer deserializer, AbstractCompiler compiler, boolean resolveSourceMapAnnotations, boolean parseInlineSourceMaps) {
        String base64EncodedSourceMap;
        SourceFile sourceMapSourceFile;
        SourceFile sourceFile = deserializer.getSourceFile();
        String sourceMappingURL = deserializer.getSourceMappingURL();
        if (sourceMappingURL != null && sourceMappingURL.length() > 0 && resolveSourceMapAnnotations && (sourceMapSourceFile = SourceMapResolver.extractSourceMap(sourceFile, base64EncodedSourceMap = SourceMapResolver.addBase64PrefixToEncodedSourceMap(sourceMappingURL), parseInlineSourceMaps)) != null) {
            compiler.addInputSourceMap(sourceFile.getName(), new SourceMapInput(sourceMapSourceFile));
        }
    }

    private static Supplier<Node> createStubWeakScriptNode(SourceFile file) {
        return () -> {
            Node stubScript = IR.script().setStaticSourceFile(file);
            stubScript.putProp(Node.FEATURE_SET, FeatureSet.BARE_MINIMUM);
            return stubScript;
        };
    }

    @GwtIncompatible(value="ObjectInputStream")
    private static void deserializeTypedAsts(InputStream typedAstsStream, TypedAstDeserializer deserializer, AbstractCompiler compiler, boolean resolveSourceMapAnnotations, boolean parseInlineSourceMaps) {
        try {
            CodedInputStream codedInput = CodedInputStream.newInstance((InputStream)typedAstsStream);
            TypedAst.Builder typedAstBuilder = TypedAst.newBuilder();
            while (!codedInput.isAtEnd()) {
                int tag = codedInput.readTag();
                if (WireFormat.getTagFieldNumber((int)tag) != 1 || WireFormat.getTagWireType((int)tag) != 2) {
                    throw new InvalidProtocolBufferException("Unexpected field number " + WireFormat.getTagFieldNumber((int)tag) + " or wire type " + WireFormat.getTagWireType((int)tag));
                }
                codedInput.readMessage((MessageLite.Builder)typedAstBuilder, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
                TypedAst typedAst = typedAstBuilder.build();
                typedAstBuilder.clear();
                deserializer.deserializeTypedAst(typedAst, compiler, resolveSourceMapAnnotations, parseInlineSourceMaps);
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot read from TypedAST input stream", ex);
        }
    }

    @AutoValue
    public static abstract class DeserializedAst {
        public abstract ConcurrentMap<SourceFile, Supplier<Node>> getFilesystem();

        public abstract Optional<ColorRegistry> getColorRegistry();

        public abstract @Nullable ImmutableSet<String> getExternProperties();

        private static DeserializedAst create(ConcurrentMap<SourceFile, Supplier<Node>> filesystem, Optional<ColorRegistry> colorRegistry, ImmutableSet<String> externProperties) {
            return new AutoValue_TypedAstDeserializer_DeserializedAst(filesystem, colorRegistry, externProperties);
        }
    }

    private static final class SyntheticExternsDeserializer {
        private final SourceFile syntheticExterns;
        private final ArrayList<ScriptNodeDeserializer> syntheticExternsDeserializers;

        SyntheticExternsDeserializer(SourceFile syntheticExterns, ArrayList<ScriptNodeDeserializer> syntheticExternsDeserializers) {
            this.syntheticExterns = syntheticExterns;
            this.syntheticExternsDeserializers = syntheticExternsDeserializers;
        }

        Node deserialize() {
            Node script = IR.script();
            script.setStaticSourceFile(this.syntheticExterns);
            for (ScriptNodeDeserializer d : this.syntheticExternsDeserializers) {
                script.addChildrenToBack(d.deserializeNew().removeChildren());
            }
            return script;
        }
    }

    private static enum Mode {
        RUNTIME_LIBRARY_ONLY,
        FULL_AST;

    }
}

