/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.serialization;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.StandardColors;

final class TypePointers {
    static final ImmutableList<Color> OFFSET_TO_AXIOMATIC_COLOR = ImmutableList.of((Object)StandardColors.UNKNOWN, (Object)StandardColors.BOOLEAN, (Object)StandardColors.STRING, (Object)StandardColors.NUMBER, (Object)StandardColors.NULL_OR_VOID, (Object)StandardColors.SYMBOL, (Object)StandardColors.BIGINT, (Object)StandardColors.TOP_OBJECT);
    static final int AXIOMATIC_COLOR_COUNT = OFFSET_TO_AXIOMATIC_COLOR.size();

    static int trimOffset(int x) {
        Preconditions.checkState((x >= AXIOMATIC_COLOR_COUNT ? 1 : 0) != 0, (Object)x);
        return x - AXIOMATIC_COLOR_COUNT;
    }

    static int untrimOffset(int x) {
        Preconditions.checkState((x >= 0 ? 1 : 0) != 0, (Object)x);
        return x + AXIOMATIC_COLOR_COUNT;
    }

    static boolean isAxiomatic(int x) {
        return x < AXIOMATIC_COLOR_COUNT;
    }

    private TypePointers() {
        throw new AssertionError();
    }
}

